/*
 * Decompiled with CFR 0.152.
 */
package com.mna.factions;

import com.mna.Registries;
import com.mna.api.faction.BaseFaction;
import com.mna.api.faction.FactionIDs;
import com.mna.api.faction.IFaction;
import com.mna.api.faction.IFactionHelper;
import com.mna.factions.Council;
import com.mna.factions.Demons;
import com.mna.factions.FeyCourt;
import com.mna.factions.Undead;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Factions
implements IFactionHelper {
    public static final Factions INSTANCE = new Factions();
    public static final BaseFaction COUNCIL = new Council();
    public static final BaseFaction DEMONS = new Demons();
    public static final BaseFaction FEY = new FeyCourt();
    public static final BaseFaction UNDEAD = new Undead();

    @SubscribeEvent
    public static void registerFactions(RegisterEvent event) {
        event.register(Registries.Factions.get().getRegistryKey(), helper -> {
            helper.register(FactionIDs.COUNCIL, (Object)COUNCIL);
            helper.register(FactionIDs.DEMONS, (Object)DEMONS);
            helper.register(FactionIDs.FEY, (Object)FEY);
            helper.register(FactionIDs.UNDEAD, (Object)UNDEAD);
        });
    }

    @Override
    public List<IFaction> getAllFactions() {
        return Registries.Factions.get().getValues().stream().toList();
    }

    @Override
    public List<IFaction> getFactionsExcept(IFaction ... exclusions) {
        List<IFaction> excludeIDs = Arrays.asList(exclusions);
        return Registries.Factions.get().getValues().stream().filter(f -> !excludeIDs.contains(f)).toList();
    }

    @Override
    public IFaction getFaction(ResourceLocation id) {
        return (IFaction)Registries.Factions.get().getValue(id);
    }
}

