/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import com.mna.entities.EntityInit;
import com.mna.tools.BlockUtils;
import com.mna.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class FillHole
extends Entity {
    private static final String NBT_BLOCK = "place_block";
    private static final String NBT_POSITIONS = "positions";
    private static final String NBT_INDEX = "place_index";
    private static final String NBT_RADIUS = "radius";
    private static final String NBT_HEIGHT = "height";
    private static final String NBT_FINISHED_SCAN = "finished_scan";
    private static final String NBT_PLAYER_ID = "player_uuid";
    private Block placeBlock;
    private ArrayList<BlockPos> positions = new ArrayList();
    private int placeIndex = 0;
    private byte radius = 0;
    private byte height = 0;
    private boolean isValid = false;
    private boolean finishedScan = false;
    private UUID playerID = null;
    private Player player = null;

    public FillHole(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
        this.f_19850_ = false;
    }

    public FillHole(Level world, Block toPlace, BlockPos center, Player caster, int height, int radius) {
        this((EntityType)EntityInit.FILL_HOLE.get(), world);
        this.setData(toPlace, center, caster, height, radius);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.isValid) {
            this.m_146870_();
            return;
        }
        if (!this.finishedScan) {
            if (this.placeIndex < this.height) {
                if (!this.scanLayer(this.m_20183_().m_7918_(0, this.placeIndex++, 0))) {
                    this.positions = (ArrayList)this.positions.stream().map(bp -> bp.m_121878_()).distinct().map(l -> BlockPos.m_122022_((long)l)).collect(Collectors.toList());
                    this.finishedScan = true;
                    this.placeIndex = 0;
                }
            } else {
                this.positions = (ArrayList)this.positions.stream().map(bp -> bp.m_121878_()).distinct().map(l -> BlockPos.m_122022_((long)l)).collect(Collectors.toList());
                this.placeIndex = 0;
                this.finishedScan = true;
            }
        } else if (!this.tryPlaceBlock()) {
            this.m_146870_();
        }
    }

    private boolean tryPlaceBlock() {
        Player player = this.resolvePlayer();
        if (player == null) {
            return false;
        }
        if (this.placeIndex >= this.positions.size()) {
            return false;
        }
        BlockPos placePos = this.positions.get(this.placeIndex++);
        ItemStack stack = new ItemStack((ItemLike)this.placeBlock);
        BlockHitResult bhr = new BlockHitResult(Vec3.m_82512_((Vec3i)placePos), this.m_6350_(), placePos, true);
        BlockPlaceContext ctx = new BlockPlaceContext(player, InteractionHand.OFF_HAND, stack, bhr);
        BlockState prevState = this.m_9236_().m_8055_(placePos);
        if (this.m_9236_().m_45784_((Entity)this) && prevState.m_60629_(ctx) && BlockUtils.placeBlock((ServerLevel)this.m_9236_(), placePos, Direction.DOWN, this.placeBlock.m_49966_(), player) && !player.m_7500_() && !InventoryUtilities.removeItemFromInventory(stack, true, true, (IItemHandler)new InvWrapper((Container)player.m_150109_()))) {
            this.m_9236_().m_7731_(placePos, prevState, 3);
            return false;
        }
        return true;
    }

    @Nullable
    private Player resolvePlayer() {
        if (this.playerID == null) {
            return null;
        }
        if (this.player == null) {
            this.player = this.m_9236_().m_46003_(this.playerID);
        }
        return this.player;
    }

    public void setData(Block toPlace, BlockPos center, Player caster, int height, int radius) {
        this.placeBlock = toPlace;
        this.m_6034_((float)center.m_123341_() + 0.5f, (float)center.m_123342_() + 0.5f, (float)center.m_123343_() + 0.5f);
        this.height = (byte)height;
        this.radius = (byte)radius;
        if (caster.m_36316_() != null) {
            this.playerID = caster.m_36316_().getId();
            this.player = caster;
            this.isValid = true;
        } else {
            this.isValid = false;
        }
    }

    private boolean scanLayer(BlockPos center) {
        ArrayList<BlockPos> foundPositions = new ArrayList<BlockPos>();
        BlockHitResult posZ = this.m_9236_().m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)center), Vec3.m_82512_((Vec3i)center.m_7918_(0, 0, (int)this.radius)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        BlockHitResult negZ = this.m_9236_().m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)center), Vec3.m_82512_((Vec3i)center.m_7918_(0, 0, (int)(-this.radius))), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        BlockHitResult posX = this.m_9236_().m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)center), Vec3.m_82512_((Vec3i)center.m_7918_((int)this.radius, 0, 0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        BlockHitResult negX = this.m_9236_().m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)center), Vec3.m_82512_((Vec3i)center.m_7918_((int)(-this.radius), 0, 0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (!(posZ.m_6662_() != HitResult.Type.MISS && negZ.m_6662_() != HitResult.Type.MISS || posX.m_6662_() != HitResult.Type.MISS && negX.m_6662_() != HitResult.Type.MISS)) {
            return false;
        }
        int rPZ = posZ.m_6662_() == HitResult.Type.MISS ? this.radius : Math.abs(center.m_123343_() - posZ.m_82425_().m_123343_());
        int rNZ = negZ.m_6662_() == HitResult.Type.MISS ? -this.radius : -Math.abs(center.m_123343_() - negZ.m_82425_().m_123343_());
        int rPX = posX.m_6662_() == HitResult.Type.MISS ? this.radius : Math.abs(center.m_123341_() - posX.m_82425_().m_123341_());
        int rNX = negX.m_6662_() == HitResult.Type.MISS ? -this.radius : -Math.abs(center.m_123341_() - negX.m_82425_().m_123341_());
        int zLen = rPZ - rNZ;
        int xLen = rPX - rNX;
        boolean zAxis = zLen >= xLen;
        for (int i = zAxis ? rNZ : rNX; i < (zAxis ? rPZ : rPX); ++i) {
            BlockPos offsetPos = center.m_7918_(zAxis ? 0 : i, 0, zAxis ? i : 0);
            BlockPos rayEndPos = offsetPos.m_7918_((int)(zAxis ? this.radius : (byte)0), 0, (int)(zAxis ? (byte)0 : this.radius));
            BlockPos rayEndNeg = offsetPos.m_7918_((int)(zAxis ? -this.radius : (byte)0), 0, zAxis ? 0 : (int)(-this.radius));
            BlockHitResult posPass = this.m_9236_().m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)offsetPos), Vec3.m_82512_((Vec3i)rayEndPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            BlockHitResult negPass = this.m_9236_().m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)offsetPos), Vec3.m_82512_((Vec3i)rayEndNeg), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            if (posPass.m_6662_() == HitResult.Type.MISS && negPass.m_6662_() == HitResult.Type.MISS) continue;
            int posPassOffset = posPass.m_6662_() == HitResult.Type.MISS ? 0 : (int)Math.sqrt(offsetPos.m_123331_((Vec3i)posPass.m_82425_()));
            int negPassOffset = negPass.m_6662_() == HitResult.Type.MISS ? 0 : (int)(-Math.sqrt(offsetPos.m_123331_((Vec3i)negPass.m_82425_())));
            for (int o = negPassOffset + 1; o <= posPassOffset; ++o) {
                BlockPos passStepOffset = offsetPos.m_7918_(zAxis ? o : 0, 0, zAxis ? 0 : o);
                foundPositions.add(passStepOffset);
            }
        }
        this.positions.addAll(foundPositions);
        return true;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_(NBT_BLOCK) && nbt.m_128441_(NBT_POSITIONS) && nbt.m_128441_(NBT_INDEX) && nbt.m_128441_(NBT_RADIUS) && nbt.m_128441_(NBT_HEIGHT) && nbt.m_128441_(NBT_FINISHED_SCAN) && nbt.m_128441_(NBT_PLAYER_ID)) {
            this.placeBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_(NBT_BLOCK)));
            if (this.placeBlock != null) {
                ListTag list = nbt.m_128437_(NBT_POSITIONS, 4);
                list.forEach(l -> this.positions.add(BlockPos.m_122022_((long)((LongTag)l).m_7046_())));
                this.placeIndex = nbt.m_128451_(NBT_INDEX);
                this.radius = nbt.m_128445_(NBT_RADIUS);
                this.height = nbt.m_128445_(NBT_HEIGHT);
                this.finishedScan = nbt.m_128471_(NBT_FINISHED_SCAN);
                this.playerID = UUID.fromString(nbt.m_128461_(NBT_PLAYER_ID));
                this.isValid = true;
            }
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        if (this.placeBlock == null && !this.isValid) {
            return;
        }
        nbt.m_128359_(NBT_BLOCK, ForgeRegistries.BLOCKS.getKey((Object)this.placeBlock).toString());
        nbt.m_128405_(NBT_INDEX, this.placeIndex);
        nbt.m_128344_(NBT_HEIGHT, this.height);
        nbt.m_128344_(NBT_RADIUS, this.radius);
        nbt.m_128359_(NBT_PLAYER_ID, this.playerID.toString());
        nbt.m_128379_(NBT_FINISHED_SCAN, this.finishedScan);
        ListTag positions = new ListTag();
        this.positions.forEach(bp -> positions.add((Object)LongTag.m_128882_((long)bp.m_121878_())));
        nbt.m_128365_(NBT_POSITIONS, (Tag)positions);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

