/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class DisplayReagents
extends Entity {
    public static final int DISPLAY_SWITCH_FREQUENCY = 20;
    private static final int MAX_AGE = 200;
    private static final EntityDataAccessor<CompoundTag> RESOURCE_LOCATIONS = SynchedEntityData.m_135353_(DisplayReagents.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final String NBT_ENTITY_AGE = "entity_age";
    private static final String NBT_LOCATIONS_COUNT = "locations_count";
    private static final String NBT_LOCATIONS_PREFIX = "location_";
    private int age = 0;

    public DisplayReagents(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void m_8119_() {
        this.setAge(this.getAge() + 1);
        if (this.getAge() >= 200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void setResourceLocations(List<ResourceLocation> list) {
        CompoundTag data = new CompoundTag();
        this.writeNBT(data, list);
        this.f_19804_.m_135381_(RESOURCE_LOCATIONS, (Object)data);
    }

    public List<ResourceLocation> getResourceLocations() {
        CompoundTag data = (CompoundTag)this.f_19804_.m_135370_(RESOURCE_LOCATIONS);
        return this.readNBT(data);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RESOURCE_LOCATIONS, (Object)new CompoundTag());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_(NBT_ENTITY_AGE)) {
            this.setAge(compound.m_128451_(NBT_ENTITY_AGE));
        }
        this.setResourceLocations(this.readNBT(compound));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(NBT_ENTITY_AGE, this.getAge());
        List<ResourceLocation> locations = this.getResourceLocations();
        this.writeNBT(compound, locations);
    }

    private List<ResourceLocation> readNBT(CompoundTag compound) {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        if (!compound.m_128441_(NBT_LOCATIONS_COUNT)) {
            return locations;
        }
        int count = compound.m_128451_(NBT_LOCATIONS_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!compound.m_128441_(NBT_LOCATIONS_PREFIX + i)) continue;
            locations.add(new ResourceLocation(compound.m_128461_(NBT_LOCATIONS_PREFIX + i)));
        }
        return locations;
    }

    private void writeNBT(CompoundTag compound, List<ResourceLocation> locations) {
        compound.m_128405_(NBT_LOCATIONS_COUNT, locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            compound.m_128359_(NBT_LOCATIONS_PREFIX + i, locations.get(i).toString());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }
}

