/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.base.ISpellSigil;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.entities.EntityInit;
import com.mna.items.ItemInit;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class SpellSigil
extends Entity
implements ISpellSigil<SpellSigil> {
    private static final EntityDataAccessor<Integer> AFFINITY = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAGNITUDE = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> PERMANENT = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> COOLDOWN = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CHARGES = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PLAYERLESS = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> SIZE = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> CAST_WITH_BONUS = SynchedEntityData.m_135353_(SpellSigil.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private UUID myID;
    private ISpellDefinition recipe;
    private Player _cachedCaster;
    private ArrayList<Entity> targetedEntities = new ArrayList();
    private int cooldownTicks = 0;

    public SpellSigil(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.myID = UUID.randomUUID();
    }

    public SpellSigil(Player caster, ISpellDefinition spell) {
        this((EntityType)EntityInit.SPELL_RUNE.get(), caster.m_9236_());
        this.setCasterAndSpell(caster, spell);
    }

    public void setCastWithBonus(byte bonus) {
        this.f_19804_.m_135381_(CAST_WITH_BONUS, (Object)bonus);
    }

    public void m_8119_() {
        if (!((Boolean)this.f_19804_.m_135370_(PLAYERLESS)).booleanValue() && !this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            if (this.getCasterID() != null) {
                this.m_9236_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                    if (m.wasSigilRemoved(this.getCasterID(), this.myID)) {
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                });
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_());
        if (!this.m_9236_().m_5776_()) {
            if (this.cooldownTicks > 0 && entities.size() == 0) {
                --this.cooldownTicks;
            }
            if (this.cooldownTicks <= 0) {
                this.setOnCooldown(false);
            }
        }
        entities.forEach(e -> this.m_7334_((Entity)e));
    }

    private void setCasterAndSpell(Player caster, ISpellDefinition spell) {
        this._cachedCaster = caster;
        this.setCasterID(caster.m_20148_());
        this.recipe = spell;
        this.f_19804_.m_135381_(AFFINITY, (Object)spell.getHighestAffinity().ordinal());
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(this.recipe.getShape().getValue(Attribute.RADIUS)));
        this.f_19804_.m_135381_(MAGNITUDE, (Object)((int)spell.getShape().getValue(Attribute.MAGNITUDE)));
        this.f_19804_.m_135381_(PERMANENT, (Object)false);
        this.f_19804_.m_135381_(COOLDOWN, (Object)false);
        this.f_19804_.m_135381_(CHARGES, (Object)1);
        this.f_19804_.m_135381_(PLAYERLESS, (Object)false);
        this.f_19804_.m_135381_(CAST_WITH_BONUS, (Object)0);
    }

    public void setPermanent() {
        this.f_19804_.m_135381_(PERMANENT, (Object)true);
    }

    public boolean isPermanent() {
        return (Boolean)this.f_19804_.m_135370_(PERMANENT);
    }

    public void setSize(byte size) {
        size = (byte)MathUtils.clamp(size, 1, 5);
        this.f_19804_.m_135381_(SIZE, (Object)size);
        this.m_20011_(this.m_142242_());
    }

    protected AABB m_142242_() {
        byte size = this.getSize();
        return new AABB(this.m_20182_().m_82520_(-0.5 * (double)size, 0.0, -0.5 * (double)size), this.m_20182_().m_82520_(0.5 * (double)size, 0.1, 0.5 * (double)size));
    }

    public byte getSize() {
        return (Byte)this.f_19804_.m_135370_(SIZE);
    }

    public void setOnCooldown(boolean onCooldown) {
        this.f_19804_.m_135381_(COOLDOWN, (Object)onCooldown);
        this.cooldownTicks = 60;
    }

    public boolean isOnCooldown() {
        return (Boolean)this.f_19804_.m_135370_(COOLDOWN);
    }

    public void addCharge() {
        int numCharges = this.getCharges();
        if (numCharges < 10) {
            this.f_19804_.m_135381_(CHARGES, (Object)(numCharges + 1));
        }
    }

    public void consumeCharge() {
        this.f_19804_.m_135381_(CHARGES, (Object)(this.getCharges() - 1));
        this.setOnCooldown(true);
    }

    public int getCharges() {
        return (Integer)this.f_19804_.m_135370_(CHARGES);
    }

    public Affinity getAffinity() {
        return Affinity.values()[(Integer)this.f_19804_.m_135370_(AFFINITY)];
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_21120_(pHand).m_41720_() == ItemInit.__DEBUG.get()) {
            this.f_19804_.m_135381_(PLAYERLESS, (Object)true);
            this.f_19804_.m_135381_(CASTER, Optional.of(Util.f_137441_));
            this._cachedCaster = null;
            if (!pPlayer.m_9236_().m_5776_()) {
                pPlayer.m_213846_((Component)Component.m_237115_((String)"item.mna.debug_wand.playerless"));
            }
            return InteractionResult.m_19078_((boolean)pPlayer.m_9236_().m_5776_());
        }
        return super.m_6096_(pPlayer, pHand);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_7334_(Entity entityIn) {
        if (!(entityIn instanceof LivingEntity) && !(entityIn instanceof ItemEntity)) {
            return;
        }
        if ((Integer)this.f_19804_.m_135370_(MAGNITUDE) == 2 ? !(entityIn instanceof LivingEntity) : (Integer)this.f_19804_.m_135370_(MAGNITUDE) == 3 && !(entityIn instanceof Player)) {
            return;
        }
        this.trigger(entityIn, false);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.trigger(source.m_7640_(), true);
        return true;
    }

    private void trigger(Entity e, boolean forceRemove) {
        if (!this.m_6084_() || !forceRemove && this.isOnCooldown()) {
            return;
        }
        if (this.isPermanent() && this.getCharges() <= 0) {
            return;
        }
        float radius = ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
        if (this.m_9236_().m_5776_()) {
            this.spawnParticles(radius);
        } else {
            boolean applied;
            if (!this.isPermanent() || forceRemove) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (this.recipe == null) {
                return;
            }
            SpellContext context = new SpellContext(this.m_9236_(), this.recipe, this);
            boolean bl = applied = this.targetEntities(radius, context) || this.targetBlocks(radius, context);
            if (applied) {
                if (this.isPermanent()) {
                    this.consumeCharge();
                }
                if (!(this.m_9236_().m_5776_() || this.m_6084_() || ((Boolean)this.f_19804_.m_135370_(PLAYERLESS)).booleanValue())) {
                    this.m_9236_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.removeSigil(this.getCaster() != null ? this.getCaster().m_20148_() : null, this.myID));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles(float radius) {
        Affinity affinity = Affinity.values()[(Integer)this.f_19804_.m_135370_(AFFINITY)];
        MAParticleType particle = null;
        SoundEvent sound = null;
        switch (affinity) {
            case ARCANE: {
                particle = (MAParticleType)((Object)ParticleInit.ARCANE.get());
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.ARCANE : SFX.Spell.Impact.AoE.ARCANE;
                break;
            }
            case EARTH: {
                particle = (MAParticleType)((Object)ParticleInit.DUST.get());
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.EARTH : SFX.Spell.Impact.AoE.EARTH;
                break;
            }
            case ENDER: {
                particle = (MAParticleType)((Object)ParticleInit.ENDER.get());
                sound = SFX.Spell.Impact.Single.ENDER;
                break;
            }
            case FIRE: {
                particle = (MAParticleType)((Object)ParticleInit.FLAME.get());
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.FIRE : SFX.Spell.Impact.AoE.FIRE;
                break;
            }
            case HELLFIRE: {
                particle = (MAParticleType)((Object)ParticleInit.HELLFIRE.get());
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.FIRE : SFX.Spell.Impact.AoE.FIRE;
                break;
            }
            case WATER: {
                particle = (MAParticleType)((Object)ParticleInit.FROST.get());
                sound = SFX.Spell.Impact.Single.ICE;
                break;
            }
            case BLOOD: {
                particle = (MAParticleType)((Object)ParticleInit.BLOOD.get());
                sound = SFX.Spell.Impact.Single.ICE;
                break;
            }
            case WIND: {
                particle = (MAParticleType)((Object)ParticleInit.AIR_VELOCITY.get());
                sound = radius < 2.0f ? SFX.Spell.Impact.Single.WIND : SFX.Spell.Impact.AoE.WIND;
                break;
            }
            default: {
                particle = (MAParticleType)((Object)ParticleInit.SPARKLE_STATIONARY.get());
            }
        }
        int i = 0;
        while ((float)i < 20.0f * radius) {
            Vec3 position = this.m_20182_().m_82520_((double)(-radius) + Math.random() * (double)radius, (double)(-radius) + Math.random() * (double)radius, (double)(-radius) + Math.random() * (double)radius);
            MAParticleType inst = new MAParticleType(particle);
            if (this.recipe != null) {
                inst = this.recipe.colorParticle(inst, (Entity)this.getOrCreatePlayer());
            }
            this.m_9236_().m_7106_((ParticleOptions)inst, position.f_82479_, position.f_82480_, position.f_82481_, 0.0, 0.4, 0.0);
            ++i;
        }
        if (sound != null) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.4f), false);
        }
    }

    private boolean targetEntities(float radius, SpellContext context) {
        if (this.recipe == null || !this.recipe.isValid()) {
            return false;
        }
        if (!this.recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities())) {
            return false;
        }
        SpellSource source = new SpellSource((LivingEntity)this.getOrCreatePlayer(), InteractionHand.MAIN_HAND);
        MutableBoolean applied_success = new MutableBoolean(false);
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)(radius - 1.0f)));
        this.targetedEntities.clear();
        entities.forEach(e -> {
            if (!this.targetedEntities.contains(e)) {
                this.targetedEntities.add((Entity)e);
                if (SpellCaster.ApplyComponents(this.recipe, source, new SpellTarget((Entity)e), context).values().stream().anyMatch(c -> c.is_success)) {
                    applied_success.setTrue();
                }
            }
        });
        return applied_success.booleanValue();
    }

    protected Player getOrCreatePlayer() {
        Player caster = this.getCaster();
        return caster != null && caster.m_20280_((Entity)this) < 4096.0 ? caster : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.m_9236_()));
    }

    private boolean targetBlocks(float radius, SpellContext context) {
        if (this.recipe == null || !this.recipe.isValid()) {
            return false;
        }
        if (!this.recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks())) {
            return false;
        }
        SpellSource source = new SpellSource((LivingEntity)this.getOrCreatePlayer(), InteractionHand.MAIN_HAND);
        MutableBoolean applied_success = new MutableBoolean(false);
        int iRadius = (int)Math.floor(radius);
        for (int i = -iRadius; i <= iRadius; ++i) {
            for (int j = -iRadius; j <= iRadius; ++j) {
                for (int k = -iRadius; k <= iRadius; ++k) {
                    BlockPos offset = new BlockPos(i, j, k);
                    if (!SpellCaster.ApplyComponents(this.recipe, source, new SpellTarget(offset, Direction.DOWN), context).values().stream().anyMatch(c -> c.is_success)) continue;
                    applied_success.setTrue();
                }
            }
        }
        return applied_success.booleanValue();
    }

    @Nullable
    private Player getCaster() {
        if (this._cachedCaster == null && this.getCasterID() != null) {
            this._cachedCaster = this.m_9236_().m_46003_(this.getCasterID());
        }
        return this._cachedCaster;
    }

    @Nullable
    private UUID getCasterID() {
        return (UUID)((Optional)this.f_19804_.m_135370_(CASTER)).get();
    }

    public boolean isCaster(Player player) {
        if (player.m_36316_() == null || player.m_36316_().getId() == null || this.getCasterID() == null) {
            return false;
        }
        return this.getCasterID().equals(player.m_36316_().getId());
    }

    private void setCasterID(UUID casterID) {
        this.f_19804_.m_135381_(CASTER, Optional.of(casterID));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key == CASTER) {
            this._cachedCaster = null;
        }
        super.m_7350_(key);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(AFFINITY, (Object)Affinity.UNKNOWN.ordinal());
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(CASTER, Optional.empty());
        this.f_19804_.m_135372_(MAGNITUDE, (Object)0);
        this.f_19804_.m_135372_(PERMANENT, (Object)false);
        this.f_19804_.m_135372_(COOLDOWN, (Object)false);
        this.f_19804_.m_135372_(CHARGES, (Object)1);
        this.f_19804_.m_135372_(PLAYERLESS, (Object)true);
        this.f_19804_.m_135372_(SIZE, (Object)1);
        this.f_19804_.m_135372_(CAST_WITH_BONUS, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("caster")) {
            try {
                this.setCasterID(UUID.fromString(compound.m_128461_("caster")));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to load caster ID when loading rune entity");
                ManaAndArtifice.LOGGER.throwing((Throwable)ex);
            }
        }
        if (compound.m_128441_("recipe")) {
            this.recipe = SpellRecipe.fromNBT(compound.m_128469_("recipe"));
        }
        if (compound.m_128441_("affinity")) {
            this.f_19804_.m_135381_(AFFINITY, (Object)compound.m_128451_("affinity"));
        }
        if (compound.m_128441_("charges")) {
            this.f_19804_.m_135381_(CHARGES, (Object)compound.m_128451_("charges"));
        }
        if (compound.m_128441_("permanent")) {
            this.f_19804_.m_135381_(PERMANENT, (Object)compound.m_128471_("permanent"));
        }
        if (compound.m_128441_("cooldown")) {
            this.f_19804_.m_135381_(COOLDOWN, (Object)compound.m_128471_("cooldown"));
        }
        if (compound.m_128441_("customSize")) {
            this.setSize(compound.m_128445_("customSize"));
        }
        if (compound.m_128441_("cooldownTicks")) {
            this.cooldownTicks = compound.m_128451_("cooldownTicks");
        }
        if (compound.m_128441_("invisible")) {
            this.m_6842_(compound.m_128471_("invisible"));
        }
        if (compound.m_128441_("bonus")) {
            this.f_19804_.m_135381_(CAST_WITH_BONUS, (Object)compound.m_128445_("bonus"));
        }
        if (compound.m_128441_("myUUID")) {
            try {
                this.myID = UUID.fromString(compound.m_128461_("myUUID"));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to load UUID when loading EntitySpellRune");
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("caster", this.getCasterID() != null ? this.getCasterID().toString() : "");
        compound.m_128359_("myUUID", this.myID.toString());
        compound.m_128405_("affinity", ((Integer)this.f_19804_.m_135370_(AFFINITY)).intValue());
        compound.m_128405_("charges", ((Integer)this.f_19804_.m_135370_(CHARGES)).intValue());
        compound.m_128379_("permanent", ((Boolean)this.f_19804_.m_135370_(PERMANENT)).booleanValue());
        compound.m_128379_("cooldown", ((Boolean)this.f_19804_.m_135370_(COOLDOWN)).booleanValue());
        compound.m_128344_("customSize", this.getSize());
        compound.m_128405_("cooldownTicks", this.cooldownTicks);
        compound.m_128379_("invisible", this.m_20145_());
        compound.m_128344_("bonus", ((Byte)this.f_19804_.m_135370_(CAST_WITH_BONUS)).byteValue());
        CompoundTag recipeNBT = new CompoundTag();
        if (this.recipe != null) {
            this.recipe.writeToNBT(recipeNBT);
        }
        compound.m_128365_("recipe", (Tag)recipeNBT);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().m_5776_() && this.getCaster() != null) {
            this.m_9236_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.addSigil(this.getCaster(), this, (Byte)this.f_19804_.m_135370_(CAST_WITH_BONUS)));
        }
    }

    @Override
    public UUID getID() {
        return this.myID;
    }

    @Override
    public int getCountBonus() {
        return ((Byte)this.f_19804_.m_135370_(CAST_WITH_BONUS)).byteValue();
    }
}

