/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.google.common.collect.Lists;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.ISpellInteractibleBlock;
import com.mna.api.entities.ISpellInteractibleEntity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.Odin;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;

public class SpellProjectile
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<CompoundTag> SPELL_RECIPE = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> SPECIAL_RENDER = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> SPECIAL_RENDER_PARAM = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> FORCED_AFFINITY = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> FORCED_DAMAGE = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DISABLE_WATER_CHECK = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> HOMING_STRENGTH = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> VELOCITY = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static ItemStack[] halloween_stacks = new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50314_), new ItemStack((ItemLike)Blocks.f_50318_), new ItemStack((ItemLike)Blocks.f_50310_), new ItemStack((ItemLike)Blocks.f_50312_), new ItemStack((ItemLike)Blocks.f_50143_), new ItemStack((ItemLike)Blocks.f_50144_)};
    private IntOpenHashSet piercedEntities;
    private List<Entity> hitEntities;
    public UUID shootingEntity;
    private int ticksInAir;
    private ArrayList<Affinity> affinities;
    private Optional<Integer> forcedTargetID = Optional.empty();
    private boolean trackForcedTarget = false;
    private float trackingSpeed = 0.0f;
    private SpellRecipe _cachedSpellRecipe = null;
    private LivingEntity target;
    private HashMap<Affinity, BiConsumer<Integer, Float>> particleFunctions = new HashMap();
    private HashMap<Affinity, BiConsumer<Integer, Float>> impactFunctions = new HashMap();

    public SpellProjectile(EntityType<? extends SpellProjectile> type, Level world) {
        super((EntityType)EntityInit.SPELL_PROJECTILE.get(), world);
        this.m_20242_(true);
        this.forcedTargetID = Optional.empty();
        this.particleFunctions.put(Affinity.ARCANE, this::spawnArcaneParticles);
        this.particleFunctions.put(Affinity.ENDER, this::spawnEnderParticles);
        this.particleFunctions.put(Affinity.FIRE, this::spawnFireParticles);
        this.particleFunctions.put(Affinity.HELLFIRE, this::spawnHellfireParticles);
        this.particleFunctions.put(Affinity.LIGHTNING, this::spawnLightningParticles);
        this.particleFunctions.put(Affinity.WATER, this::spawnWaterParticles);
        this.particleFunctions.put(Affinity.ICE, this::spawnFrostParticles);
        this.particleFunctions.put(Affinity.WIND, this::spawnWindParticles);
        this.particleFunctions.put(Affinity.EARTH, this::spawnEarthParticles);
        this.particleFunctions.put(Affinity.BLOOD, this::spawnBloodParticles);
        this.impactFunctions.put(Affinity.WATER, this::spawnWaterImpactParticles);
        this.impactFunctions.put(Affinity.FIRE, this::spawnFireImpactParticles);
        this.impactFunctions.put(Affinity.HELLFIRE, this::spawnFireImpactParticles);
        this.impactFunctions.put(Affinity.EARTH, this::spawnEarthImpactParticles);
        this.impactFunctions.put(Affinity.WIND, this::spawnWindImpactParticles);
        this.impactFunctions.put(Affinity.ARCANE, this::spawnArcaneImpactParticles);
        this.impactFunctions.put(Affinity.ENDER, this::spawnEnderImpactParticles);
        this.impactFunctions.put(Affinity.ICE, this::spawnFrostImpactParticles);
        this.impactFunctions.put(Affinity.BLOOD, this::spawnBloodImpactParticles);
    }

    public SpellProjectile(LivingEntity shooter, Level worldIn) {
        this(worldIn, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    public SpellProjectile(Level worldIn, double x, double y, double z) {
        super((EntityType)EntityInit.SPELL_PROJECTILE.get(), worldIn);
        this.m_6034_(x, y, z);
        this.m_20242_(true);
    }

    public ArrayList<Affinity> getAffinity() {
        if (this.affinities == null) {
            if ((Byte)this.f_19804_.m_135370_(FORCED_AFFINITY) > 0) {
                this.affinities = new ArrayList();
                this.affinities.add(Affinity.values()[(Byte)this.f_19804_.m_135370_(FORCED_AFFINITY)]);
            } else {
                SpellRecipe recipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE));
                this.affinities = new ArrayList<Affinity>(recipe.getAffinity().keySet());
            }
        }
        return this.affinities;
    }

    public SpecialRenderType getSpecialRenderType() {
        return SpecialRenderType.values()[(Byte)this.f_19804_.m_135370_(SPECIAL_RENDER)];
    }

    public void spawnParticles(int particleCount, float partialTick) {
        Affinity aff;
        if (this.getAffinity() != null && this.particleFunctions.containsKey((Object)(aff = this.affinities.get((int)(Math.random() * (double)this.affinities.size()))))) {
            this.particleFunctions.get((Object)aff).accept(particleCount, Float.valueOf(partialTick));
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPELL_RECIPE, (Object)new CompoundTag());
        this.f_19804_.m_135372_(PIERCE_LEVEL, (Object)0);
        this.f_19804_.m_135372_(FORCED_AFFINITY, (Object)0);
        this.f_19804_.m_135372_(FORCED_DAMAGE, (Object)0);
        this.f_19804_.m_135372_(SPECIAL_RENDER, (Object)0);
        this.f_19804_.m_135372_(SPECIAL_RENDER_PARAM, (Object)0);
        this.f_19804_.m_135372_(DISABLE_WATER_CHECK, (Object)false);
        this.f_19804_.m_135372_(VELOCITY, (Object)Float.valueOf(0.2f));
        this.f_19804_.m_135372_(HOMING_STRENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(OWNER_ID, (Object)-1);
    }

    public void setForcedDamageAffinityAndTarget(Affinity affinity, float damage, @Nullable Entity target) {
        this.f_19804_.m_135381_(FORCED_DAMAGE, (Object)((byte)damage));
        this.f_19804_.m_135381_(FORCED_AFFINITY, (Object)((byte)affinity.ordinal()));
        this.forcedTargetID = target != null ? Optional.of(target.m_19879_()) : Optional.empty();
    }

    public void setHellball(Entity target, float speed) {
        this.forcedTargetID = Optional.of(target.m_19879_());
        this.trackForcedTarget = true;
        this.trackingSpeed = speed;
        this.setSpecialRender(SpecialRenderType.HELLBALL);
    }

    public void setHomingStrength(float strength) {
        this.f_19804_.m_135381_(HOMING_STRENGTH, (Object)Float.valueOf(MathUtils.clamp01(strength)));
    }

    public void setSpecialRender(SpecialRenderType type) {
        this.f_19804_.m_135381_(SPECIAL_RENDER, (Object)((byte)type.ordinal()));
        switch (type) {
            case HALLOWEEN: {
                this.f_19804_.m_135381_(SPECIAL_RENDER_PARAM, (Object)((byte)(Math.random() * (double)halloween_stacks.length)));
                break;
            }
        }
    }

    public void setNoWaterFizzle() {
        this.f_19804_.m_135381_(DISABLE_WATER_CHECK, (Object)true);
    }

    public ItemStack getSpecialRenderStack() {
        return halloween_stacks[(Byte)this.f_19804_.m_135370_(SPECIAL_RENDER_PARAM)];
    }

    public void setSpellRecipe(CompoundTag recipe) {
        this.f_19804_.m_135381_(SPELL_RECIPE, (Object)recipe);
    }

    protected SpellRecipe getRecipe() {
        if (this._cachedSpellRecipe == null) {
            this._cachedSpellRecipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE));
        }
        return this._cachedSpellRecipe;
    }

    public void shoot(@Nullable Entity shooter, Vec3 look, float velocity, float inaccuracy) {
        this.m_6686_(look.m_7096_(), look.m_7098_(), look.m_7094_(), velocity, inaccuracy);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 Vector3d = new Vec3(x, y, z).m_82541_().m_82490_((double)velocity);
        this.m_20256_(Vector3d);
        double f = Vector3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)Vector3d.f_82479_, (double)Vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)Vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.f_19804_.m_135381_(VELOCITY, (Object)Float.valueOf(velocity));
    }

    protected void entityHit(Entity entity) {
        if (entity instanceof SpellProjectile) {
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            if ((Byte)this.f_19804_.m_135370_(FORCED_DAMAGE) > 0) {
                Entity shooter = this.getShooter();
                if (shooter != null && shooter instanceof LivingEntity) {
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)shooter), (float)((Byte)this.f_19804_.m_135370_(FORCED_DAMAGE)).byteValue());
                } else {
                    entity.m_6469_(entity.m_269291_().m_269425_(), (float)((Byte)this.f_19804_.m_135370_(FORCED_DAMAGE)).byteValue());
                }
            } else {
                this.applyEffect(this.m_20183_(), this.m_6350_(), entity);
            }
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    protected void blockHit(BlockPos pos, Direction face) {
        if ((Byte)this.f_19804_.m_135370_(FORCED_DAMAGE) <= 0 && !this.m_9236_().m_5776_()) {
            this.applyEffect(pos, face, null);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    private void applyEffect(BlockPos impactPoint, Direction face, @Nullable Entity hitEntity) {
        if (!this.m_6084_()) {
            return;
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.getShooter() == null || !(this.getShooter() instanceof LivingEntity)) {
            return;
        }
        SpellSource source = new SpellSource((LivingEntity)this.getShooter(), InteractionHand.MAIN_HAND);
        SpellRecipe recipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE));
        if (recipe.isValid() && !this.m_9236_().m_5776_()) {
            boolean sphere;
            HashMap<SpellEffect, ComponentApplicationResult> results = new HashMap<SpellEffect, ComponentApplicationResult>();
            BlockState state = this.m_9236_().m_8055_(impactPoint);
            if (state.m_60734_() instanceof ISpellInteractibleBlock && ((ISpellInteractibleBlock)state.m_60734_()).onHitBySpell(this.m_9236_(), impactPoint, recipe)) {
                return;
            }
            if (hitEntity != null && hitEntity instanceof ISpellInteractibleEntity && ((ISpellInteractibleEntity)hitEntity).onShapeTarget(recipe, source)) {
                return;
            }
            float spellRadius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS) * 2.0f;
            SpellContext context = new SpellContext(this.m_9236_(), recipe, (Entity)this);
            boolean bl = sphere = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.PRECISION) == 1.0f;
            if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks())) {
                int rSquared;
                int radius = (int)((Math.floor(spellRadius) - 1.0) / 2.0);
                if (radius < 0) {
                    radius = 0;
                }
                int n = rSquared = sphere ? radius * radius : 0;
                if (radius > 0 || hitEntity == null) {
                    for (int i = -radius; i <= radius; ++i) {
                        int tx_squared = sphere ? i * i : 0;
                        for (int j = -radius; j <= radius; ++j) {
                            int ty_squared = sphere ? j * j : 0;
                            for (int k = -radius; k <= radius; ++k) {
                                int tz_squared;
                                int n2 = tz_squared = sphere ? k * k : 0;
                                if (sphere && tx_squared + ty_squared + tz_squared > rSquared) continue;
                                BlockPos adjusted = impactPoint.m_7918_(i, j, k);
                                HashMap<SpellEffect, ComponentApplicationResult> loopRes = SpellCaster.ApplyComponents(recipe, source, new SpellTarget(adjusted, face).doNotOffsetFace(), context);
                                SpellCaster.mergeComponentResults(results, loopRes);
                            }
                        }
                    }
                }
            }
            if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities())) {
                float radius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
                List targets = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)radius), e -> !e.m_20147_() && (!sphere || e.m_20270_((Entity)this) <= radius) && !(e instanceof SpellProjectile) && e.m_6084_() && e != this);
                if (hitEntity != null && !targets.contains(hitEntity)) {
                    targets.add(hitEntity);
                }
                for (Entity target : targets) {
                    if (target == null || target == this.getShooter()) continue;
                    HashMap<SpellEffect, ComponentApplicationResult> loopRes = SpellCaster.ApplyComponents(recipe, source, new SpellTarget(target), context);
                    SpellCaster.mergeComponentResults(results, loopRes);
                }
            }
            if (results.size() > 0) {
                List<SpellEffect> appliedEffects = results.entrySet().stream().map(e -> e.getValue() == ComponentApplicationResult.SUCCESS ? (SpellEffect)e.getKey() : null).filter(e -> e != null).collect(Collectors.toList());
                SpellCaster.spawnClientFX(this.m_9236_(), this.m_20182_(), this.m_20184_(), source, appliedEffects);
            }
        }
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        if (raytraceResultIn == null) {
            return;
        }
        HitResult.Type raytraceresult$type = raytraceResultIn.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)raytraceResultIn);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockraytraceresult = (BlockHitResult)raytraceResultIn;
            this.blockHit(blockraytraceresult.m_82425_(), blockraytraceresult.m_82434_());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float getWaterDrag() {
        return this.affinities.contains((Object)Affinity.WATER) ? 1.0f : 0.6f;
    }

    public byte getPierceLevel() {
        return (Byte)this.f_19804_.m_135370_(PIERCE_LEVEL);
    }

    public void setPierceLevel(byte level) {
        this.f_19804_.m_135381_(PIERCE_LEVEL, (Object)level);
    }

    public boolean m_6097_() {
        return false;
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.0f;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    @Nullable
    public Entity getShooter() {
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.shootingEntity != null) {
                return ((ServerLevel)this.m_9236_()).m_8791_(this.shootingEntity);
            }
            return null;
        }
        int shooterID = (Integer)this.f_19804_.m_135370_(OWNER_ID);
        return this.m_9236_().m_6815_(shooterID);
    }

    public final int getOverrideColor() {
        Entity caster = this.getShooter();
        SpellRecipe recipe = this.getRecipe();
        if (caster == null || recipe == null) {
            return -1;
        }
        MutableInt color = new MutableInt(-1);
        caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> color.setValue(m.getParticleColorOverride()));
        if (color.getValue() == -1) {
            color.setValue(recipe.getParticleColorOverride());
        }
        return color.getValue();
    }

    public void m_5602_(@Nullable Entity entityIn) {
        UUID uUID = this.shootingEntity = entityIn == null ? null : entityIn.m_20148_();
        if (entityIn != null) {
            this.f_19804_.m_135381_(OWNER_ID, (Object)entityIn.m_19879_());
        } else {
            this.f_19804_.m_135381_(OWNER_ID, (Object)-1);
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128344_("PierceLevel", this.getPierceLevel());
        if (this.shootingEntity != null) {
            compound.m_128362_("OwnerUUID", this.shootingEntity);
        }
    }

    public void m_7378_(CompoundTag compound) {
        this.setPierceLevel(compound.m_128445_("PierceLevel"));
        if (compound.m_128403_("OwnerUUID")) {
            this.shootingEntity = compound.m_128342_("OwnerUUID");
        }
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        if (this.getShooter() instanceof Odin) {
            return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_20191_().m_82400_(3.0).m_82369_(this.m_20184_()), candidate -> !(candidate.m_5833_() || !candidate.m_6084_() || !candidate.m_6087_() || candidate == this.getShooter() && this.ticksInAir < 5 || this.piercedEntities != null && this.piercedEntities.contains(candidate.m_19879_())));
        }
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), candidate -> !(candidate.m_5833_() || !candidate.m_6084_() || !candidate.m_6087_() || candidate == this.getShooter() && this.ticksInAir < 5 || this.piercedEntities != null && this.piercedEntities.contains(candidate.m_19879_())));
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        Entity entity = p_213868_1_.m_82443_();
        if (this.getShooter() == null || entity == this.getShooter()) {
            return;
        }
        if (this.getPierceLevel() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.getPierceLevel() + 1) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            this.piercedEntities.add(entity.m_19879_());
        }
        if (this.forcedTargetID != null && this.forcedTargetID.isPresent() && this.forcedTargetID.get().intValue() != entity.m_19879_()) {
            return;
        }
        this.entityHit(entity);
        if (!entity.m_6084_() && this.hitEntities != null) {
            this.hitEntities.add(entity);
        }
        if (this.getPierceLevel() <= 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_8119_() {
        float homingStrength;
        Vec3 motion = this.m_20184_();
        LivingEntity target = this.getTarget();
        if (this.forcedTargetID.isPresent()) {
            target = this.m_9236_().m_6815_(this.forcedTargetID.get().intValue());
        }
        if (this.trackForcedTarget && this.forcedTargetID.isPresent()) {
            if (target == null) {
                this.applyEffect(this.m_20183_(), this.m_6350_(), null);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            Vec3 direction = target.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_((double)this.trackingSpeed);
            this.m_20256_(direction);
            float closeEnough = 2.0f;
            if (this.m_20182_().m_82554_(target.m_20182_()) <= (double)closeEnough) {
                EntityHitResult ehr = new EntityHitResult((Entity)target);
                this.m_5790_(ehr);
            }
        }
        if ((homingStrength = ((Float)this.f_19804_.m_135370_(HOMING_STRENGTH)).floatValue()) > 0.0f) {
            if (target == null) {
                if (this.m_9236_().m_46467_() % 5L == 0L) {
                    this.target();
                }
            } else {
                Vec3 myPos = this.m_20182_();
                Vec3 theirPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
                float maxRotationRadians = 0.261799f;
                float tickTheta = maxRotationRadians * MathUtils.clamp01(homingStrength);
                if (tickTheta > 0.0f) {
                    Vec3 desiredHeading = theirPos.m_82546_(myPos).m_82541_();
                    Vec3 calculatedHeading = MathUtils.rotateTowards(this.m_20184_().m_82541_(), desiredHeading, tickTheta).m_82541_().m_82490_((double)((Float)this.f_19804_.m_135370_(VELOCITY)).floatValue());
                    this.m_20256_(calculatedHeading);
                }
            }
        }
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = motion.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        this.f_19798_ = this.m_9236_().m_46801_(this.m_20183_());
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.m_20072_() && this.getAffinity().contains((Object)Affinity.FIRE) && !((Boolean)this.f_19804_.m_135370_(DISABLE_WATER_CHECK)).booleanValue()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        ++this.ticksInAir;
        Vec3 Vector3d2 = this.m_20182_();
        Vec3 Vector3d3 = Vector3d2.m_82549_(motion);
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(Vector3d2, Vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            Vector3d3 = raytraceresult.m_82450_();
        }
        while (this.m_6084_()) {
            EntityHitResult entityraytraceresult = this.rayTraceEntities(Vector3d2, Vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                if (!(entity instanceof LivingEntity)) break;
                Entity entity1 = this.getShooter();
                if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_((HitResult)raytraceresult);
                this.f_19812_ = true;
                break;
            }
            if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
            raytraceresult = null;
        }
        motion = this.m_20184_();
        double d3 = motion.f_82479_;
        double d4 = motion.f_82480_;
        double d0 = motion.f_82481_;
        double d5 = this.m_20185_() + d3;
        double d1 = this.m_20186_() + d4;
        double d2 = this.m_20189_() + d0;
        double f1 = motion.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d0) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)d4, (double)f1) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
        float f2 = 0.99f;
        if (this.m_20069_()) {
            for (int j = 0; j < 4; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
        }
        this.m_20256_(motion.m_82490_((double)f2));
        if (!this.m_20068_()) {
            Vec3 Vector3d4 = this.m_20184_();
            this.m_20334_(Vector3d4.f_82479_, Vector3d4.f_82480_ - (double)0.05f, Vector3d4.f_82481_);
        }
        this.m_6034_(d5, d1, d2);
        this.m_20101_();
        if (this.f_19797_ > 200 || this.ticksInAir > 200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void lookAt(Entity pEntity, float pMaxYRotIncrease, float pMaxXRotIncrease) {
        double d1;
        double d0 = pEntity.m_20185_() - this.m_20185_();
        double d2 = pEntity.m_20189_() - this.m_20189_();
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)pEntity;
            d1 = livingentity.m_20188_() - this.m_20188_();
        } else {
            d1 = (pEntity.m_20191_().f_82289_ + pEntity.m_20191_().f_82292_) / 2.0 - this.m_20188_();
        }
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        this.m_146926_(this.rotlerp(this.m_146909_(), f1, pMaxXRotIncrease));
        this.m_146922_(this.rotlerp(this.m_146908_(), f, pMaxYRotIncrease));
    }

    private float rotlerp(float pAngle, float pTargetAngle, float pMaxIncrease) {
        float f = Mth.m_14177_((float)(pTargetAngle - pAngle));
        if (f > pMaxIncrease) {
            f = pMaxIncrease;
        }
        if (f < -pMaxIncrease) {
            f = -pMaxIncrease;
        }
        return pAngle + f;
    }

    private void target() {
        if (this.getShooter() == null || !(this.getShooter() instanceof LivingEntity)) {
            return;
        }
        this.target = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(16.0), e -> {
            ClipContext ctx = new ClipContext(this.m_20182_(), e.m_20182_().m_82520_(0.0, (double)(e.m_20206_() / 2.0f), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
            if (this.m_9236_().m_45547_(ctx).m_6662_() == HitResult.Type.BLOCK) {
                return false;
            }
            return e.m_6084_() && e instanceof LivingEntity && !SummonUtils.isTargetFriendly(e, (LivingEntity)this.getShooter());
        }).stream().map(e -> (LivingEntity)e).findFirst().orElse(null);
        if (this.target != null) {
            this.f_19804_.m_135381_(TARGET_ID, (Object)this.target.m_19879_());
            this.f_19797_ = 0;
        }
    }

    @Nullable
    private LivingEntity getTarget() {
        Entity e;
        if (this.target == null && (e = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ID)).intValue())) instanceof LivingEntity) {
            this.target = (LivingEntity)e;
        }
        return this.target;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = Mth.m_14116_((float)((float)(x * x + z * z)));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.2957763671875));
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * SpellProjectile.m_20150_()) * d0;
    }

    public void onRemovedFromWorld() {
        Entity.RemovalReason reason;
        super.onRemovedFromWorld();
        if (this.m_9236_().m_5776_() && (reason = this.m_146911_()) == Entity.RemovalReason.DISCARDED) {
            this.spawnImpactParticles();
        }
    }

    private void spawnImpactParticles() {
        if (!this.getRecipe().isValid() || this.affinities == null) {
            return;
        }
        float radius = ((ModifiedSpellPart)this.getRecipe().getShape()).getValue(Attribute.RADIUS) + 1.0f;
        for (Affinity aff : this.affinities) {
            if (!this.impactFunctions.containsKey((Object)aff)) continue;
            this.impactFunctions.get((Object)aff).accept((int)(75.0f * radius), Float.valueOf(radius));
        }
    }

    private void spawnWaterImpactParticles(int particleCount, float velocityModifier) {
        Vec3 pos = this.m_20182_();
        float spread = 0.2f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)));
            Vec3 velocity = particlePos.m_82546_(pos).m_82541_().m_82490_((Math.random() * 0.5 + 0.5) * (double)spread * (double)velocityModifier);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DRIP.get())), this.getShooter()).setGravity(0.05f).setPhysics(true).setScale(0.125f).setMaxAge(40), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnFireImpactParticles(int particleCount, float velocityModifier) {
        Vec3 velocity;
        Vec3 particlePos;
        int j;
        Vec3 pos = this.m_20182_();
        float spread = 0.1f;
        for (j = 0; j < particleCount / 8; ++j) {
            particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)).m_82490_(0.25));
            velocity = particlePos.m_82546_(pos).m_82541_().m_82490_((double)0.1f).m_82490_((double)(spread * velocityModifier));
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
        for (j = 0; j < particleCount / 4; ++j) {
            particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)).m_82490_((double)(velocityModifier / 2.0f)));
            velocity = particlePos.m_82546_(pos).m_82541_().m_82490_(Math.random() * (double)spread * (double)velocityModifier);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnWindImpactParticles(int particleCount, float velocityModifier) {
        Vec3 particlePos;
        int j;
        Vec3 pos = this.m_20182_();
        float spread = 0.2f;
        for (j = 0; j < particleCount / 6; ++j) {
            particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)));
            Vec3 velocity = particlePos.m_82546_(pos).m_82541_().m_82490_((Math.random() * 0.5 + 0.5) * (double)spread * (double)velocityModifier);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())), this.getShooter()).setScale(0.2f).setColor(10, 10, 10).setScale(0.125f).setMaxAge(4 + (int)(Math.random() * 4.0 * (double)velocityModifier)), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
        for (j = 0; j < particleCount / 2; ++j) {
            particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)));
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())), this.getShooter()).setScale(0.2f).setColor(10, 10, 10).setScale(0.125f).setMaxAge(4 + (int)(Math.random() * 4.0 * (double)velocityModifier)), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, (double)(0.05f * velocityModifier), (double)(0.05f * velocityModifier), (double)(1.0f * velocityModifier));
        }
    }

    private void spawnArcaneImpactParticles(int particleCount, float velocityModifier) {
        Vec3 pos = this.m_20182_();
        float spread = 0.2f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)));
            Vec3 velocity = particlePos.m_82546_(pos).m_82541_().m_82490_((Math.random() * 0.5 + 0.5) * (double)spread * (double)velocityModifier);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())), this.getShooter()).setGravity(0.05f).setPhysics(true).setScale(0.125f).setMaxAge(40), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnEnderImpactParticles(int particleCount, float velocityModifier) {
        Vec3 pos = this.m_20182_();
        for (int j = 0; j < particleCount; ++j) {
            Vec3 particlePos = pos.m_82549_(new Vec3(1.0, 1.0, 1.0).m_82490_(1.0 + Math.random() * 3.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)));
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), this.getShooter()).setMaxAge(10 + (int)(Math.random() * 10.0)), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    private void spawnEarthImpactParticles(int particleCount, float velocityModifier) {
        Vec3 pos = this.m_20182_();
        float spread = 0.1f;
        for (int j = 0; j < particleCount / 4; ++j) {
            Vec3 particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)).m_82490_(Math.random() * (double)velocityModifier));
            Vec3 velocity = particlePos.m_82546_(pos).m_82541_().m_82490_(Math.random() * (double)spread * (double)velocityModifier);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), this.getShooter()).setScale(0.125f).setMaxAge(40).setGravity(0.01f).setPhysics(true), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnFrostImpactParticles(int particleCount, float velocityModifier) {
        Vec3 velocity;
        Vec3 particlePos;
        int j;
        Vec3 pos = this.m_20182_();
        float spread = 0.1f;
        for (j = 0; j < particleCount / 4; ++j) {
            particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)).m_82490_(Math.random() * (double)velocityModifier));
            velocity = particlePos.m_82546_(pos).m_82541_().m_82490_(Math.random() * (double)spread * (double)velocityModifier);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), this.getShooter()).setScale(0.05f).setMaxAge(60).setGravity(0.01f).setPhysics(true), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
        for (j = 0; j < particleCount / 4; ++j) {
            particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)).m_82490_(Math.random() * (double)velocityModifier));
            velocity = particlePos.m_82546_(pos).m_82541_().m_82490_(Math.random() * (double)spread * (double)velocityModifier);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
        for (j = 0; j < particleCount / 16; ++j) {
            particlePos = pos.m_82549_(new Vec3(-0.5 + Math.random(), 0.0, -0.5 + Math.random()).m_82490_((double)velocityModifier));
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), this.getShooter()).setScale(0.1f * velocityModifier).setColor(140, 150, 160, 64).setMaxAge(60), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private void spawnBloodImpactParticles(int particleCount, float velocityModifier) {
        Vec3 velocity;
        Vec3 particlePos;
        int j;
        Vec3 pos = this.m_20182_();
        float spread = 0.1f;
        for (j = 0; j < 5; ++j) {
            particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)).m_82490_(0.25));
            velocity = particlePos.m_82546_(pos).m_82541_().m_82490_((double)0.1f).m_82490_((double)(spread * velocityModifier));
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setColor(182, 28, 28).setScale(0.25f), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
        for (j = 0; j < particleCount; ++j) {
            particlePos = pos.m_82549_(this.m_20156_().m_82542_(-1.0, -1.0, -1.0).m_82496_((float)(Math.random() * 360.0)).m_82524_((float)(Math.random() * 360.0)).m_82535_((float)(Math.random() * 360.0)).m_82490_((double)(velocityModifier / 4.0f)));
            velocity = particlePos.m_82546_(pos).m_82541_().m_82490_(Math.random() * (double)spread * (double)velocityModifier);
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(91, 14, 14).setGravity(0.05f).setPhysics(true), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnArcaneParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float spread = 0.05f;
        float spread_2 = 0.1f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3((double)(-spread) + Math.random() * (double)spread_2, (double)(-spread) + Math.random() * (double)spread, (double)(-spread) + Math.random() * (double)spread_2);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), this.getShooter()).setGravity(0.005f).setPhysics(true).setScale(0.025f), pos.f_82479_ + ((double)(-spread) + Math.random() * (double)spread * 2.0), pos.f_82480_ + ((double)(-spread) + Math.random() * (double)spread * 2.0), pos.f_82481_ + ((double)(-spread) + Math.random() * (double)spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnEnderParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())).setMaxAge(15), this.getShooter()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0));
        }
    }

    private void spawnEarthParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.05f;
        this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())).setColor(0.12156863f, 0.44313726f, 0.12156863f), pos.f_82479_ + (double)(-particle_spread + this.m_9236_().m_213780_().m_188501_() * particle_spread * 2.0f), pos.f_82480_ + (double)(-particle_spread + this.m_9236_().m_213780_().m_188501_() * particle_spread * 2.0f), pos.f_82481_ + (double)(-particle_spread + this.m_9236_().m_213780_().m_188501_() * particle_spread * 2.0f), 0.0, 0.0, 0.0);
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), this.getShooter()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnWaterParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.05f;
        float velocity_spread = 0.025f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, Math.random() * (double)velocity_spread, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DRIP.get())).setGravity(0.025f).setPhysics(true).setScale(0.05f), this.getShooter()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnFireParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.05f;
        float velocity_spread = 0.025f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setScale(0.01f), this.getShooter()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnHellfireParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.05f;
        float velocity_spread = 0.025f;
        float scale = this.getSpecialRenderType() == SpecialRenderType.HELLBALL ? 0.05f : 0.01f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())).setScale(scale), this.getShooter()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnLightningParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        double radius = 0.25;
        Vec3 motion = this.m_20184_();
        int particleLife = (int)(5.0 + Math.random() * 5.0);
        this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())).setMaxAge(particleLife), this.getShooter()), pos.f_82479_ - radius + Math.random() * radius * 2.0, pos.f_82480_ - radius + Math.random() * radius * 2.0, pos.f_82481_ - radius + Math.random() * radius * 2.0, pos.f_82479_ + motion.f_82479_ * (double)particleLife / 2.0, pos.f_82480_ + motion.f_82480_ * (double)particleLife / 2.0, pos.f_82481_ + motion.f_82481_ * (double)particleLife / 2.0);
    }

    private void spawnWindParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.05f;
        float velocity_spread = 0.025f;
        for (int i = 0; i < particleCount; ++i) {
            Vec3 vSpread = new Vec3((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            Vec3 velocity = this.m_20184_().m_82490_((double)-0.2f).m_82549_(vSpread);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setMaxAge(10).setScale(0.2f).setColor(3, 3, 3), this.getShooter()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0) + this.m_20184_().f_82479_ * Math.random(), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0) + this.m_20184_().f_82480_ * Math.random(), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0) + this.m_20184_().f_82481_ * Math.random(), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnFrostParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount / 2; ++j) {
            Vec3 velocity = new Vec3((double)-0.01f + Math.random() * (double)0.02f, (double)-0.05f + Math.random() * (double)0.05f, (double)-0.01f + Math.random() * (double)0.02f);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setScale(0.01f).setGravity(0.005f).setPhysics(true), this.getShooter()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void spawnBloodParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.1f;
        float velocity_spread = 0.025f;
        for (int j = 0; j < particleCount / 2; ++j) {
            Vec3 velocity = new Vec3((double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0, Math.random() * (double)velocity_spread, (double)(-velocity_spread) + Math.random() * (double)velocity_spread * 2.0);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(91, 14, 14).setGravity(0.05f).setPhysics(true).setScale(0.05f), this.getShooter()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public static enum SpecialRenderType {
        NONE,
        HALLOWEEN,
        HELLBALL;

    }
}

