/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.spells.targeting.SpellTargetHelper;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.base.ChanneledSpellEntity;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.BlockUtils;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.LineSegment;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpellBeam
extends ChanneledSpellEntity {
    private static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);
    private boolean lastTickMissed = true;
    private Vec3 lastTickImpact = null;
    private Vec3 lastTickTarget = null;
    private BlockPos lastTickBlockPos = null;
    private Direction lastTickBlockFace = Direction.UP;

    public SpellBeam(EntityType<? extends SpellBeam> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public SpellBeam(LivingEntity caster, ISpellDefinition spell, Level world) {
        super((EntityType<? extends ChanneledSpellEntity>)((EntityType)EntityInit.SPELL_BEAM.get()), caster, spell, world);
        this.m_6034_(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
        this.m_19915_(this.getCaster().m_146908_(), this.getCaster().m_146909_());
    }

    @Override
    public void m_8119_() {
        LivingEntity caster = this.getCaster();
        SpellRecipe recipe = this.getSpell();
        if (caster != null && recipe != null && recipe.isValid()) {
            List<Affinity> pfx_affs;
            float range = this.getShapeAttributeByAge(Attribute.RANGE);
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
            Vec3 newPos = caster.m_20182_().m_82520_(0.0, (double)(caster.m_20192_() - 0.1f), 0.0);
            Pair<Vec3, Vec3> lookCross = MathUtils.getLookCross(caster);
            HumanoidArm casterHandedness = caster.m_5737_();
            newPos = casterHandedness == HumanoidArm.RIGHT && caster.m_7655_() == InteractionHand.MAIN_HAND || casterHandedness == HumanoidArm.LEFT && caster.m_7655_() == InteractionHand.OFF_HAND ? newPos.m_82549_(((Vec3)lookCross.getSecond()).m_82490_((double)0.1f)) : newPos.m_82549_(((Vec3)lookCross.getSecond()).m_82490_((double)-0.1f));
            this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            this.m_146926_(caster.m_146909_());
            this.f_19860_ = caster.f_19860_;
            this.m_146922_(caster.f_20885_);
            this.f_19859_ = caster.f_20886_;
            HitResult result = SpellTargetHelper.rayTrace(this, this.m_9236_(), this.m_20182_(), caster.m_20154_(), true, false, ClipContext.Block.COLLIDER, entity -> entity.m_6087_() && entity.m_6084_() && entity != caster, caster.m_20191_().m_82377_((double)range, (double)range, (double)range), range);
            this.lastTickImpact = result.m_82450_();
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                this.lastTickBlockPos = ((BlockHitResult)result).m_82425_();
                this.lastTickBlockFace = ((BlockHitResult)result).m_82434_();
                this.lastTickTarget = this.lastTickImpact;
            } else if (result.m_6662_() == HitResult.Type.ENTITY) {
                this.lastTickTarget = ((EntityHitResult)result).m_82443_().m_20182_();
                this.lastTickBlockPos = BlockPos.m_274446_((Position)this.lastTickTarget);
            }
            this.lastTickMissed = result.m_6662_() == HitResult.Type.MISS;
            if (this.m_9236_().m_5776_() && (pfx_affs = Arrays.asList(Affinity.FIRE, Affinity.ARCANE, Affinity.HELLFIRE, Affinity.LIGHTNING, Affinity.WIND, Affinity.ENDER, Affinity.ICE)).contains((Object)recipe.getHighestAffinity())) {
                Vec3 target = this.lastTickImpact != null ? this.lastTickImpact : this.m_20154_().m_82541_().m_82490_((double)range);
                int[] clr = this.getBeamColor();
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())).setColor(clr[0], clr[1], clr[2]).setScale(0.01f).setMaxAge(5).setAgePadding(5).setGravity(0.02f), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
            }
        } else {
            this.lastTickMissed = true;
        }
        super.m_8119_();
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, LivingEntity caster, ServerLevel world) {
        if (this.lastTickMissed || caster == null) {
            return;
        }
        IModifiedSpellPart s = recipe.getShape();
        float radius_h = ((ModifiedSpellPart)s).getValue(Attribute.WIDTH) / 2.0f;
        float radius_v = ((ModifiedSpellPart)s).getValue(Attribute.HEIGHT) / 2.0f;
        float radius_d = ((ModifiedSpellPart)s).getValue(Attribute.DEPTH) * Math.max((float)this.f_19797_ / 20.0f, 1.0f) / 2.0f;
        SpellSource source = new SpellSource(caster, caster.m_7655_());
        List<Entity> entities = this.targetEntities(this.lastTickTarget, radius_h * 2.0f, radius_v * 2.0f, radius_d);
        BlockPos[] blocks = this.targetBlocks(this.lastTickBlockPos, radius_h, radius_v, radius_d);
        SpellContext context = new SpellContext((Level)world, recipe, this);
        for (Entity e : entities) {
            SpellCaster.ApplyComponents(recipe, source, new SpellTarget(e), context);
        }
        for (BlockPos b : blocks) {
            SpellCaster.ApplyComponents(recipe, source, new SpellTarget(b, this.lastTickBlockFace), context);
        }
    }

    @Override
    protected void spawnAirParticles(SpellRecipe recipe) {
        this.spawnParticles(recipe, (MAParticleType)((Object)ParticleInit.AIR_VELOCITY.get()), 10, 0.1f);
    }

    @Override
    protected void spawnEarthParticles(SpellRecipe recipe) {
        this.spawnParticles(recipe, (MAParticleType)((Object)ParticleInit.DUST.get()), 5, 0.01f);
        float particle_spread = 0.2f;
        this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())).setGravity(0.02f), (Entity)this.getCaster()), this.lastTickImpact.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), -0.06 + Math.random() * 0.12, 0.05 + Math.random() * 0.05, -0.06 + Math.random() * 0.12);
    }

    @Override
    protected void spawnFireParticles(SpellRecipe recipe, boolean hellfire, boolean lightning) {
        if (!lightning) {
            this.spawnParticles(recipe, hellfire ? (MAParticleType)((Object)ParticleInit.HELLFIRE.get()) : (MAParticleType)((Object)ParticleInit.FLAME.get()), 20, 0.01f);
        } else {
            this.spawnLightningParticles(recipe, (MAParticleType)((Object)ParticleInit.LIGHTNING_BOLT.get()), 1);
        }
    }

    @Override
    protected void spawnWaterParticles(SpellRecipe recipe, boolean frost) {
        this.spawnParticles(recipe, frost ? (MAParticleType)((Object)ParticleInit.FROST.get()) : (MAParticleType)((Object)ParticleInit.WATER.get()), 10, 0.01f);
    }

    @Override
    protected void spawnEnderParticles(SpellRecipe recipe, boolean blood) {
        if (blood) {
            this.spawnParticles(recipe, (MAParticleType)((Object)ParticleInit.DROPLET.get()), 10, 0.01f, p -> {
                p.setColor(Affinity.BLOOD);
                p.setPhysics(true);
                p.setGravity(0.05f);
                p.setMaxAge(5);
            });
        } else {
            this.spawnParticles(recipe, (MAParticleType)((Object)ParticleInit.ENDER_VELOCITY.get()), 10, 0.01f);
        }
    }

    @Override
    protected void spawnArcaneParticles(SpellRecipe recipe) {
        this.spawnParticles(recipe, (MAParticleType)((Object)ParticleInit.ARCANE.get()), 10, 0.01f);
    }

    private void spawnParticles(SpellRecipe recipe, MAParticleType type, int amount, float velocity) {
        this.spawnParticles(recipe, type, amount, velocity, null);
    }

    private void spawnParticles(SpellRecipe recipe, MAParticleType type, int amount, float velocity, Consumer<MAParticleType> particleAdjuster) {
        if (this.lastTickMissed) {
            return;
        }
        float particle_spread = 0.2f;
        for (int i = 0; i < amount; ++i) {
            MAParticleType particle = new MAParticleType(type);
            if (particleAdjuster != null) {
                particleAdjuster.accept(particle);
            }
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(particle, (Entity)this.getCaster()), this.lastTickImpact.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)(-velocity) + Math.random() * (double)velocity * 2.0, (double)(-velocity) + Math.random() * (double)velocity * 2.0, (double)(-velocity) + Math.random() * (double)velocity * 2.0);
        }
    }

    private void spawnLightningParticles(SpellRecipe recipe, MAParticleType type, int amount) {
        if (this.lastTickMissed) {
            return;
        }
        float particle_spread = 0.5f;
        for (int i = 0; i < amount; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType(type), (Entity)this.getCaster()), this.lastTickImpact.f_82479_, this.lastTickImpact.f_82480_, this.lastTickImpact.f_82481_, this.lastTickImpact.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.lastTickImpact.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0));
        }
    }

    protected BlockPos[] targetBlocks(BlockPos impactPoint, float radius_h, float radius_v, float radius_d) {
        BlockPos projectedDepthPoint = BlockUtils.Vector3dToBlockPosRound(this.m_20154_().m_82541_().m_82490_((double)radius_d).m_82520_((double)impactPoint.m_123341_(), (double)impactPoint.m_123342_(), (double)impactPoint.m_123343_()));
        return this.getAllBlockLocationsDepth(impactPoint, projectedDepthPoint, radius_h, radius_v);
    }

    private BlockPos[] getAllBlockLocationsDepth(BlockPos startPoint, BlockPos endPoint, float radius_h, float radius_v) {
        double radiusOffsetX = Math.cos(Math.toRadians(this.m_146908_())) * (double)radius_h;
        double radiusOffsetZ = Math.sin(Math.toRadians(this.m_146908_())) * (double)radius_h;
        ArrayList vecList = new ArrayList();
        BlockUtils.stepThroughBlocksLinear(startPoint, endPoint, pos -> {
            BlockPos[] positions;
            Vec3 a = new Vec3((double)pos.m_123341_() + radiusOffsetX, (double)pos.m_123342_(), (double)pos.m_123343_() + radiusOffsetZ);
            Vec3 b = new Vec3((double)pos.m_123341_() - radiusOffsetX, (double)pos.m_123342_(), (double)pos.m_123343_() - radiusOffsetZ);
            for (BlockPos position : positions = this.getAllBlockLocationsHorizontal(BlockUtils.Vector3dToBlockPosRound(a), BlockUtils.Vector3dToBlockPosRound(b))) {
                int y = -((int)Math.floor(radius_v));
                while ((double)y <= Math.floor(radius_v)) {
                    BlockPos vOffset = position.m_7918_(0, y, 0);
                    if (!vecList.contains(vOffset)) {
                        vecList.add(vOffset);
                    }
                    ++y;
                }
            }
        });
        return vecList.toArray(new BlockPos[0]);
    }

    private BlockPos[] getAllBlockLocationsHorizontal(BlockPos p1, BlockPos p2) {
        ArrayList allPoints = new ArrayList();
        BlockUtils.stepThroughBlocksLinear(p1, p2, pos -> {
            if (!allPoints.contains(pos)) {
                allPoints.add(pos);
            }
        });
        return allPoints.toArray(new BlockPos[0]);
    }

    public int[] getBeamColor() {
        SpellRecipe recipe = this.getSpell();
        if (recipe == null) {
            return new int[]{255, 255, 255};
        }
        int override = this.getOverrideColor();
        if (override == -1) {
            return recipe.getHighestAffinity().getColor();
        }
        return new int[]{FastColor.ARGB32.m_13665_((int)override), FastColor.ARGB32.m_13667_((int)override), FastColor.ARGB32.m_13669_((int)override)};
    }

    protected List<Entity> targetEntities(Vec3 impactPoint, float width, float height, float depth) {
        Vec3 forward = this.m_20154_().m_82541_();
        Vec3 center = impactPoint.m_82549_(forward.m_82490_((double)(depth / 2.0f)));
        AABB bb = new AABB(BlockPos.m_274446_((Position)center)).m_82400_((double)Math.max(width, Math.max(height, depth)));
        List possibleTargets = this.m_9236_().m_45933_((Entity)this.getCaster(), bb);
        ArrayList<Entity> targets = new ArrayList<Entity>();
        float r_width = width / 2.0f;
        float r_height = height / 2.0f;
        float r_depth = depth / 2.0f;
        Vec3 depth_a = impactPoint;
        Vec3 depth_b = impactPoint.m_82549_(forward.m_82490_((double)depth));
        Vec3 horizontal_a = center.m_82549_(forward.m_82537_(UP).m_82490_((double)r_width));
        Vec3 horizontal_b = center.m_82549_(forward.m_82537_(UP).m_82490_((double)(-r_width)));
        LineSegment line_horizontal = new LineSegment(horizontal_a, horizontal_b);
        LineSegment line_depth = new LineSegment(depth_a, depth_b);
        for (Entity e : possibleTargets) {
            if (e == this || e == this.getCaster()) continue;
            Vec3 target = e.m_20182_();
            Vec3 closest_horizontal = line_horizontal.closestPointOnLine(target);
            Vec3 closest_depth = line_depth.closestPointOnLine(target);
            target = target.m_82492_(0.0, target.f_82480_, 0.0);
            closest_horizontal = closest_horizontal.m_82492_(0.0, closest_horizontal.f_82480_, 0.0);
            closest_depth = closest_depth.m_82492_(0.0, closest_depth.f_82480_, 0.0);
            double depthDist = Math.abs(closest_horizontal.m_82554_(target));
            double heightDist = Math.abs(center.f_82480_ - e.m_20186_());
            double widthDist = closest_depth.m_82554_(target);
            if (!(widthDist >= (double)(-r_width)) || !(widthDist <= (double)r_width) || !(heightDist >= (double)(-r_height)) || !(heightDist <= (double)r_height) || !(depthDist >= (double)(-r_depth)) || !(depthDist <= (double)r_depth)) continue;
            targets.add(e);
        }
        return targets;
    }

    public Vec3 getLastTickImpact() {
        return this.lastTickImpact;
    }
}

