/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import java.util.HashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;

public class BoundBowProjectile
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> AFFINITY = SynchedEntityData.m_135353_(BoundBowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private ISpellDefinition spell;

    public BoundBowProjectile(EntityType<? extends AbstractArrow> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.m_20331_(true);
    }

    public void setSpell(ISpellDefinition recipe) {
        this.spell = recipe;
        this.f_19804_.m_135381_(AFFINITY, (Object)this.spell.getHighestAffinity().ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AFFINITY, (Object)Affinity.ARCANE.ordinal());
    }

    public Affinity getAffinity() {
        return Affinity.values()[(Integer)this.f_19804_.m_135370_(AFFINITY)];
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            float spread = 0.2f;
            for (int i = 0; i < 10; ++i) {
                double velMod = Math.random();
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), this.m_20185_() - (double)spread * (Math.random() * (double)spread * 2.0), this.m_20186_() - (double)spread * (Math.random() * (double)spread * 2.0), this.m_20189_() - (double)spread * (Math.random() * (double)spread * 2.0), this.m_20184_().f_82479_ * velMod, this.m_20184_().f_82480_ * velMod, this.m_20184_().f_82481_ * velMod);
            }
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_7380_(CompoundTag compound) {
        if (this.spell != null && this.spell.isValid()) {
            this.spell.writeToNBT(compound);
        }
    }

    public void m_7378_(CompoundTag compound) {
        this.spell = SpellRecipe.fromNBT(compound);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_5790_(EntityHitResult result) {
        if (!this.m_9236_().m_5776_() && this.spell != null && this.spell.isValid()) {
            Entity shooter = this.m_19749_();
            if (shooter != null && shooter instanceof LivingEntity) {
                SpellSource source = new SpellSource((LivingEntity)shooter, InteractionHand.MAIN_HAND);
                SpellTarget target = new SpellTarget(result.m_82443_());
                SpellContext context = new SpellContext(this.m_9236_(), this.spell);
                HashMap<SpellEffect, ComponentApplicationResult> results = SpellCaster.ApplyComponents(this.spell, source, target, context);
                if (this.m_19749_() instanceof Player) {
                    results.entrySet().forEach(e -> {
                        if (((ComponentApplicationResult)((Object)((Object)e.getValue()))).is_success) {
                            SpellCaster.addComponentRoteProgress((Player)this.m_19749_(), (SpellEffect)e.getKey());
                        }
                    });
                }
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        if (!this.m_9236_().m_5776_() && this.spell != null && this.spell.isValid()) {
            Entity shooter = this.m_19749_();
            if (shooter != null && shooter instanceof LivingEntity) {
                SpellSource source = new SpellSource((LivingEntity)shooter, InteractionHand.MAIN_HAND);
                SpellTarget target = new SpellTarget(result.m_82425_(), result.m_82434_());
                SpellContext context = new SpellContext(this.m_9236_(), this.spell);
                HashMap<SpellEffect, ComponentApplicationResult> results = SpellCaster.ApplyComponents(this.spell, source, target, context);
                if (this.m_19749_() instanceof Player) {
                    results.entrySet().forEach(e -> {
                        if (((ComponentApplicationResult)((Object)((Object)e.getValue()))).is_success) {
                            SpellCaster.addComponentRoteProgress((Player)this.m_19749_(), (SpellEffect)e.getKey());
                        }
                    });
                }
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

