/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.rituals;

import com.mna.api.config.GeneralConfigValues;
import com.mna.api.particles.ParticleInit;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.tools.math.MathUtils;
import com.mna.tools.math.Vector3;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class TimeChangeBall
extends Entity {
    private static final EntityDataAccessor<Byte> ENTITY_STATE = SynchedEntityData.m_135353_(TimeChangeBall.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> TIME_CHANGE_TYPE = SynchedEntityData.m_135353_(TimeChangeBall.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Byte STATE_WAITING = 0;
    private static final Byte STATE_SHOOTING = 1;
    public static final int WAIT_TIME = 120;
    public static final int LERP_TIME = 100;
    public static final Byte TIME_CHANGE_DAY = 0;
    public static final Byte TIME_CHANGE_NIGHT = 1;
    private static final String EVENT_ID = "timeChange";
    private int age;
    Vector3 startPoint;
    Vector3 endPoint;
    Vector3 controlPoint1;
    Vector3 controlPoint2;
    Vec3 lastPosition;
    boolean pointsSet = false;

    public TimeChangeBall(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.m_20331_(true);
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public void m_8119_() {
        this.setAge(this.getAge() + 1);
        if (this.m_9236_().m_5776_()) {
            int max_particles_per_tick = 5;
            int numParticles = Math.max((int)Math.ceil((float)this.getAge() / 120.0f * (float)max_particles_per_tick), max_particles_per_tick);
            float radiusScale = 0.25f;
            for (int i = 0; i < numParticles; ++i) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleInit.SPARKLE_VELOCITY.get(), true, this.m_20185_() + (Math.random() - 0.5) * (double)radiusScale, this.m_20186_() + (Math.random() - 0.5) * (double)radiusScale, this.m_20189_() + (Math.random() - 0.5) * (double)radiusScale, 0.0, -0.5, 0.0);
            }
        }
        if (this.getAge() < 120) {
            float f = (float)this.getAge() / 120.0f;
            this.m_20334_(1.0f + f, -1.0f - f * 9.0f, 1.0f + f);
            return;
        }
        if (this.getAge() >= 120 && this.getState() != STATE_SHOOTING.byteValue()) {
            this.setState(STATE_SHOOTING);
            if (!this.m_9236_().m_5776_()) {
                this.queueTimeChange();
            }
        }
        if (this.getState() == STATE_SHOOTING.byteValue()) {
            if (!this.pointsSet) {
                this.setPoints();
            }
            float f = ((float)this.getAge() - 120.0f) / 100.0f;
            float f1 = ((float)this.getAge() + 1.0f - 120.0f) / 100.0f;
            this.lastPosition = this.m_20182_();
            Vector3 curPoint = Vector3.bezier(this.startPoint, this.endPoint, this.controlPoint1, this.controlPoint2, f);
            Vector3 nextPoint = Vector3.bezier(this.startPoint, this.endPoint, this.controlPoint1, this.controlPoint2, f1);
            this.m_6034_(curPoint.x, curPoint.y, curPoint.z);
            Vector3 diff = nextPoint.sub(curPoint).normalize();
            float angle = (float)(Math.atan2(diff.x, diff.y) * 180.0 / Math.PI);
            this.m_20334_(2.0, -10.0, 2.0);
            this.m_146926_(angle);
            if (this.getAge() >= 220) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private boolean queueTimeChange() {
        int targetTime = -1;
        long wrappedWorldTime = this.m_9236_().m_46468_() % 24000L;
        if (this.m_9236_().m_46461_() && this.getTimeChangeType() == TIME_CHANGE_NIGHT.byteValue()) {
            targetTime = (int)(13000L - wrappedWorldTime);
        } else if (this.m_9236_().m_46462_() && this.getTimeChangeType() == TIME_CHANGE_DAY.byteValue()) {
            targetTime = 24000 - (int)wrappedWorldTime;
        }
        if (targetTime == -1) {
            return false;
        }
        if (!DelayedEventQueue.hasEvent(this.m_9236_(), EVENT_ID)) {
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Pair>(EVENT_ID, 100, new Pair((Object)((ServerLevel)this.m_9236_()), (Object)targetTime), TimeChangeBall::flipDayNight));
            return true;
        }
        return false;
    }

    private static void flipDayNight(String identifier, Pair<ServerLevel, Integer> data) {
        int shift;
        ServerLevel world = (ServerLevel)data.getFirst();
        int timeRemaining = (Integer)data.getSecond();
        int n = shift = GeneralConfigValues.GradualTimeChange ? MathUtils.clamp(timeRemaining, 0, 100) : timeRemaining;
        if (shift == 0) {
            return;
        }
        world.m_8615_(world.m_46468_() + (long)shift);
        ClientboundSetTimePacket pkt = new ClientboundSetTimePacket(world.m_46467_(), world.m_46468_(), world.m_46469_().m_46207_(GameRules.f_46140_));
        world.m_7654_().m_6846_().m_11270_((Packet)pkt, world.m_46472_());
        DelayedEventQueue.pushEvent((Level)world, new TimedDelayedEvent<Pair>(identifier, 3, new Pair((Object)world, (Object)(timeRemaining - shift)), TimeChangeBall::flipDayNight));
    }

    private void setPoints() {
        this.startPoint = new Vector3(this);
        this.endPoint = this.getCelestialPosition();
        this.controlPoint1 = Vector3.lerp(this.startPoint, this.endPoint, 0.25f);
        this.controlPoint2 = Vector3.lerp(this.startPoint, this.endPoint, 0.75f);
        this.controlPoint1.y = this.endPoint.y;
        this.controlPoint2.y = this.endPoint.y;
        this.pointsSet = true;
    }

    private Vector3 getCelestialPosition() {
        float celestialAngleRads = this.m_9236_().m_46490_(0.0f) + 1.5707964f;
        if (this.getTimeChangeType() == TIME_CHANGE_DAY.byteValue()) {
            celestialAngleRads = (float)((double)celestialAngleRads + Math.PI);
        }
        double cAngle = Math.cos(celestialAngleRads);
        double sAngle = Math.sin(celestialAngleRads);
        float distance = 150.0f;
        return new Vector3(this.m_20185_() + cAngle * (double)distance, this.m_20186_() + sAngle * (double)distance, this.m_20189_());
    }

    public void setTimeChangeType(byte type) {
        this.f_19804_.m_135381_(TIME_CHANGE_TYPE, (Object)type);
    }

    public byte getTimeChangeType() {
        return (Byte)this.f_19804_.m_135370_(TIME_CHANGE_TYPE);
    }

    public byte getState() {
        return (Byte)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    private void setState(byte state) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)state);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)STATE_WAITING);
        this.f_19804_.m_135372_(TIME_CHANGE_TYPE, (Object)TIME_CHANGE_DAY);
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6043_() {
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }
}

