/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.sorcery;

import com.mna.api.affinity.Affinity;
import com.mna.api.tools.RLoc;
import com.mna.entities.sorcery.targeting.SpellProjectile;
import com.mna.tools.render.ModelUtils;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;

public class SpellProjectileRenderer
extends EntityRenderer<SpellProjectile> {
    public static final ResourceLocation model_water = RLoc.create("fx/projectile/spell_projectile_water");
    public static final ResourceLocation model_water2 = RLoc.create("fx/projectile/spell_projectile_water2");
    public static final ResourceLocation model_ice = RLoc.create("fx/projectile/spell_projectile_ice");
    public static final ResourceLocation model_ice2 = RLoc.create("fx/projectile/spell_projectile_ice2");
    public static final ResourceLocation model_earth = RLoc.create("fx/projectile/spell_projectile_earth");
    public static final ResourceLocation model_earth2 = RLoc.create("fx/projectile/spell_projectile_earth2");
    public static final ResourceLocation model_wind = RLoc.create("fx/projectile/spell_projectile_wind");
    public static final ResourceLocation model_wind2 = RLoc.create("fx/projectile/spell_projectile_wind2");
    public static final ResourceLocation model_ender = RLoc.create("fx/projectile/spell_projectile_ender");
    public static final ResourceLocation model_ender2 = RLoc.create("fx/projectile/spell_projectile_ender2");
    final Minecraft mc = Minecraft.m_91087_();

    public SpellProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SpellProjectile entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (!Minecraft.m_91087_().m_91104_()) {
            entityIn.spawnParticles(2, partialTicks);
        }
        ArrayList<Affinity> affs = entityIn.getAffinity();
        Affinity aff = Affinity.UNKNOWN;
        if (affs != null) {
            aff = affs.get(0);
        }
        Minecraft mc = Minecraft.m_91087_();
        int[] clr = aff.getColor();
        int[] sec = aff.getSecondaryColor();
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110466_());
        block0 : switch (entityIn.getSpecialRenderType()) {
            case HELLBALL: {
                this.renderWaterProjectile(entityIn, builder, matrixStackIn, packedLightIn, clr);
                WorldRenderUtils.renderRadiant((Entity)entityIn, matrixStackIn, bufferIn, clr, sec, 255, 0.2f);
                break;
            }
            case HALLOWEEN: {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityIn.m_146908_() + 180.0f));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(entityIn.m_146909_()));
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                mc.m_91291_().m_269128_(entityIn.getSpecialRenderStack(), ItemDisplayContext.FIXED, packedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)mc.f_91073_, 0);
                matrixStackIn.m_85849_();
                break;
            }
            default: {
                int override = entityIn.getOverrideColor();
                if (override != -1) {
                    clr = new int[]{FastColor.ARGB32.m_13665_((int)override), FastColor.ARGB32.m_13667_((int)override), FastColor.ARGB32.m_13669_((int)override)};
                    sec = clr;
                }
                switch (aff) {
                    case ARCANE: {
                        this.renderWaterProjectile(entityIn, builder, matrixStackIn, packedLightIn, sec);
                        matrixStackIn.m_85837_(0.0, 0.0, 0.01);
                        this.renderWaterProjectile(entityIn, builder, matrixStackIn, packedLightIn, clr);
                        break block0;
                    }
                    case ICE: {
                        this.renderIceProjectile(entityIn, builder, matrixStackIn, packedLightIn, clr);
                        break block0;
                    }
                    case EARTH: {
                        this.renderEarthProjectile(entityIn, bufferIn.m_6299_(RenderType.m_110451_()), matrixStackIn, packedLightIn, clr);
                        break block0;
                    }
                    case WIND: {
                        this.renderWindProjectile(entityIn, builder, matrixStackIn, packedLightIn, clr);
                        break block0;
                    }
                    case ENDER: {
                        if (override != -1) {
                            clr = new int[]{FastColor.ARGB32.m_13665_((int)override), FastColor.ARGB32.m_13667_((int)override), FastColor.ARGB32.m_13669_((int)override)};
                            sec = clr;
                        } else {
                            clr = new int[]{15, 6, 22};
                            sec = Affinity.ENDER.getColor();
                        }
                        this.renderEnderProjectile(entityIn, builder, matrixStackIn, packedLightIn, clr, sec);
                        break block0;
                    }
                    case LIGHTNING: {
                        break block0;
                    }
                }
                this.renderWaterProjectile(entityIn, builder, matrixStackIn, packedLightIn, clr);
            }
        }
    }

    private void renderWindProjectile(SpellProjectile entityIn, VertexConsumer builder, PoseStack matrixStackIn, int packedLightIn, int[] color) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityIn.m_146908_()));
        matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(entityIn.m_146909_()));
        matrixStackIn.m_252781_(Axis.f_252393_.m_252977_((float)(entityIn.f_19797_ * 10)));
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_wind2, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f}, 0.25f);
        matrixStackIn.m_252781_(Axis.f_252393_.m_252977_((float)(entityIn.f_19797_ * -20)));
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_wind, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f}, 0.25f);
        matrixStackIn.m_85849_();
    }

    private void renderEnderProjectile(SpellProjectile entityIn, VertexConsumer builder, PoseStack matrixStackIn, int packedLightIn, int[] color, int[] sec) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityIn.m_146908_()));
        matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(entityIn.m_146909_()));
        matrixStackIn.m_252781_(Axis.f_252393_.m_252977_((float)(entityIn.f_19797_ * 10)));
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_ender2, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f}, 1.0f);
        matrixStackIn.m_252781_(Axis.f_252393_.m_252977_((float)(entityIn.f_19797_ * -20)));
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_ender, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{(float)sec[0] / 255.0f, (float)sec[1] / 255.0f, (float)sec[2] / 255.0f}, 1.0f);
        matrixStackIn.m_85849_();
    }

    private void renderWaterProjectile(SpellProjectile entityIn, VertexConsumer builder, PoseStack matrixStackIn, int packedLightIn, int[] color) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityIn.m_146908_()));
        matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(entityIn.m_146909_()));
        matrixStackIn.m_252781_(Axis.f_252393_.m_252977_((float)(entityIn.f_19797_ * 10)));
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_water, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f}, 0.75f);
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_water2, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{1.0f, 1.0f, 1.0f}, 0.5f);
        matrixStackIn.m_85849_();
    }

    private void renderIceProjectile(SpellProjectile entityIn, VertexConsumer builder, PoseStack matrixStackIn, int packedLightIn, int[] color) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityIn.m_146908_()));
        matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(entityIn.m_146909_()));
        matrixStackIn.m_252781_(Axis.f_252393_.m_252977_((float)(entityIn.f_19797_ * 20)));
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_ice2, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{1.0f, 1.0f, 1.0f}, 0.5f);
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_ice, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f}, 0.75f);
        matrixStackIn.m_85849_();
    }

    private void renderEarthProjectile(SpellProjectile entityIn, VertexConsumer builder, PoseStack matrixStackIn, int packedLightIn, int[] color) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityIn.m_146908_()));
        matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(entityIn.m_146909_()));
        matrixStackIn.m_252781_(Axis.f_252393_.m_252977_((float)(entityIn.f_19797_ * 20)));
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_earth2, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{1.0f, 1.0f, 1.0f}, 0.5f);
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_earth, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f}, 0.75f);
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(SpellProjectile entity) {
        return null;
    }
}

