/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.sorcery;

import com.mna.entities.sorcery.Rift;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RiftRenderer
extends EntityRenderer<Rift> {
    private static final ResourceLocation PORTAL_TEXTURE = new ResourceLocation("mna", "textures/entity/vortex.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)PORTAL_TEXTURE);

    public RiftRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(Rift entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        int[] nArray;
        int[] nArray2;
        Quaternionf cameraRotation = this.f_114476_.m_253208_();
        Quaternionf portalRotation = new Quaternionf(0.0f, cameraRotation.y(), 0.0f, cameraRotation.w());
        float spawnPct = entityIn.getAge() < 20 ? (float)Math.min(entityIn.getAge(), 20) / 20.0f : (entityIn.getAge() > 180 ? 1.0f - (float)Math.min(entityIn.getAge() - 180, 20) / 20.0f : 1.0f);
        float scaleFactor = 1.0f * spawnPct;
        float portalSpinDegrees = entityIn.getAge() * 3 % 360;
        float verticalOffset = 1.0f;
        VertexConsumer vertexBuilder = bufferIn.m_6299_(RENDER_TYPE);
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.0f, verticalOffset, 0.0f);
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        matrixStackIn.m_252781_(portalRotation);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(portalSpinDegrees));
        matrixStackIn.m_252880_(0.0f, -0.25f, 0.0f);
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f renderMatrix = matrixstack$entry.m_252922_();
        Matrix3f normalMatrix = matrixstack$entry.m_252943_();
        float nrmV = (float)Math.cos((double)portalSpinDegrees * Math.PI / 180.0);
        float nrmH = (float)Math.cos((double)(portalSpinDegrees - 90.0f) * Math.PI / 180.0);
        if (entityIn.getIsEnderChest()) {
            int[] nArray3 = new int[4];
            nArray3[0] = 3;
            nArray3[1] = 38;
            nArray3[2] = 32;
            nArray2 = nArray3;
            nArray3[3] = 230;
        } else {
            int[] nArray4 = new int[4];
            nArray4[0] = 105;
            nArray4[1] = 24;
            nArray4[2] = 152;
            nArray2 = nArray4;
            nArray4[3] = 230;
        }
        int[] color = nArray2;
        RiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, color);
        RiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, color);
        RiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, color);
        RiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, color);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.0f, verticalOffset, 0.0f);
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        matrixStackIn.m_252781_(portalRotation);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-portalSpinDegrees));
        matrixStackIn.m_252880_(0.0f, -0.25f, 0.001f);
        matrixstack$entry = matrixStackIn.m_85850_();
        renderMatrix = matrixstack$entry.m_252922_();
        normalMatrix = matrixstack$entry.m_252943_();
        nrmH = (float)Math.cos((double)(portalSpinDegrees + 90.0f) * Math.PI / 180.0);
        if (entityIn.getIsEnderChest()) {
            int[] nArray5 = new int[4];
            nArray5[0] = 52;
            nArray5[1] = 153;
            nArray5[2] = 136;
            nArray = nArray5;
            nArray5[3] = 230;
        } else {
            int[] nArray6 = new int[4];
            nArray6[0] = 186;
            nArray6[1] = 30;
            nArray6[2] = 180;
            nArray = nArray6;
            nArray6[3] = 230;
        }
        color = nArray;
        RiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, color);
        RiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, color);
        RiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, color);
        RiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, color);
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private static void addVertex(VertexConsumer vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV, int[] color) {
        if (color.length != 4) {
            return;
        }
        vertexBuilder_.m_252986_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nrmH, nrmV, nrmH).m_5752_();
    }

    public ResourceLocation getTextureLocation(Rift entity) {
        return PORTAL_TEXTURE;
    }
}

