/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.ritual;

import com.mna.api.tools.RLoc;
import com.mna.entities.models.AncientWizardModel;
import com.mna.entities.rituals.AncientCouncil;
import com.mna.tools.render.MARenderTypes;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class AncientCouncilRenderer
extends EntityRenderer<AncientCouncil> {
    private static final ResourceLocation ANCIENT_WIZARD_TEXTURE = RLoc.create("textures/entity/ancient_wizard.png");
    protected final AncientWizardModel<AncientCouncil> modelWizard = new AncientWizardModel(Minecraft.m_91087_().m_167973_().m_171103_(AncientWizardModel.LAYER_LOCATION));

    public AncientCouncilRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(AncientCouncil entity) {
        return ANCIENT_WIZARD_TEXTURE;
    }

    public void render(AncientCouncil entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        int age = entityIn.f_19797_;
        matrixStackIn.m_252880_(0.0f, -1.0f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float angleDegrees = 0.0f;
        int numWizards = 6;
        for (int i = 0; i < numWizards; ++i) {
            matrixStackIn.m_85836_();
            float riseAmount = Math.min(((float)age + partialTicks) / 70.0f * 2.5f, 2.5f);
            matrixStackIn.m_252880_(0.0f, -riseAmount, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(angleDegrees));
            matrixStackIn.m_252880_(-3.0f, 0.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            this.modelWizard.setupAnim(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.modelWizard.m_103119_(this.getTextureLocation(entityIn)));
            this.modelWizard.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
            if (entityIn.getRadiantPct() > 0.0f) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.0f, -riseAmount, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(angleDegrees));
                matrixStackIn.m_252880_(-2.25f, 0.5f - 1.25f * entityIn.getRadiantLift(), 0.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                WorldRenderUtils.renderRadiant((Entity)entityIn, matrixStackIn, bufferIn, new int[]{203, 8, 112}, new int[]{151, 25, 151}, (int)Math.floor(entityIn.getRadiantPct() * 255.0f), 0.05f);
                matrixStackIn.m_85849_();
            }
            if (entityIn.getBeamPct() > 0.0f) {
                matrixStackIn.m_85836_();
                Vec3 start = entityIn.m_20182_().m_82549_(new Vec3(-2.25, -3.2, 0.0));
                Vec3 end = entityIn.m_20182_().m_82520_(0.0, -5.0, 0.0);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-angleDegrees));
                matrixStackIn.m_252880_(-2.25f, -3.2f, 0.0f);
                WorldRenderUtils.renderBeam(entityIn.m_9236_(), partialTicks, matrixStackIn, bufferIn, packedLightIn, start, end, entityIn.getBeamPct(), new int[]{255, 255, 255}, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
                matrixStackIn.m_85849_();
            }
            angleDegrees += 360.0f / (float)numWizards;
        }
        if (entityIn.getCenterPct() > 0.0f) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, -5.0f, 0.0f);
            WorldRenderUtils.renderRadiant((Entity)entityIn, matrixStackIn, bufferIn, new int[]{151, 25, 151}, new int[]{77, 133, 207}, (int)Math.floor(entityIn.getCenterPct() * 255.0f), 0.15f);
            matrixStackIn.m_85849_();
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected boolean shouldShowName(AncientCouncil entity) {
        return false;
    }
}

