/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.faction;

import com.mna.entities.faction.util.FactionRaid;
import com.mna.factions.Factions;
import com.mna.tools.render.MARenderTypes;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class FactionRaidRenderer
extends EntityRenderer<FactionRaid> {
    private static final int[] white = new int[]{255, 255, 255};
    private static final int[] green = new int[]{0, 204, 0};
    private static final int[] blue = new int[]{102, 0, 255};

    public FactionRaidRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(FactionRaid entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entityIn.getFaction() == Factions.COUNCIL) {
            this.RenderPortal(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else if (entityIn.getFaction() == Factions.FEY) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, 1.0f, 0.0f);
            WorldRenderUtils.renderRadiant(entityIn, matrixStackIn, bufferIn, green, blue, 128, 0.5f);
            matrixStackIn.m_85849_();
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void RenderPortal(FactionRaid entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Quaternionf cameraRotation = this.f_114476_.m_253208_();
        Quaternionf portalRotation = new Quaternionf(0.0f, cameraRotation.y(), 0.0f, cameraRotation.w());
        float spawnPct = (float)Math.min(entityIn.f_19797_, 20) / 20.0f;
        float scaleFactor = 4.0f * spawnPct;
        float portalSpinDegrees = entityIn.f_19797_ * 3 % 360;
        float verticalOffset = 1.0f;
        int[] colors = white;
        VertexConsumer vertexBuilder = bufferIn.m_6299_(MARenderTypes.RAID_PORTAL_RENDER);
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.0f, verticalOffset, 0.0f);
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        matrixStackIn.m_252781_(portalRotation);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(portalSpinDegrees));
        matrixStackIn.m_252880_(0.0f, -0.25f, 0.0f);
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f renderMatrix = matrixstack$entry.m_252922_();
        Matrix3f normalMatrix = matrixstack$entry.m_252943_();
        float nrmV = (float)Math.cos((double)portalSpinDegrees * Math.PI / 180.0);
        float nrmH = (float)Math.cos((double)(portalSpinDegrees - 90.0f) * Math.PI / 180.0);
        int frame = entityIn.f_19797_ % 25;
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.04f * (float)frame;
        float maxV = minV + 0.04f;
        FactionRaidRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, minU, maxV, nrmH, nrmV, colors);
        FactionRaidRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, maxU, maxV, nrmH, nrmV, colors);
        FactionRaidRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, maxU, minV, nrmH, nrmV, colors);
        FactionRaidRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, minU, minV, nrmH, nrmV, colors);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.0f, verticalOffset, 0.0f);
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        matrixStackIn.m_252781_(portalRotation);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-portalSpinDegrees));
        matrixStackIn.m_252880_(0.0f, -0.25f, 0.001f);
        matrixstack$entry = matrixStackIn.m_85850_();
        renderMatrix = matrixstack$entry.m_252922_();
        normalMatrix = matrixstack$entry.m_252943_();
        nrmH = (float)Math.cos((double)(portalSpinDegrees + 90.0f) * Math.PI / 180.0);
        FactionRaidRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, minU, maxV, nrmH, nrmV, colors);
        FactionRaidRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, maxU, maxV, nrmH, nrmV, colors);
        FactionRaidRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, maxU, minV, nrmH, nrmV, colors);
        FactionRaidRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, minU, minV, nrmH, nrmV, colors);
        matrixStackIn.m_85849_();
    }

    private static void addVertex(VertexConsumer vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV, int[] rgb) {
        vertexBuilder_.m_252986_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], 230).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nrmH, nrmV, nrmH).m_5752_();
    }

    public ResourceLocation getTextureLocation(FactionRaid entity) {
        return MARenderTypes.PORTAL_TEXTURE_RAID;
    }
}

