/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.projectile;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.entities.EntityInit;
import com.mna.tools.TeleportHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class SentryProjectile
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Byte> AFFINITY = SynchedEntityData.m_135353_(SentryProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int ticksInAir;
    private Entity owner;

    public SentryProjectile(EntityType<? extends SentryProjectile> type, Level world) {
        super((EntityType)EntityInit.SENTRY_PROJECTILE.get(), world);
        this.m_20242_(true);
    }

    public SentryProjectile(Level worldIn, double x, double y, double z, Affinity affinity) {
        super((EntityType)EntityInit.SENTRY_PROJECTILE.get(), worldIn);
        this.m_6034_(x, y, z);
        this.setAffinity(affinity);
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        Entity entity = p_213868_1_.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            this.entityHit(livingentity);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void entityHit(LivingEntity living) {
        if (!this.m_9236_().m_5776_()) {
            switch (this.getAffinity()) {
                case EARTH: {
                    living.m_6469_(living.m_269291_().m_269264_(), 5.0f);
                    break;
                }
                case ENDER: {
                    this.teleportBackwards(living);
                    break;
                }
                case FIRE: 
                case HELLFIRE: 
                case LIGHTNING: {
                    living.m_6469_(living.m_269291_().m_269387_(), 5.0f);
                    living.m_20254_(3);
                    break;
                }
                case WATER: 
                case ICE: {
                    living.m_6469_(living.m_269291_().m_269425_(), 5.0f);
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 3, false, false, true));
                    break;
                }
                case WIND: {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 60, 0, false, false, true));
                    break;
                }
                default: {
                    living.m_6469_(living.m_269291_().m_269425_(), 15.0f);
                }
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void teleportBackwards(LivingEntity living) {
        Vec3 targetPos = TeleportHelper.calculateBlinkPosition(10.0, living, this.m_20184_(), this.m_9236_());
        if (targetPos != null) {
            TeleportHelper.teleportEntity((Entity)living, (ResourceKey<Level>)this.m_9236_().m_46472_(), targetPos);
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 Vector3d = new Vec3(x, y, z).m_82541_().m_82490_((double)velocity);
        this.m_20256_(Vector3d);
        double f = Vector3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)Vector3d.f_82479_, (double)Vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)Vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), p_213871_1_ -> !p_213871_1_.m_5833_() && p_213871_1_.m_6084_() && p_213871_1_.m_6087_() && (p_213871_1_ != this.getShooter() || this.ticksInAir >= 5));
    }

    public void m_8119_() {
        Vec3 Vector3d = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = Vector3d.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)Vector3d.f_82479_, (double)Vector3d.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)Vector3d.f_82480_, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        ++this.ticksInAir;
        Vec3 Vector3d2 = this.m_20182_();
        Vec3 Vector3d3 = Vector3d2.m_82549_(Vector3d);
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(Vector3d2, Vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            Vector3d3 = raytraceresult.m_82450_();
        }
        while (this.m_6084_()) {
            EntityHitResult entityraytraceresult = this.rayTraceEntities(Vector3d2, Vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                Entity entity1 = this.getShooter();
                if (entity != null && entity1 != null && entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_((HitResult)raytraceresult);
                this.f_19812_ = true;
            }
            if (entityraytraceresult == null) break;
            raytraceresult = null;
        }
        Vector3d = this.m_20184_();
        double d3 = Vector3d.f_82479_;
        double d4 = Vector3d.f_82480_;
        double d0 = Vector3d.f_82481_;
        double d5 = this.m_20185_() + d3;
        double d1 = this.m_20186_() + d4;
        double d2 = this.m_20189_() + d0;
        double f1 = Vector3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d0) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)d4, (double)f1) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
        float f2 = 0.99f;
        if (this.m_20069_()) {
            for (int j = 0; j < 4; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
            f2 = this.getWaterDrag();
        }
        this.m_20256_(Vector3d.m_82490_((double)f2));
        this.m_6034_(d5, d1, d2);
        this.m_20101_();
        if (this.f_19797_ > 200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        HitResult.Type raytraceresult$type = raytraceResultIn.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)raytraceResultIn);
        }
    }

    private Affinity getAffinity() {
        try {
            return Affinity.values()[(Byte)this.f_19804_.m_135370_(AFFINITY)];
        }
        catch (Throwable t) {
            return Affinity.UNKNOWN;
        }
    }

    private void setAffinity(Affinity affinity) {
        this.f_19804_.m_135381_(AFFINITY, (Object)((byte)affinity.ordinal()));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(AFFINITY, (Object)((byte)Affinity.ARCANE.ordinal()));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("affinity", this.getAffinity().ordinal());
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("affinity")) {
            try {
                this.setAffinity(Affinity.values()[compound.m_128451_("affinity")]);
            }
            catch (Throwable t) {
                this.setAffinity(Affinity.UNKNOWN);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = Mth.m_14116_((float)((float)(x * x + z * z)));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.2957763671875));
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 256.0 * SentryProjectile.m_20150_()) * d0;
    }

    public void spawnParticles(int particleCount, float partialTick) {
        Vec3 basePos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)partialTick));
        float particle_spread = 0.05f;
        MAParticleType particle = null;
        switch (this.getAffinity()) {
            case EARTH: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get()));
                break;
            }
            case ENDER: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get()));
                break;
            }
            case FIRE: 
            case HELLFIRE: 
            case LIGHTNING: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get()));
                break;
            }
            case WATER: 
            case ICE: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())).setScale(0.03f);
                break;
            }
            case WIND: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.04f).setColor(30, 30, 30);
                break;
            }
            default: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get()));
            }
        }
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3(0.0, 0.0, 0.0);
            Vec3 pos = basePos.m_82549_(this.m_20184_().m_82490_(Math.random()));
            this.m_9236_().m_7106_((ParticleOptions)particle, pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public boolean m_6097_() {
        return false;
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.0f;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    @Nullable
    public Entity getShooter() {
        return this.owner;
    }

    public void m_5602_(@Nullable Entity entityIn) {
        this.owner = entityIn;
    }

    protected float getWaterDrag() {
        return 0.6f;
    }
}

