/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.models;

import com.mna.api.tools.RLoc;
import com.mna.entities.LivingUtilityEntity;
import com.mna.entities.models.ModelPositionData;
import com.mna.entities.rituals.AncientCouncil;
import com.mna.tools.math.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class AncientWizardModel<T extends AncientCouncil>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(RLoc.create("ancientwizardmodel"), "main");
    private final ModelPart main;
    private final ModelPart right_arm;
    private final ModelPart right_elbow;
    private final ModelPart left_arm;
    private final ModelPart left_elbow;
    private final ModelPart head;
    private static ModelPositionData neutral;
    private static ModelPositionData imbue_stage_1;
    private static ModelPositionData imbue_stage_2;
    private static ModelPositionData imbue_stage_3;
    private static HashMap<String, ModelPositionData> animationMap;

    public AncientWizardModel(ModelPart root) {
        this.main = root.m_171324_("main");
        this.right_arm = this.main.m_171324_("right_arm");
        this.left_arm = this.main.m_171324_("left_arm");
        this.head = this.main.m_171324_("head");
        this.right_elbow = this.right_arm.m_171324_("right_elbow");
        this.left_elbow = this.left_arm.m_171324_("left_elbow");
        this.initPoses();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition main = partdefinition.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(48, 22).m_171488_(-4.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 22).m_171488_(0.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_arm = main.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-4.0f, -0.025f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-24.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        right_arm.m_171599_("right_elbow", CubeListBuilder.m_171558_().m_171514_(48, 11).m_171488_(-2.0f, -1.025f, -1.95f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.95f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition left_arm = main.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(0.0f, -0.025f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-24.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        left_arm.m_171599_("left_elbow", CubeListBuilder.m_171558_().m_171514_(48, 11).m_171488_(-2.075f, -1.025f, -1.95f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.05f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        main.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -12.0f, -2.0f, 1.0f, 24.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(4.0f, -12.0f, -2.0f, 1.0f, 24.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(30, 0).m_171488_(-4.0f, -12.0f, 2.0f, 8.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(30, 0).m_171488_(-5.05f, -12.0f, -2.45f, 4.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(22, 0).m_171488_(-5.05f, 0.0f, -2.45f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(31, 13).m_171488_(-5.05f, 4.0f, -2.45f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(22, 0).m_171480_().m_171488_(1.95f, 0.0f, -2.45f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(31, 13).m_171480_().m_171488_(2.95f, 4.0f, -2.45f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(30, 0).m_171480_().m_171488_(0.95f, -12.0f, -2.45f, 4.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        main.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(40, 52).m_171488_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-4.0f, -6.95f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        main.m_171599_("gem", CubeListBuilder.m_171558_().m_171514_(15, 8).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(15, 12).m_171488_(-0.5f, -0.5f, -0.55f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-21.95f, (float)-1.675f, (float)0.0f, (float)0.0f, (float)0.7854f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private void initPoses() {
        animationMap = new HashMap();
        neutral = new ModelPositionData();
        neutral.addPositionDegrees(this.head);
        neutral.addPositionDegrees(this.right_arm);
        neutral.addPositionDegrees(this.right_elbow);
        neutral.addPositionDegrees(this.left_arm);
        neutral.addPositionDegrees(this.left_elbow);
        animationMap.put("neutral", neutral);
        imbue_stage_1 = new ModelPositionData();
        imbue_stage_1.addPositionDegrees(this.head, new Vector3(-30.0, 0.0, 0.0));
        imbue_stage_1.addPositionDegrees(this.right_arm, new Vector3(40.0, -45.0, 0.0));
        imbue_stage_1.addPositionDegrees(this.right_elbow, new Vector3(0.0, 0.0, 17.5));
        imbue_stage_1.addPositionDegrees(this.left_arm, new Vector3(40.0, 45.0, 0.0));
        imbue_stage_1.addPositionDegrees(this.left_elbow, new Vector3(0.0, 0.0, -17.5));
        animationMap.put("imbue_stage_1", imbue_stage_1);
        imbue_stage_2 = new ModelPositionData();
        imbue_stage_2.addPositionDegrees(this.head, new Vector3(30.0, 0.0, 0.0));
        imbue_stage_2.addPositionDegrees(this.right_arm, new Vector3(135.0, 5.0, 44.0));
        imbue_stage_2.addPositionDegrees(this.right_elbow, new Vector3(0.0, 0.0, 35.0));
        imbue_stage_2.addPositionDegrees(this.left_arm, new Vector3(125.0, -5.0, -44.0));
        imbue_stage_2.addPositionDegrees(this.left_elbow, new Vector3(0.0, 0.0, -35.0));
        animationMap.put("imbue_stage_2", imbue_stage_2);
        imbue_stage_3 = new ModelPositionData();
        imbue_stage_3.addPositionDegrees(this.head, new Vector3(30.0, 0.0, 0.0));
        imbue_stage_3.addPositionDegrees(this.right_arm, new Vector3(95.0, 47.0, 80.0));
        imbue_stage_3.addPositionDegrees(this.right_elbow, new Vector3(0.0, 0.0, 15.0));
        imbue_stage_3.addPositionDegrees(this.left_arm, new Vector3(95.0, -47.0, -80.0));
        imbue_stage_3.addPositionDegrees(this.left_elbow, new Vector3(0.0, 0.0, -15.0));
        animationMap.put("imbue_stage_3", imbue_stage_3);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int lastChange = ((LivingUtilityEntity)((Object)entity)).getLastAnimChangeTimer();
        if (lastChange == 0) {
            animationMap.forEach((s, d) -> d.startLerp());
        } else {
            if (lastChange <= 20) {
                float neutral_return_timer = (float)lastChange / 20.0f;
                neutral.lerpRotations(neutral_return_timer);
            }
            float anim_pct = ((LivingUtilityEntity)((Object)entity)).getAnimationPct(0.0f);
            String current_anim = ((LivingUtilityEntity)((Object)entity)).getCurrentAnimation();
            if (animationMap.containsKey(current_anim)) {
                animationMap.get(current_anim).lerpRotations(anim_pct);
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.main.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

