/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.effects.EffectInit;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.faction.base.BaseFactionMob;
import com.mna.entities.faction.util.WitchHunterArrow;
import com.mna.entities.projectile.WitchhunterTrickshot;
import com.mna.entities.sorcery.base.ChanneledSpellEntity;
import com.mna.entities.sorcery.targeting.Smite;
import com.mna.entities.sorcery.targeting.SpellProjectile;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.math.MathUtils;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class WitchHunter
extends BaseFactionMob<WitchHunter>
implements RangedAttackMob,
AnimationController.CustomKeyframeHandler<WitchHunter> {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_TRICKSHOT = "trickshot";
    private static final String INSTRUCTION_SMASH = "potionSmash";
    private static final String INSTRUCTION_RESET_ATTACK = "reset_attack";
    private static final String INSTRUCTION_RESET_ROLL = "reset_roll";
    private static final String INSTRUCTION_POTION_COOLDOWN = "potion_cooldown";
    private static final int TRICKSHOT_CD = 200;
    private static final int ROLL_CD = 60;
    private boolean isAttacking = false;
    private boolean isTrickshotting = false;
    private boolean isPotionSmashing = false;
    private boolean isRolling = false;
    private int trickshotCooldown = 0;
    private HashMap<String, Integer> trickshotCooldowns = new HashMap();
    private int rollCooldown = 0;
    private boolean instantTransition = false;
    private int nextTrickshotDuration = 200;
    private int nextTrickshotMagnitude = 200;
    private MobEffect nextTrickshotEffect = null;

    public WitchHunter(EntityType<WitchHunter> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        for (String e : this.trickshotCooldowns.keySet()) {
            this.trickshotCooldowns.put(e, this.trickshotCooldowns.get(e) - 1);
        }
        --this.trickshotCooldown;
        --this.rollCooldown;
    }

    @Override
    public IFaction getFaction() {
        return Factions.COUNCIL;
    }

    @Override
    protected void addControllerListeners(AnimationController<WitchHunter> controller) {
        controller.setCustomInstructionKeyframeHandler((AnimationController.CustomKeyframeHandler)this);
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFactionMob<?>> state) {
        if (this.instantTransition) {
            state.getController().transitionLength(0);
            this.instantTransition = false;
        } else {
            state.getController().transitionLength(5);
        }
        if (!this.isAttacking) {
            double generalMoveSpeed = this.m_20184_().m_82492_(0.0, this.m_20184_().f_82480_, 0.0).m_82553_();
            if (generalMoveSpeed > (double)0.01f) {
                double moveAngle = Math.atan2(this.m_20184_().f_82481_, this.m_20184_().f_82479_) * 180.0 / Math.PI;
                double lookAngle = Math.atan2(this.m_20156_().f_82481_, this.m_20156_().f_82479_) * 180.0 / Math.PI;
                double angleDelta = Math.abs(lookAngle - moveAngle);
                state.getController().transitionLength(10);
                if (angleDelta > 45.0 && angleDelta < 135.0) {
                    return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.strafe"));
                }
                if (angleDelta >= 155.0) {
                    return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.backpedal"));
                }
                if (generalMoveSpeed < (double)0.1f && generalMoveSpeed > 0.01) {
                    return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.walk"));
                }
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.run"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.idle"));
        }
        if (this.isTrickshotting) {
            if (this.isPotionSmashing) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.throw_short").thenLoop("animation.model.idle"));
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.throw").thenLoop("animation.model.idle"));
        }
        if (this.isRolling) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.roll_short").thenLoop("animation.model.idle"));
        }
        return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.shoot"));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new DodgeGoal());
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(2, this, new TrickshotGoal((MobEffect)EffectInit.SILENCE.get(), 100, 0)));
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(1, this, new TrickshotGoal(MobEffects.f_19602_, 1, 2, true)));
        this.f_21345_.m_25352_(2, (Goal)new FactionTierWrapperGoal(0, this, new TrickshotGoal(MobEffects.f_19597_, 240, 3, true)));
        this.f_21345_.m_25352_(2, (Goal)new FactionTierWrapperGoal(0, this, new TrickshotGoal(MobEffects.f_19613_, 240, 3, true)));
        this.f_21345_.m_25352_(2, (Goal)new FactionTierWrapperGoal(0, this, new TrickshotGoal(MobEffects.f_19619_, 160, 3)));
        this.f_21345_.m_25352_(3, (Goal)new FactionTierWrapperGoal(1, this, new TrickshotGoal((MobEffect)EffectInit.INSTANT_CHILL.get(), 1, 1)));
        this.f_21345_.m_25352_(3, (Goal)new FactionTierWrapperGoal(1, this, new TrickshotGoal((MobEffect)EffectInit.MANA_STUNT.get(), 400, 4)));
        this.f_21345_.m_25352_(4, (Goal)new ShootGoal(1.2f, 40, 80, 12.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, 10, true, false, e -> true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.isAttacking) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_DAMAGE, 10, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>(INSTRUCTION_RESET_ATTACK, 30, "", this::handleDelayCallback));
        this.isAttacking = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean spawnBolt(Entity target) {
        Vec3 fwd = this.m_20156_();
        WitchHunterArrow arrow = new WitchHunterArrow(this.m_9236_(), this.m_20185_() + fwd.f_82479_, this.m_20188_() + fwd.f_82480_, this.m_20189_() + fwd.f_82481_);
        arrow.m_5602_((Entity)this);
        arrow.m_36762_(target.m_142038_());
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.0f);
        this.m_9236_().m_7967_((Entity)arrow);
        this.m_5496_(SoundEvents.f_11847_, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    Vector3f getProjectileShotVector(LivingEntity pUser, Vec3 pVectorTowardsTarget, float pProjectileAngle) {
        Vector3f vector3f = pVectorTowardsTarget.m_252839_().normalize();
        Vector3f vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f1.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = pUser.m_20289_(1.0f);
            vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.m_252839_());
        }
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f1.x, vector3f1.y, vector3f1.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(pProjectileAngle * ((float)Math.PI / 180), vector3f2.x, vector3f2.y, vector3f2.z);
    }

    public void spawnTrickshot(MobEffect effect, int duration, int magnitude, boolean smash) {
        if (this.m_5448_() == null) {
            return;
        }
        WitchhunterTrickshot trick = new WitchhunterTrickshot(this, this.m_20182_().m_82520_(0.0, 1.0, 0.0), smash ? this.m_5448_().m_20182_() : this.m_5448_().m_20182_().m_82520_(0.0, 3.0, 0.0), effect, duration, magnitude, smash);
        this.m_9236_().m_7967_((Entity)trick);
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 20.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    private void handleDelayCallback(String identifier, LivingEntity entity) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            switch (identifier) {
                case "damage": {
                    this.spawnBolt((Entity)entity);
                    break;
                }
                case "trickshot": {
                    this.spawnTrickshot(this.nextTrickshotEffect, this.nextTrickshotDuration, this.nextTrickshotMagnitude, false);
                    break;
                }
                case "potionSmash": {
                    this.spawnTrickshot(this.nextTrickshotEffect, this.nextTrickshotDuration, this.nextTrickshotMagnitude, true);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            boolean wasRolling = this.isRolling;
            switch (identifier) {
                case "reset_attack": {
                    this.isAttacking = false;
                    break;
                }
                case "reset_roll": {
                    this.isRolling = false;
                    this.rollCooldown = 5;
                    break;
                }
                case "potion_cooldown": {
                    this.trickshotCooldowns.put(data, 600);
                    this.trickshotCooldown = this.isPotionSmashing ? 40 : 200;
                    this.isTrickshotting = false;
                    this.isPotionSmashing = false;
                }
            }
            boolean bl = this.isAttacking = this.isRolling || this.isTrickshotting;
            if (!this.isRolling && wasRolling) {
                this.instantTransition = true;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public void handle(CustomInstructionKeyframeEvent<WitchHunter> event) {
        if (event.getKeyframeData().getInstructions().contains("sound:woosh")) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Entity.Generic.WOOSH, SoundSource.HOSTILE, 0.05f, (float)(0.9 + Math.random() * 0.2), false);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isAttacking);
        nbt.m_128379_(INSTRUCTION_TRICKSHOT, this.isTrickshotting);
        nbt.m_128379_("smash", this.isPotionSmashing);
        nbt.m_128379_("roll", this.isRolling);
        nbt.m_128379_("instant", this.instantTransition);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        this.isAttacking = nbt.m_128471_("attacking");
        this.isTrickshotting = nbt.m_128471_(INSTRUCTION_TRICKSHOT);
        this.isPotionSmashing = nbt.m_128471_("smash");
        this.isRolling = nbt.m_128471_("roll");
        this.instantTransition = nbt.m_128471_("instant");
    }

    public class DodgeGoal
    extends Goal {
        private Vec3 dodgeDirection;
        private Entity dodgeEntity;

        public DodgeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            if (WitchHunter.this.rollCooldown > 0) {
                return false;
            }
            Vec3 rt_startVec = WitchHunter.this.m_20182_();
            Vec3 thisFwd = Vec3.m_82503_((Vec2)WitchHunter.this.m_20155_());
            Vec3 rt_endVec = rt_startVec.m_82549_(thisFwd.m_82490_(10.0));
            List potentials = WitchHunter.this.m_9236_().m_45933_((Entity)WitchHunter.this, WitchHunter.this.m_20191_().m_82400_(10.0)).stream().filter(e -> e instanceof SpellProjectile || e instanceof Smite || e instanceof ChanneledSpellEntity).filter(e -> {
                AABB axisalignedbb = e.m_20191_().m_82400_(2.0);
                Optional optional = axisalignedbb.m_82371_(rt_startVec, rt_endVec);
                return optional.isPresent();
            }).collect(Collectors.toList());
            if (potentials.size() == 0) {
                return false;
            }
            potentials.sort(new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    Double d1 = o1.m_20280_((Entity)WitchHunter.this);
                    Double d2 = o2.m_20280_((Entity)WitchHunter.this);
                    return d1.compareTo(d2);
                }
            });
            this.dodgeEntity = (Entity)potentials.get(0);
            Vec3 fwd = this.dodgeEntity.m_20184_();
            this.dodgeDirection = new Vec3(fwd.f_82479_, 0.0, fwd.f_82481_).m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            float angle = (float)(Math.acos(this.dodgeDirection.m_82526_(thisFwd.m_82541_())) * 180.0 / Math.PI);
            if (angle > 90.0f) {
                this.dodgeDirection.m_82490_(-1.0);
            }
            return true;
        }

        public void m_8056_() {
            WitchHunter.this.m_21573_().m_26573_();
            WitchHunter.this.isRolling = true;
            WitchHunter.this.isAttacking = true;
            WitchHunter.this.m_21563_().m_24950_(this.dodgeDirection.f_82479_, this.dodgeDirection.f_82480_, this.dodgeDirection.f_82481_, 30.0f, 30.0f);
            WitchHunter.this.m_20256_(this.dodgeDirection);
            DelayedEventQueue.pushEvent(WitchHunter.this.m_9236_(), new TimedDelayedEvent<String>(WitchHunter.INSTRUCTION_RESET_ROLL, 60, "", WitchHunter.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(WitchHunter.this);
        }

        public void m_8037_() {
            WitchHunter.this.m_21563_().m_24950_(this.dodgeDirection.f_82479_, this.dodgeDirection.f_82480_, this.dodgeDirection.f_82481_, 30.0f, 30.0f);
        }

        public boolean m_8045_() {
            return WitchHunter.this.isRolling;
        }

        protected EntityHitResult rayTraceEntity(Vec3 startVec, Vec3 endVec, float size, Entity searchEntity) {
            return ProjectileUtil.m_37304_((Level)WitchHunter.this.m_9236_(), (Entity)WitchHunter.this, (Vec3)startVec, (Vec3)endVec, (AABB)WitchHunter.this.m_20191_().m_82400_((double)size), entity -> searchEntity == entity);
        }
    }

    public class TrickshotGoal
    extends Goal {
        private MobEffect potionEffect;
        private int potionDuration;
        private int potionMagnitude;
        private static final float shortDistance = 25.0f;
        private static final float maxDistance = 256.0f;
        private boolean startedAction;
        private boolean closeRangeOnly = false;

        public TrickshotGoal(MobEffect effect, int duration, int magnitude) {
            this(effect, duration, magnitude, false);
        }

        public TrickshotGoal(MobEffect effect, int duration, int magnitude, boolean closeRangeOnly) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.potionEffect = effect;
            this.potionDuration = duration;
            this.potionMagnitude = magnitude;
            this.startedAction = false;
            this.closeRangeOnly = closeRangeOnly;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            boolean baseCheck;
            boolean bl = baseCheck = WitchHunter.this.trickshotCooldown <= 0 && WitchHunter.this.trickshotCooldowns.getOrDefault(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.potionEffect).toString(), 0) <= 0 && !WitchHunter.this.isTrickshotting && !WitchHunter.this.isRolling && WitchHunter.this.m_5448_() != null && !WitchHunter.this.m_5448_().m_21023_(this.potionEffect) && WitchHunter.this.m_5448_().m_7301_(new MobEffectInstance(this.potionEffect, this.potionDuration, this.potionMagnitude));
            if (baseCheck && this.potionEffect == MobEffects.f_19602_ && WitchHunter.this.m_5448_().m_6336_() == MobType.f_21641_) {
                return false;
            }
            if (baseCheck && (this.potionEffect == EffectInit.MANA_STUNT.get() || this.potionEffect == EffectInit.SILENCE.get()) && !(WitchHunter.this.m_5448_() instanceof Player)) {
                return false;
            }
            if (this.closeRangeOnly) {
                return baseCheck && WitchHunter.this.m_5448_().m_20280_((Entity)WitchHunter.this) < 25.0;
            }
            return baseCheck;
        }

        public void m_8056_() {
            this.startedAction = false;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity at = WitchHunter.this.m_5448_();
            if (at == null) {
                return;
            }
            if (!this.startedAction && !WitchHunter.this.isTrickshotting) {
                if (this.tryMove(at)) {
                    this.startAction();
                }
            } else {
                WitchHunter.this.m_21563_().m_24960_((Entity)at, 30.0f, 30.0f);
            }
        }

        private void startAction() {
            WitchHunter.this.m_21573_().m_26573_();
            LivingEntity target = WitchHunter.this.m_5448_();
            WitchHunter.this.isTrickshotting = true;
            WitchHunter.this.isPotionSmashing = WitchHunter.this.m_20280_((Entity)target) < 25.0;
            WitchHunter.this.isAttacking = true;
            WitchHunter.this.nextTrickshotDuration = this.potionDuration;
            WitchHunter.this.nextTrickshotMagnitude = this.potionMagnitude;
            WitchHunter.this.nextTrickshotEffect = this.potionEffect;
            String effectID = ForgeRegistries.MOB_EFFECTS.getKey((Object)this.potionEffect).toString();
            if (WitchHunter.this.isPotionSmashing) {
                DelayedEventQueue.pushEvent(WitchHunter.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(WitchHunter.INSTRUCTION_SMASH, 12, (LivingEntity)WitchHunter.this, WitchHunter.this::handleDelayCallback));
                DelayedEventQueue.pushEvent(WitchHunter.this.m_9236_(), new TimedDelayedEvent<String>(WitchHunter.INSTRUCTION_POTION_COOLDOWN, 40, effectID, WitchHunter.this::handleDelayCallback));
            } else {
                DelayedEventQueue.pushEvent(WitchHunter.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(WitchHunter.INSTRUCTION_TRICKSHOT, 46, (LivingEntity)WitchHunter.this, WitchHunter.this::handleDelayCallback));
                DelayedEventQueue.pushEvent(WitchHunter.this.m_9236_(), new TimedDelayedEvent<String>(WitchHunter.INSTRUCTION_POTION_COOLDOWN, 100, effectID, WitchHunter.this::handleDelayCallback));
            }
            ServerMessageDispatcher.sendEntityStateMessage(WitchHunter.this);
            this.startedAction = true;
        }

        private boolean tryMove(LivingEntity at) {
            double distance = WitchHunter.this.m_20275_(at.m_20185_(), at.m_20186_(), at.m_20189_());
            boolean canSeeTarget = WitchHunter.this.m_21574_().m_148306_((Entity)at);
            if (distance <= 256.0 && canSeeTarget) {
                WitchHunter.this.m_21573_().m_26573_();
                return true;
            }
            WitchHunter.this.m_21573_().m_5624_((Entity)at, 1.5);
            WitchHunter.this.m_21563_().m_24960_((Entity)at, 30.0f, 30.0f);
            return false;
        }

        public boolean m_8045_() {
            return WitchHunter.this.m_5448_() != null && !WitchHunter.this.m_5448_().m_21224_() && WitchHunter.this.trickshotCooldown <= 0 && (!this.startedAction || WitchHunter.this.isTrickshotting);
        }
    }

    public class ShootGoal
    extends Goal {
        private final double speedModifier;
        private int attackIntervalMin;
        private int attackIntervalMax;
        private final float attackRadiusSqr;
        private int attackTime = -1;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public ShootGoal(double pSpeedModifier, int pAttackIntervalMin, int attackIntervalMax, float pAttackRadius) {
            this.speedModifier = pSpeedModifier;
            this.attackIntervalMin = pAttackIntervalMin;
            this.attackIntervalMax = attackIntervalMax;
            this.attackRadiusSqr = pAttackRadius * pAttackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = WitchHunter.this.m_5448_();
            return livingentity != null && !livingentity.m_21224_();
        }

        public boolean m_8045_() {
            if (!this.m_8036_()) {
                return false;
            }
            return !WitchHunter.this.m_21573_().m_26571_();
        }

        public void m_8041_() {
            WitchHunter.this.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = WitchHunter.this.m_5448_();
            if (livingentity != null) {
                boolean needsToStandStill;
                double distance = WitchHunter.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean hasLineOfSight = WitchHunter.this.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = needsToStandStill = WitchHunter.this.isAttacking || WitchHunter.this.isTrickshotting || WitchHunter.this.isRolling;
                if (!needsToStandStill) {
                    if (distance <= (double)this.attackRadiusSqr && hasLineOfSight) {
                        WitchHunter.this.m_21573_().m_26573_();
                        ++this.strafingTime;
                    } else {
                        WitchHunter.this.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                        this.strafingTime = -1;
                    }
                    if (this.strafingTime >= 40) {
                        if ((double)WitchHunter.this.m_217043_().m_188501_() < 0.3) {
                            boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                        }
                        if ((double)WitchHunter.this.m_217043_().m_188501_() < 0.3) {
                            this.strafingBackwards = !this.strafingBackwards;
                        }
                        this.strafingTime = 0;
                    }
                    if (this.strafingTime > -1) {
                        if (distance > (double)(this.attackRadiusSqr * 0.75f)) {
                            this.strafingBackwards = false;
                        } else if (distance < (double)(this.attackRadiusSqr * 0.25f)) {
                            this.strafingBackwards = true;
                        }
                        WitchHunter.this.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                        Entity entity = WitchHunter.this.m_275832_();
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                        }
                    }
                } else {
                    WitchHunter.this.m_21573_().m_26573_();
                }
                WitchHunter.this.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                WitchHunter.this.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                int tier = MathUtils.clamp(WitchHunter.this.getTier() + 1, 1, 3);
                --this.attackTime;
                if (this.attackTime <= 0) {
                    if (!hasLineOfSight) {
                        return;
                    }
                    WitchHunter.this.m_6504_(livingentity, 0.0f);
                    this.attackTime = (this.attackIntervalMax - this.attackIntervalMin + this.attackIntervalMin) / tier;
                }
            }
        }
    }
}

