/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.movement;

import com.mna.entities.constructs.animated.Construct;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidType;

public class ConstructMoveControl
extends MoveControl {
    private final Construct construct;
    private final boolean applyGravity;
    private float inWaterSpeedModifier;
    private int maxTurnX;
    private float outsideWaterSpeedModifier;
    private float maxTurnY;

    public ConstructMoveControl(Construct construct, int pMaxTurnX, int pMaxTurnY, float pInWaterSpeedModifier, float pOutsideWaterSpeedModifier, boolean pApplyGravity) {
        super((Mob)construct);
        this.construct = construct;
        this.maxTurnX = pMaxTurnX;
        this.maxTurnY = pMaxTurnY;
        this.inWaterSpeedModifier = pInWaterSpeedModifier;
        this.outsideWaterSpeedModifier = pOutsideWaterSpeedModifier;
        this.applyGravity = pApplyGravity;
    }

    public void m_8126_() {
        if (this.construct.isInFluidType()) {
            FluidType fluidType = this.construct.getMaxHeightFluidType();
            if (fluidType != null && this.construct.canSwimInFluidType(fluidType)) {
                this.swimTick();
            } else {
                this.groundTick();
            }
        } else if (this.construct.canFly() && !this.construct.isDefeated()) {
            this.flyTick();
        } else {
            this.groundTick();
        }
    }

    private void groundTick() {
        if (this.f_24981_ == MoveControl.Operation.STRAFE) {
            float f8;
            float f = (float)this.f_24974_.m_21133_(Attributes.f_22279_);
            float f1 = (float)this.f_24978_ * f;
            float f2 = this.f_24979_;
            float f3 = this.f_24980_;
            float f4 = Mth.m_14116_((float)(f2 * f2 + f3 * f3));
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            f4 = f1 / f4;
            float f5 = Mth.m_14031_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
            float f6 = Mth.m_14089_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
            float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
            if (!this.m_24996_(f7, f8 = f3 * f6 + f2 * f5)) {
                this.f_24979_ = 1.0f;
                this.f_24980_ = 0.0f;
            }
            this.f_24974_.m_7910_(f1);
            this.f_24974_.m_21564_(this.f_24979_);
            this.f_24974_.m_21570_(this.f_24980_);
            this.f_24981_ = MoveControl.Operation.WAIT;
        } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            double d0 = this.f_24975_ - this.f_24974_.m_20185_();
            double d1 = this.f_24977_ - this.f_24974_.m_20189_();
            double d2 = this.f_24976_ - this.f_24974_.m_20186_();
            double d3 = d0 * d0 + d2 * d2 + d1 * d1;
            if (d3 < 2.500000277905201E-7) {
                this.f_24974_.m_21564_(0.0f);
                return;
            }
            float f9 = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f9, 90.0f));
            this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
            BlockPos blockpos = this.f_24974_.m_20183_();
            BlockState blockstate = this.f_24974_.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13035_)) {
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)this.f_24974_.m_9236_(), blockpos);
                if (d2 > (double)this.f_24974_.getStepHeight() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.f_24974_.m_20205_()) || !voxelshape.m_83281_() && this.f_24974_.m_20186_() < voxelshape.m_83297_(Direction.Axis.Y) + (double)blockpos.m_123342_() && !blockstate.m_204336_(BlockTags.f_13103_) && !blockstate.m_204336_(BlockTags.f_13039_)) {
                    this.f_24974_.m_21569_().m_24901_();
                    this.f_24981_ = MoveControl.Operation.JUMPING;
                }
            }
        } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
            this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
            if (this.f_24974_.m_20096_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
        } else {
            this.f_24974_.m_21564_(0.0f);
        }
    }

    private void swimTick() {
        if (this.applyGravity && this.f_24974_.m_20069_()) {
            this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.005, 0.0));
        }
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
            double d2;
            double d1;
            double d0 = this.f_24975_ - this.f_24974_.m_20185_();
            double d3 = d0 * d0 + (d1 = this.f_24976_ - this.f_24974_.m_20186_()) * d1 + (d2 = this.f_24977_ - this.f_24974_.m_20189_()) * d2;
            if (d3 < 2.500000277905201E-7) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, this.maxTurnY));
                this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                if (this.f_24974_.m_20069_()) {
                    this.f_24974_.m_7910_(f1 * this.inWaterSpeedModifier);
                    double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                    if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                        float f3 = -((float)(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                        f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)(-this.maxTurnX), (float)this.maxTurnX);
                        this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f3, 5.0f));
                    }
                    float f6 = Mth.m_14089_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14031_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                    this.f_24974_.f_20902_ = f6 * f1;
                    this.f_24974_.f_20901_ = -f4 * f1;
                } else {
                    float f5 = Math.abs(Mth.m_14177_((float)(this.f_24974_.m_146908_() - f)));
                    float f2 = ConstructMoveControl.getTurningSpeedFactor(f5);
                    this.f_24974_.m_7910_(f1 * this.outsideWaterSpeedModifier * f2);
                }
            }
        } else {
            this.f_24974_.m_7910_(0.0f);
            this.f_24974_.m_21570_(0.0f);
            this.f_24974_.m_21567_(0.0f);
            this.f_24974_.m_21564_(0.0f);
        }
    }

    private void flyTick() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            this.f_24974_.m_20242_(true);
            double deltaX = this.f_24975_ - this.f_24974_.m_20185_();
            double deltaY = this.f_24976_ - this.f_24974_.m_20186_();
            double deltaZ = this.f_24977_ - this.f_24974_.m_20189_();
            double distSqr = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
            if (distSqr < 2.500000277905201E-7) {
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
                return;
            }
            float faceAngle = (float)(Mth.m_14136_((double)deltaZ, (double)deltaX) * 57.2957763671875) - 90.0f;
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), faceAngle, 90.0f));
            float mobSpeed = this.f_24974_.m_20096_() ? (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
            this.f_24974_.m_7910_(mobSpeed);
            double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            if (Math.abs(deltaY) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
                float f2 = (float)(-(Mth.m_14136_((double)deltaY, (double)horizontalDistance) * 57.2957763671875));
                this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f2, this.maxTurnX));
                this.f_24974_.m_21567_(deltaY > 0.0 ? mobSpeed : -mobSpeed);
            }
        } else {
            BlockPos cBPos = this.construct.m_20183_();
            if (this.construct.m_9236_().m_8055_(cBPos).m_60634_((BlockGetter)this.construct.m_9236_(), cBPos, (Entity)this.construct) || this.construct.m_9236_().m_8055_(cBPos.m_7495_()).m_60634_((BlockGetter)this.construct.m_9236_(), cBPos.m_7495_(), (Entity)this.construct)) {
                this.f_24974_.m_20242_(false);
            }
            this.f_24974_.m_21567_(0.0f);
            this.f_24974_.m_21564_(0.0f);
        }
    }

    private static float getTurningSpeedFactor(float p_249853_) {
        return 1.0f - Mth.m_14036_((float)((p_249853_ - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }

    private boolean m_24996_(float pRelativeX, float pRelativeZ) {
        NodeEvaluator nodeevaluator;
        PathNavigation pathnavigation = this.f_24974_.m_21573_();
        return pathnavigation == null || (nodeevaluator = pathnavigation.m_26575_()) == null || nodeevaluator.m_8086_((BlockGetter)this.f_24974_.m_9236_(), Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)pRelativeX)), this.f_24974_.m_146904_(), Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)pRelativeZ))) == BlockPathTypes.WALKABLE;
    }
}

