/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai.conditionals;

import com.mna.Registries;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskAreaParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskItemStackParameter;
import com.mna.api.items.IPhylacteryItem;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.entities.constructs.ai.conditionals.ConstructConditional;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class ConstructIsEntityInArea
extends ConstructConditional<ConstructIsEntityInArea> {
    private ItemStack phylactery = ItemStack.f_41583_;
    private AABB area;

    public ConstructIsEntityInArea(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
    }

    @Override
    protected boolean evaluate() {
        if (!(this.phylactery.m_41720_() instanceof IPhylacteryItem)) {
            return false;
        }
        EntityType<? extends Mob> type = ((IPhylacteryItem)this.phylactery.m_41720_()).getContainedEntity(this.phylactery);
        if (type == null) {
            return false;
        }
        if (this.construct.asEntity().m_9236_().m_6249_((Entity)this.construct.asEntity(), this.area, e -> e.m_6095_() == type && e.m_6084_() && e.m_6087_()).size() > 0) {
            this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.SUCCESS, this.area);
            return true;
        }
        this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.FAILURE, this.area);
        return false;
    }

    @Override
    public void inflateParameters() {
        this.getParameter("find_entity.filter").ifPresent(param -> {
            if (param instanceof ConstructTaskItemStackParameter) {
                this.phylactery = ((ConstructTaskItemStackParameter)param).getStack();
            }
        });
        this.getParameter("find_entity.area").ifPresent(param -> {
            if (param instanceof ConstructTaskAreaParameter) {
                this.area = ((ConstructTaskAreaParameter)param).getArea();
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        ArrayList<ConstructAITaskParameter> output = new ArrayList<ConstructAITaskParameter>();
        output.add(new ConstructTaskItemStackParameter("find_entity.filter"));
        output.add(new ConstructTaskAreaParameter("find_entity.area"));
        return output;
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.Conditions.FIND_ENTITY);
    }

    @Override
    public ConstructIsEntityInArea copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructIsEntityInArea) {
            this.phylactery = ((ConstructIsEntityInArea)other).phylactery.m_41777_();
            this.area = ((ConstructIsEntityInArea)other).area;
        }
        return this;
    }

    @Override
    public ConstructIsEntityInArea duplicate() {
        ConstructIsEntityInArea output = new ConstructIsEntityInArea(this.construct, this.guiIcon);
        output.copyFrom((ConstructAITask)this);
        return output;
    }

    @Override
    public boolean isFullyConfigured() {
        if (this.phylactery.m_41619_()) {
            return false;
        }
        if (!(this.phylactery.m_41720_() instanceof IPhylacteryItem)) {
            return false;
        }
        if (this.area == null) {
            return false;
        }
        return ((IPhylacteryItem)this.phylactery.m_41720_()).getContainedEntity(this.phylactery) != null;
    }
}

