/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskPointParameter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ConstructDropItem
extends ConstructAITask<ConstructDropItem> {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private int interactTimer = 20;
    protected BlockPos blockPos;

    public ConstructDropItem(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && this.blockPos != null;
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() && this.m_8036_();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        AbstractGolem c = this.getConstructAsEntity();
        if (this.construct.getCarryingHands().length == 0) {
            if (!this.isSuccess()) {
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.drop_item_hands_empty", new Object[0]));
            }
            return;
        }
        this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.RUNNING, Vec3.m_82512_((Vec3i)this.blockPos));
        this.setMoveTarget(this.blockPos);
        if (this.doMove()) {
            InteractionHand[] carrying = this.construct.getCarryingHands();
            if (this.interactTimer > 0) {
                if (this.interactTimer == 5 && carrying.length > 0) {
                    c.m_6674_(carrying[0]);
                }
                --this.interactTimer;
            } else if (this.interactTimer == 0) {
                if (carrying.length == 0) {
                    this.exitCode = 1;
                    return;
                }
                String itemTranslated = "";
                InteractionHand hand = carrying[0];
                ItemStack stack = c.m_21120_(hand);
                ItemEntity item = new ItemEntity(c.m_9236_(), (double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5, stack.m_41777_());
                item.m_20334_(0.0, 0.25, 0.0);
                item.m_32060_();
                c.m_9236_().m_7967_((Entity)item);
                c.m_21008_(hand, ItemStack.f_41583_);
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.drop_item_success", itemTranslated, this.blockPos.m_123341_(), this.blockPos.m_123342_(), this.blockPos.m_123343_()));
                this.exitCode = 0;
            }
        }
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.interactTimer = 20;
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.DROP_ITEM);
    }

    @Override
    public ConstructDropItem duplicate() {
        return new ConstructDropItem(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public ConstructDropItem copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructDropItem) {
            this.blockPos = ((ConstructDropItem)other).blockPos;
        }
        return this;
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        if (this.blockPos != null) {
            nbt.m_128365_("blockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("blockPos")) {
            this.blockPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("blockPos"));
        }
    }

    @Override
    public void inflateParameters() {
        this.getParameter("drop.point").ifPresent(param -> {
            if (param instanceof ConstructTaskPointParameter) {
                this.blockPos = ((ConstructTaskPointParameter)param).getPosition();
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskPointParameter("drop.point"));
        return parameters;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null;
    }
}

