/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.ConstructCommandTileEntityInteract;
import com.mna.api.entities.construct.ai.IMutexManager;
import com.mna.blocks.tileentities.LodestarTile;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ConstructCommandFollowLodestar
extends ConstructCommandTileEntityInteract<LodestarTile, ConstructCommandFollowLodestar> {
    private String curTaskId;
    private int taskCount = 0;
    private ConstructAITask<?> _current;
    private int waitTime = 0;

    public ConstructCommandFollowLodestar(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon, LodestarTile.class);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (--this.waitTime > 0) {
            return;
        }
        try {
            this.currentCommand().ifPresent(task -> {
                if (!task.isFinished()) {
                    task.m_8037_();
                }
            });
        }
        catch (Exception ex) {
            ManaAndArtifice.LOGGER.error("Error executing lodestar sub task, trying to recover.");
            ManaAndArtifice.LOGGER.catching((Throwable)ex);
        }
    }

    @Override
    public boolean m_8036_() {
        int power = this.construct.asEntity().m_9236_().m_277086_(this.blockPos);
        if (super.m_8036_() && power < 15) {
            MutableBoolean subCanUse = new MutableBoolean(false);
            if (this._current == null) {
                this.advanceTask(false);
            }
            this.currentCommand().ifPresent(task -> {
                if (!task.areCapabilitiesMet()) {
                    task.confuseConstructCapsMissing();
                    task.forceFail();
                    this.advanceTask(true);
                    subCanUse.setFalse();
                    return;
                }
                if (this.construct.getIntelligence() < task.getRequiredIntelligence()) {
                    task.confuseConstructLowIntelligence();
                    task.forceFail();
                    this.advanceTask(true);
                    subCanUse.setFalse();
                    return;
                }
                if (!task.isFullyConfigured()) {
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.task_not_configured", this.translate(task.getType().toString(), new Object[0])));
                    task.forceFail();
                    this.advanceTask(true);
                    subCanUse.setFalse();
                    return;
                }
                if (task.isFinished()) {
                    this.advanceTask(false);
                    subCanUse.setFalse();
                    return;
                }
                if (!task.m_8036_()) {
                    subCanUse.setFalse();
                    task.forceFail();
                    this.advanceTask(true);
                } else {
                    subCanUse.setTrue();
                }
            });
            return subCanUse.booleanValue();
        }
        return false;
    }

    private boolean advanceTask(boolean force) {
        MutableBoolean advanced = new MutableBoolean(false);
        this.currentCommand().ifPresent(task -> {
            if (task.isFinished() || force) {
                task.m_8041_();
                this.curTaskId = task.getNextTask();
                if (this.curTaskId == null) {
                    this.reset();
                }
            } else if (!task.hasStarted()) {
                this.construct.setCurrentCommand(this.owner, (ConstructAITask<?>)((Object)task));
                task.m_8056_();
            }
        });
        Optional<ConstructAITask<?>> resolved = ((LodestarTile)this.getTileEntity()).getCommand(this.curTaskId);
        if (resolved.isPresent()) {
            ++this.taskCount;
            if (this.taskCount > this.construct.getIntelligence()) {
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.confused", new Object[0]));
                this.construct.setConfused(100);
                this.reset();
            } else {
                this._current = resolved.get().duplicate();
                this._current.setConstruct(this.construct);
                this._current.setMutexManager((IMutexManager)this.getTileEntity());
                this._current.copyConnections(resolved.get());
                this._current.onTaskSet();
                this._current.m_8056_();
                this.curTaskId = resolved.get().getId();
                advanced.setTrue();
            }
        } else {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.task_not_found", new Object[0]));
            this.reset();
        }
        int power = this.construct.asEntity().m_9236_().m_277086_(this.blockPos);
        if (power > 0 && power < 15) {
            this.waitTime = 2 * power;
        }
        return advanced.booleanValue();
    }

    private void reset() {
        this.taskCount = 0;
        this.curTaskId = null;
        this._current = null;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        if (this.getTileEntity() == null) {
            return;
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.currentCommand().ifPresent(task -> task.m_8041_());
        this.releaseMutexes();
    }

    @Override
    public boolean m_8045_() {
        if (this.getTileEntity() == null || this.construct.asEntity().m_9236_().m_276867_(this.blockPos)) {
            return false;
        }
        MutableBoolean subCanContinue = new MutableBoolean(false);
        try {
            this.currentCommand().ifPresent(task -> subCanContinue.setValue(task.m_8045_()));
        }
        catch (Exception ex) {
            ManaAndArtifice.LOGGER.error("Error executing lodestar sub task, trying to recover.");
            ManaAndArtifice.LOGGER.error((Object)ex);
        }
        return subCanContinue.booleanValue();
    }

    public Optional<ConstructAITask<?>> currentCommand() {
        return Optional.ofNullable(this._current);
    }

    @Override
    public void inflateParameters() {
        super.inflateParameters();
        this.curTaskId = null;
    }

    @Override
    public ConstructCommandFollowLodestar duplicate() {
        return new ConstructCommandFollowLodestar(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructCommandFollowLodestar copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructCommandFollowLodestar) {
            this.curTaskId = ((ConstructCommandFollowLodestar)other).curTaskId;
            this.taskCount = ((ConstructCommandFollowLodestar)other).taskCount;
        }
        super.copyFrom((ConstructAITask)other);
        return this;
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.LODESTAR);
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        super.readNBT(nbt);
        if (nbt.m_128441_("curTaskId")) {
            this.curTaskId = nbt.m_128461_("curTaskId");
        }
        if (nbt.m_128441_("taskCount")) {
            this.taskCount = nbt.m_128451_("taskCount");
        }
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        nbt = super.writeInternal(nbt);
        if (this.curTaskId != null) {
            nbt.m_128359_("curTaskId", this.curTaskId);
        }
        nbt.m_128405_("taskCount", this.taskCount);
        return nbt;
    }

    @Override
    public void releaseMutexes() {
        if (this._current != null) {
            this._current.releaseMutexes();
        }
    }
}

