/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.tools.RLoc;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.tools.math.MathUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ConstructAdventure
extends ConstructAITask<ConstructAdventure> {
    private static final ResourceLocation ADVENTURE_LOOT_OVERWORLD = RLoc.create("entities/construct/adventure_minecraft_overworld");
    private static final ConstructCapability[] required_capabilities = new ConstructCapability[]{ConstructCapability.CARRY};
    protected BlockPos blockPos;
    protected Vec3 targetLook;
    private static final int WANDER_DIST = 5;
    protected int waitCount = 0;
    protected boolean isWaiting = false;
    protected int waitTime = 100;

    public ConstructAdventure(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (!this.isWaiting) {
            this.setMoveTarget(this.blockPos);
            if (this.doMove()) {
                this.construct.setAdventuring(true);
                this.waitCount = 0;
                this.targetLook = this.construct.asEntity().m_20156_().m_82541_().m_82490_(-10.0);
                this.isWaiting = true;
            }
        } else {
            ++this.waitCount;
            if (this.waitCount > 40) {
                this.faceBlockPos(this.blockPos.m_7918_((int)this.targetLook.f_82479_, (int)this.targetLook.f_82480_, (int)this.targetLook.f_82481_));
            }
            if (this.waitCount >= this.getWaitTime()) {
                this.construct.resetActions();
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.adventure_success", new Object[0]));
                this.exitCode = 0;
                return;
            }
            if (this.waitCount == this.getWaitTime() - 30) {
                this.construct.setHappy(100);
                this.construct.setAdventuring(false);
                this.rollLoot();
            }
        }
    }

    @Override
    public void onTaskSet() {
        int count;
        super.onTaskSet();
        this.waitCount = 0;
        this.isWaiting = false;
        AbstractGolem c = this.getConstructAsEntity();
        int rX = (int)c.m_20208_(5.0);
        int rY = (int)c.m_20187_();
        int rZ = (int)c.m_20262_(5.0);
        this.blockPos = new BlockPos(rX, rY, rZ);
        BlockState state = c.m_9236_().m_8055_(this.blockPos);
        for (count = 0; !state.m_60795_() && count < 10; ++count) {
            this.blockPos = this.blockPos.m_7918_(0, 1, 0);
            state = c.m_9236_().m_8055_(this.blockPos);
        }
        for (count = 0; state.m_60795_() && count < 10; ++count) {
            this.blockPos = this.blockPos.m_7918_(0, -1, 0);
            state = c.m_9236_().m_8055_(this.blockPos);
        }
        InteractionHand[] hands = this.construct.getCarryingHands();
        for (int i = 0; i < hands.length; ++i) {
            ItemStack held = c.m_21120_(hands[i]);
            BlockPos dropPos = c.m_20183_();
            ItemEntity item = new ItemEntity(c.m_9236_(), (double)dropPos.m_123341_() + 0.5, (double)dropPos.m_123342_() + 0.5, (double)dropPos.m_123343_() + 0.5, held.m_41777_());
            item.m_20334_(0.0, 0.25, 0.0);
            item.m_32060_();
            c.m_9236_().m_7967_((Entity)item);
            c.m_21008_(hands[i], ItemStack.f_41583_);
        }
    }

    private void rollLoot() {
        int num_items = Math.max(this.construct.getEmptyHands().length, 1);
        if (this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.ITEM_STORAGE)) {
            num_items += 1 + MathUtils.weightedRandomNumber(15);
        }
        ServerLevel serverWorld = (ServerLevel)this.construct.asEntity().m_9236_();
        ResourceLocation lootTableId = RLoc.create("entities/construct/adventure_" + serverWorld.m_46472_().m_135782_().toString().replace(':', '_'));
        LootTable loottable = serverWorld.m_7654_().m_278653_().m_278676_(lootTableId);
        if (loottable == LootTable.f_79105_) {
            loottable = serverWorld.m_7654_().m_278653_().m_278676_(ADVENTURE_LOOT_OVERWORLD);
        }
        if (loottable == null) {
            return;
        }
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.construct.asEntity().m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this.construct.asEntity()).m_287286_(LootContextParams.f_81460_, (Object)this.construct.asEntity().m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)this.construct.asEntity().m_269291_().m_269264_()).m_287235_(LootContextParamSets.f_81415_);
        ObjectArrayList items = loottable.m_287195_(lootparams);
        for (int i = 0; i < Math.min(num_items, items.size()); ++i) {
            this.insertOrDropItem((ItemStack)items.get(i));
        }
    }

    private int getWaitTime() {
        if (!this.construct.getConstructData().areCapabilitiesEnabled(ConstructCapability.ITEM_STORAGE)) {
            return this.getInteractTime(ConstructCapability.ADVENTURE, 9600);
        }
        return this.getInteractTime(ConstructCapability.ADVENTURE, 4800);
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.ADVENTURE);
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
    }

    @Override
    public boolean isFullyConfigured() {
        return true;
    }

    @Override
    public void inflateParameters() {
    }

    @Override
    public ConstructAdventure copyFrom(ConstructAITask<?> other) {
        return this;
    }

    @Override
    public ConstructAdventure duplicate() {
        return new ConstructAdventure(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return required_capabilities;
    }

    @Override
    public int getRequiredIntelligence() {
        return 16;
    }
}

