/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.entities.EntityInit;
import com.mna.items.ItemInit;
import com.mna.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class MagicBroom
extends AbstractGolem {
    private static final float detection_radius = 16.0f;
    private static final float detection_height = 4.0f;
    private static final float max_distance_from_container = 48.0f;
    private static final float movement_speed = 0.4f;
    public static final int BROOM_TYPE_NORMAL = 0;
    public static final int BROOM_TYPE_VORTEX = 1;
    private static final Predicate<ItemEntity> ITEM_SELECTOR = e -> {
        if (e.getPersistentData().m_128441_("PreventRemoteMovement")) {
            return false;
        }
        return !e.m_32063_() && e.m_6084_();
    };
    private int deposit_counter = 0;
    private boolean depositing = false;
    private static final EntityDataAccessor<BlockPos> CONTAINER_POSITION = SynchedEntityData.m_135353_(MagicBroom.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> BROOM_TYPE = SynchedEntityData.m_135353_(MagicBroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String KEY_TARGETPOS = "magic_broom_targetPosition";
    private static final String KEY_BROOM_TYPE = "magic_broom_type";
    private float moveCounter = 0.0f;
    private float moveRotation = 0.0f;

    public MagicBroom(EntityType<? extends AbstractGolem> type, Level worldIn) {
        super(type, worldIn);
        this.m_21553_(true);
    }

    public float getStepHeight() {
        return 1.8f;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0);
    }

    private void updateRotations() {
        if (Math.abs(this.m_20184_().m_82553_()) > (double)0.1f) {
            this.moveCounter += 0.3f;
            this.moveRotation = (float)Math.sin(this.moveCounter) - (float)Math.sin(this.moveCounter - 1.0f);
            if ((int)this.moveCounter % 3 == 0 && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11992_, SoundSource.NEUTRAL, 0.25f, 1.0f, false);
            }
        } else {
            this.moveCounter = 1.57f;
            if (this.moveRotation > 0.0f) {
                this.moveRotation -= 0.1f;
                if (this.moveRotation < 0.0f) {
                    this.moveRotation = 0.0f;
                }
            } else if (this.moveRotation < 0.0f) {
                this.moveRotation += 0.1f;
                if (this.moveRotation > 0.0f) {
                    this.moveRotation = 0.0f;
                }
            }
        }
    }

    public float getRotation() {
        return this.moveRotation;
    }

    public MagicBroom(Level worldIn) {
        super((EntityType)EntityInit.MAGIC_BROOM.get(), worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FindItemsGoal());
        this.f_21345_.m_25352_(2, (Goal)new DepositItemsGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CONTAINER_POSITION, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(BROOM_TYPE, (Object)0);
    }

    public int getBroomType() {
        return (Integer)this.f_19804_.m_135370_(BROOM_TYPE);
    }

    public void setBroomType(int type) {
        this.f_19804_.m_135381_(BROOM_TYPE, (Object)type);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getBroomType() == 1) {
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.2f).setColor(10, 10, 10), this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)0.3f, (double)0.05f, 0.5);
            }
            this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82400_(16.0)).forEach(e -> {
                if (e != null && e.m_6084_() && this.m_21574_().m_148306_((Entity)e)) {
                    Vec3 tPos = e.m_20182_();
                    Vec3 cPos = this.m_20182_();
                    Vec3 delta = cPos.m_82546_(tPos).m_82541_();
                    e.m_20256_(delta.m_82490_((double)0.15f));
                }
            });
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (player.m_6144_() && !this.m_9236_().m_5776_() && this.m_6084_()) {
            this.m_21553_(false);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack(this.getBroomType() == 0 ? (ItemLike)ItemInit.MAGIC_BROOM.get() : (ItemLike)ItemInit.VORTEX_BROOM.get()));
            entity.m_32010_(20);
            this.m_9236_().m_7967_((Entity)entity);
            this.m_6668_(this.m_21225_());
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    public BlockPos getContainerPosition() {
        return (BlockPos)this.f_19804_.m_135370_(CONTAINER_POSITION);
    }

    public void setContainerPosition(BlockPos pos) {
        this.f_19804_.m_135381_(CONTAINER_POSITION, (Object)pos);
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean m_20151_() {
        return false;
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack curStack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (curStack.m_41619_()) {
            return true;
        }
        return curStack.m_41720_() == stack.m_41720_() && curStack.m_41613_() <= curStack.m_41741_() - stack.m_41613_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.updateRotations();
        if (this.m_9236_().m_5776_() && Math.abs(this.m_20184_().m_82553_()) > (double)0.1f) {
            float particle_spread = 0.05f;
            Vec3 velocity = new Vec3((double)-0.05f + Math.random() * (double)0.1f, (double)0.025f, (double)-0.05f + Math.random() * (double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), this.m_20185_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.m_20186_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.m_20189_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
        if (this.m_6084_()) {
            for (ItemEntity itementity : this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82377_(3.0, 0.25, 3.0))) {
                if (!itementity.m_6084_() || itementity.m_32055_().m_41619_() || itementity.m_32063_()) continue;
                this.m_7581_(itementity);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        if (itemEntity.m_32063_() || itemEntity.m_9236_().m_5776_()) {
            return;
        }
        ItemStack mhStack = this.m_6844_(EquipmentSlot.MAINHAND);
        ItemStack groundStack = itemEntity.m_32055_();
        if (mhStack.m_41619_()) {
            this.m_8061_(EquipmentSlot.MAINHAND, groundStack);
            this.m_7938_((Entity)itemEntity, mhStack.m_41613_());
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (ItemStack.m_41728_((ItemStack)groundStack, (ItemStack)mhStack)) {
            int space = mhStack.m_41741_() - mhStack.m_41613_();
            int qtyCollected = Math.min(space, groundStack.m_41613_());
            ItemStack pickupStack = groundStack.m_41620_(qtyCollected);
            mhStack.m_41764_(mhStack.m_41613_() + pickupStack.m_41613_());
            this.m_8061_(EquipmentSlot.MAINHAND, mhStack);
            if (groundStack.m_41613_() <= 0) {
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                itemEntity.m_32045_(groundStack);
            }
        }
    }

    protected void m_6668_(DamageSource damageSourceIn) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_()) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        BlockPos target = this.getContainerPosition();
        CompoundTag targetPos = new CompoundTag();
        targetPos.m_128405_("x", target.m_123341_());
        targetPos.m_128405_("y", target.m_123342_());
        targetPos.m_128405_("z", target.m_123343_());
        compound.m_128365_(KEY_TARGETPOS, (Tag)targetPos);
        compound.m_128405_(KEY_BROOM_TYPE, ((Integer)this.f_19804_.m_135370_(BROOM_TYPE)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_(KEY_TARGETPOS)) {
            CompoundTag targetPos = compound.m_128469_(KEY_TARGETPOS);
            this.setContainerPosition(new BlockPos(targetPos.m_128451_("x"), targetPos.m_128451_("y"), targetPos.m_128451_("z")));
        }
        if (compound.m_128441_(KEY_BROOM_TYPE)) {
            this.f_19804_.m_135381_(BROOM_TYPE, (Object)compound.m_128451_(KEY_BROOM_TYPE));
        }
    }

    class FindItemsGoal
    extends Goal {
        private BlockPos originPos;
        private boolean abort = false;
        private ArrayList<Integer> ignoredEntityIDs;
        private int stuck_count;
        private Vec3 last_pos;

        public FindItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.ignoredEntityIDs = new ArrayList();
        }

        public boolean m_8036_() {
            if (MagicBroom.this.depositing) {
                return false;
            }
            if (this.abort) {
                this.abort = false;
                return false;
            }
            List list = MagicBroom.this.m_9236_().m_6443_(ItemEntity.class, MagicBroom.this.m_20191_().m_82377_(16.0, 4.0, 16.0), e -> {
                if (MagicBroom.this.m_21574_().m_148306_((Entity)e)) {
                    return ITEM_SELECTOR.test((ItemEntity)e);
                }
                return false;
            });
            if (!list.isEmpty()) {
                ItemStack stack = MagicBroom.this.m_6844_(EquipmentSlot.MAINHAND);
                if (stack.m_41613_() == stack.m_41741_()) {
                    return false;
                }
                if (stack.m_41619_()) {
                    return true;
                }
                for (ItemEntity item : list) {
                    if (item.m_32055_().m_41720_() != MagicBroom.this.m_6844_(EquipmentSlot.MAINHAND).m_41720_()) continue;
                    return true;
                }
            }
            return false;
        }

        public void m_8037_() {
            if (this.originPos == null || !MagicBroom.this.m_9236_().m_46749_(this.originPos)) {
                this.abort = true;
                return;
            }
            this.stuck_count = this.last_pos != null && MagicBroom.this.m_20182_().m_82554_(this.last_pos) < 0.25 ? ++this.stuck_count : 0;
            ItemStack itemstack = MagicBroom.this.m_6844_(EquipmentSlot.MAINHAND);
            ItemEntity pickupTarget = null;
            if (itemstack.m_41619_()) {
                List list = MagicBroom.this.m_9236_().m_6443_(ItemEntity.class, new AABB(this.originPos).m_82377_(16.0, 4.0, 16.0), e -> !this.ignoredEntityIDs.contains(e.m_19879_()) && ITEM_SELECTOR.test((ItemEntity)e));
                if (!list.isEmpty()) {
                    pickupTarget = (ItemEntity)list.get(0);
                }
            } else {
                List list = MagicBroom.this.m_9236_().m_6443_(ItemEntity.class, new AABB(this.originPos).m_82377_(16.0, 4.0, 16.0), item -> !this.ignoredEntityIDs.contains(item.m_19879_()) && !item.m_32063_() && item.m_6084_() && item.m_32055_().m_41720_() == itemstack.m_41720_());
                if (!list.isEmpty() && itemstack.m_41613_() < itemstack.m_41741_()) {
                    pickupTarget = (ItemEntity)list.get(0);
                }
            }
            if (!(pickupTarget == null || this.stuck_count != 20 && MagicBroom.this.m_21573_().m_5624_((Entity)pickupTarget, (double)0.4f))) {
                this.ignoredEntityIDs.add(pickupTarget.m_19879_());
                this.stuck_count = 0;
            }
        }

        public void m_8056_() {
            this.ignoredEntityIDs.clear();
            this.stuck_count = 0;
            this.last_pos = null;
            this.originPos = MagicBroom.this.getContainerPosition();
            this.abort = false;
            List list = MagicBroom.this.m_9236_().m_6443_(ItemEntity.class, MagicBroom.this.m_20191_().m_82377_(16.0, 1.0, 16.0), e -> {
                if (MagicBroom.this.m_21574_().m_148306_((Entity)e)) {
                    return ITEM_SELECTOR.test((ItemEntity)e);
                }
                return false;
            });
            if (!list.isEmpty()) {
                MagicBroom.this.m_21573_().m_5624_((Entity)list.get(0), (double)0.4f);
            }
        }
    }

    class DepositItemsGoal
    extends Goal {
        private BlockEntity targetTE;
        private boolean abort = false;

        public DepositItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.abort) {
                this.abort = false;
                return false;
            }
            if (MagicBroom.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            return MagicBroom.this.m_20183_().m_123314_((Vec3i)MagicBroom.this.getContainerPosition(), 48.0);
        }

        public void m_8041_() {
            super.m_8041_();
            MagicBroom.this.depositing = false;
            MagicBroom.this.deposit_counter = 10;
        }

        public void m_8056_() {
            BlockPos target = MagicBroom.this.getContainerPosition();
            MagicBroom.this.m_21573_().m_26519_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_(), (double)0.4f);
            this.targetTE = MagicBroom.this.m_20193_().m_7702_(MagicBroom.this.getContainerPosition());
            this.abort = false;
        }

        public void m_8037_() {
            if (this.targetTE == null) {
                this.abort = true;
                return;
            }
            LazyOptional handler = this.targetTE.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP);
            FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)MagicBroom.this.m_9236_()));
            if (!handler.isPresent()) {
                this.abort = true;
                return;
            }
            ItemStack activeStack = MagicBroom.this.m_6844_(EquipmentSlot.MAINHAND);
            BlockPos target = MagicBroom.this.getContainerPosition();
            double dist = MagicBroom.this.m_20275_(target.m_123341_(), target.m_123342_(), target.m_123343_());
            if (dist < 4.0) {
                MagicBroom.this.f_21344_.m_26573_();
                if (!MagicBroom.this.depositing) {
                    MagicBroom.this.depositing = true;
                    if (this.targetTE instanceof Container) {
                        ((Container)this.targetTE).m_5856_((Player)player);
                    }
                }
                if (MagicBroom.this.deposit_counter <= 0) {
                    MagicBroom.this.deposit_counter = 10;
                    if (InventoryUtilities.mergeIntoInventory((IItemHandler)handler.resolve().get(), activeStack, 10)) {
                        MagicBroom.this.depositing = false;
                    }
                } else {
                    --MagicBroom.this.deposit_counter;
                }
                if (!MagicBroom.this.depositing && this.targetTE instanceof Container) {
                    ((Container)this.targetTE).m_5785_((Player)player);
                }
            } else {
                MagicBroom.this.m_21573_().m_26519_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_(), (double)0.4f);
            }
        }
    }
}

