/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.entities.DamageHelper;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.BossMonster;
import com.mna.entities.boss.attacks.ThrownAllfatherAxe;
import com.mna.entities.boss.effects.Bifrost;
import com.mna.items.ItemInit;
import com.mna.particles.types.movers.ParticleOrbitMover;
import com.mna.spells.crafting.SpellRecipe;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class Odin
extends BossMonster<Odin> {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(true);
    private static final EntityDataAccessor<Byte> DATA_AXE_SLOT = SynchedEntityData.m_135353_(BossMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.m_135353_(BossMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final TargetingConditions TARGETING_CONDITIONS_SNOWBLIND = TargetingConditions.m_148352_().m_26883_(40.0).m_26888_(LIVING_ENTITY_SELECTOR);
    public static final byte AXE_SLOT_BACK = 0;
    public static final byte AXE_SLOT_HAND = 1;
    public static final byte AXE_SLOT_THROW = 2;
    private static final int ACTION_FROST_SPELL = 2;
    private static final int ACTION_LIGHTNING_SPELL = 4;
    private static final int ACTION_THROW_AXE = 8;
    private static final int ACTION_ENRAGE = 16;
    private static final int ACTION_OFFER = 32;
    private static final int ACTION_LEAVE = 64;
    private static final int ACTION_WRATH = 128;
    private static final int ACTION_SMITE = 256;

    public Odin(EntityType<? extends Monster> p_i48553_1_, Level p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
    }

    public Odin(Level world) {
        this((EntityType<? extends Monster>)((EntityType)EntityInit.ODIN.get()), world);
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 850.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22278_, 0.75);
    }

    public float getStepHeight() {
        return 1.6f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_45955_(TARGETING_CONDITIONS_SNOWBLIND, (LivingEntity)this, this.m_20191_().m_82400_(40.0)).forEach(p -> p.m_7292_(new MobEffectInstance((MobEffect)EffectInit.SNOWBLIND.get(), 100, 0)));
            BlockPos search = this.m_20183_().m_7495_();
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    BlockPos offset = search.m_7918_(i, 0, j);
                    BlockState belowState = this.m_9236_().m_8055_(offset);
                    if (belowState.m_60713_(Blocks.f_49990_)) {
                        this.m_9236_().m_7731_(offset, Blocks.f_50449_.m_49966_(), 3);
                        continue;
                    }
                    if (!belowState.m_60713_(Blocks.f_49991_)) continue;
                    this.m_9236_().m_7731_(offset, Blocks.f_50652_.m_49966_(), 3);
                }
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_AXE_SLOT, (Object)0);
        this.f_19804_.m_135372_(ENRAGED, (Object)false);
    }

    public byte getAxeSlot() {
        return (Byte)this.f_19804_.m_135370_(DATA_AXE_SLOT);
    }

    public void setAxeSlot(byte slot) {
        this.f_19804_.m_135381_(DATA_AXE_SLOT, (Object)slot);
    }

    @Override
    protected ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BossMonster<?>> state) {
        if (this.getInvulnerableTicks() > 0) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.odin.summon"));
        }
        if (this.flagSet(32)) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.odin.offerAxe"));
        }
        if (this.flagSet(64)) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.odin.bifrostLeave"));
        }
        if (!this.flagSet(1)) {
            if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.odin.walk"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.odin.idle"));
        }
        if (this.flagSet(4) || this.flagSet(8)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.odin.axeThrow"));
        }
        if (this.flagSet(2) || this.flagSet(4)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.odin.spellCast"));
        }
        if (this.flagSet(16)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.odin.axeImbue"));
        }
        if (this.flagSet(128)) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.odin.axeImbue"));
        }
        return state.setAndContinue(RawAnimation.begin().thenPlay("animation.odin.axeHit"));
    }

    @Override
    public void setupSpawn() {
        this.setInvulnerableTicks(110);
        this.m_21153_(this.m_21233_() / 3.0f);
    }

    @Override
    protected void m_8024_() {
        if (this.getInvulnerableTicks() > 0) {
            int j1 = this.getInvulnerableTicks() - 1;
            if (j1 <= 0) {
                this.m_5634_(this.m_21233_());
            }
            this.setInvulnerableTicks(j1);
            if (this.f_19797_ % 10 == 0) {
                this.m_5634_(50.0f);
            }
            if (j1 == 11) {
                this.setAxeSlot((byte)1);
            }
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.flagSet(1) || this.isOnCooldown(1) || (Byte)this.f_19804_.m_135370_(DATA_AXE_SLOT) == 2) {
            return true;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Entity>("", 14, entityIn, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 18, "", this::handleDelayCallback));
        this.setState(1);
        return true;
    }

    @Override
    protected void spawnParticles() {
        int i;
        if (this.flagSet(16)) {
            for (i = 0; i < 20; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMover(new ParticleOrbitMover(this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), 0.1f, -0.01f, 1.0)), this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        if (((Boolean)this.f_19804_.m_135370_(ENRAGED)).booleanValue()) {
            for (i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMover(new ParticleOrbitMover(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.5, 0.065f, 0.8f)), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource type, float amount) {
        if (this.flagSet(32)) {
            return false;
        }
        if (this.flagSet(64)) {
            return false;
        }
        if (((Boolean)this.f_19804_.m_135370_(ENRAGED)).booleanValue()) {
            amount *= 0.4f;
        }
        return super.m_6469_(type, amount);
    }

    @Override
    public void m_6667_(DamageSource type) {
        this.m_21153_(1.0f);
        this.m_5634_(300.0f);
        if (type.m_7639_() instanceof Player) {
            this.setOfferingAxe();
        } else {
            this.setLeaving();
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vector, InteractionHand hand) {
        if (this.flagSet(32)) {
            this.giveAxe(player);
            this.setLeaving();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public ResourceLocation getArenaStructureID() {
        return null;
    }

    @Override
    public int getArenaStructureSegment() {
        return -1;
    }

    public boolean damageEntity(Entity entityIn) {
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        boolean flag = entityIn.m_6469_((Boolean)this.f_19804_.m_135370_(ENRAGED) != false ? DamageHelper.createSourcedType(DamageHelper.FROST, this.m_9236_().m_9598_(), (Entity)this) : this.m_269291_().m_269333_((LivingEntity)this), f);
        if (flag) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof Player) {
                Player playerentity;
                this.maybeDisableShield(playerentity, (playerentity = (Player)entityIn).m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_);
            }
            this.m_21335_(entityIn);
            if (this.f_19796_.m_188501_() < 0.4f && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
            }
        }
        return flag;
    }

    private void maybeDisableShield(Player player, ItemStack playerItem) {
        if (!playerItem.m_41619_() && playerItem.m_41720_().canPerformAction(playerItem, ToolActions.SHIELD_BLOCK)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)player, (byte)30);
            }
        }
    }

    public void hideAxe() {
        this.f_19804_.m_135381_(DATA_AXE_SLOT, (Object)2);
    }

    public void showAxe() {
        this.f_19804_.m_135381_(DATA_AXE_SLOT, (Object)1);
    }

    private void setOfferingAxe() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.clearState();
        this.setState(32);
        this.hideBossBar();
        if (!this.m_9236_().m_5776_()) {
            this.threat.forEach((entityID, threat) -> {
                Entity e = this.m_9236_().m_6815_(entityID.intValue());
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_213846_((Component)Component.m_237115_((String)"entity.mna.odin.defeated"));
                    Stat stat = Stats.f_12986_.m_12902_((Object)this.m_6095_());
                    player.m_36246_(stat);
                    int totalKills = player.m_8951_().m_13015_(stat);
                    ResourceLocation typeName = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_());
                    CustomAdvancementTriggers.DEFEAT_BOSS.trigger(player, typeName, totalKills);
                }
            });
        }
    }

    @Override
    public void m_6710_(LivingEntity target) {
        this.threat.initializeThreat(target);
        super.m_6710_(target);
    }

    private void setLeaving() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.clearState();
        this.setState(64);
        this.setAxeSlot((byte)2);
        Bifrost bifrost = new Bifrost(this.m_9236_(), this.m_20182_().m_82520_(0.0, 10.0, 0.0));
        bifrost.setNoSummon();
        this.m_9236_().m_7967_((Entity)bifrost);
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("leave", 130, "leave", this::handleDelayCallback));
    }

    private void giveAxe(Player player) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ItemStack reward = new ItemStack((ItemLike)ItemInit.ALLFATHER_AXE.get());
        if (!player.m_36356_(reward)) {
            player.m_7197_(reward, false, false);
        }
    }

    private void handleDelayCallback(String id, Entity e) {
        if (this.flagSet(1)) {
            if (this.flagSet(16)) {
                this.f_19804_.m_135381_(ENRAGED, (Object)true);
                this.m_5496_(SFX.Entity.Odin.ENRAGE, 1.0f, 1.0f);
            } else {
                this.damageEntity(e);
                this.m_5496_(SFX.Entity.Odin.ATTACK, 1.0f, (float)(0.6 + Math.random() * 0.8));
            }
        }
    }

    private void handleDelayCallback(String id, String command) {
        if (command == "leave") {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.flagSet(16)) {
            this.clearState(16);
        }
        if (this.flagSet(8)) {
            this.clearState(8);
        }
        this.clearState(1);
        this.setCooldown(1, (Boolean)this.f_19804_.m_135370_(ENRAGED) != false ? 10 : 20);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("axe_slot")) {
            this.setAxeSlot(nbt.m_128445_("axe_slot"));
        }
        this.setState(0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("axe_slot", this.getAxeSlot());
    }

    protected void m_8099_() {
        SpellRecipe frost = new SpellRecipe();
        frost.setShape(Shapes.PROJECTILE).addComponent(Components.FROST_DAMAGE).addComponent(Components.SLOW);
        frost.changeShapeAttributeValue(Attribute.SPEED, 1.75f);
        frost.changeShapeAttributeValue(Attribute.RADIUS, 1.75f);
        frost.changeComponentAttributeValue(0, Attribute.DAMAGE, 20.0f);
        frost.changeComponentAttributeValue(0, Attribute.DURATION, 7.0f);
        frost.changeComponentAttributeValue(1, Attribute.MAGNITUDE, 2.0f);
        SpellRecipe lightning = new SpellRecipe();
        lightning.setShape(Shapes.PROJECTILE).addComponent(Components.LIGHTNING_DAMAGE).addComponent(Components.GRAVITY_WELL);
        lightning.changeShapeAttributeValue(Attribute.SPEED, 1.75f);
        lightning.changeShapeAttributeValue(Attribute.RADIUS, 1.75f);
        lightning.changeComponentAttributeValue(0, Attribute.DAMAGE, 20.0f);
        lightning.changeComponentAttributeValue(1, Attribute.DURATION, 10.0f);
        SpellRecipe wrath = new SpellRecipe();
        wrath.setShape(Shapes.WRATH).addComponent(Components.FRAILTY).addComponent(Components.LIGHTNING_DAMAGE).addComponent(Components.GRAVITY_WELL).addComponent(Components.PULL).addComponent(Components.ICE_SPIKE);
        wrath.changeShapeAttributeValue(Attribute.DURATION, 5.0f);
        wrath.changeShapeAttributeValue(Attribute.WIDTH, 15.0f);
        wrath.changeShapeAttributeValue(Attribute.HEIGHT, 15.0f);
        wrath.changeShapeAttributeValue(Attribute.RADIUS, 3.0f);
        wrath.changeComponentAttributeValue(0, Attribute.DURATION, 30.0f);
        wrath.changeComponentAttributeValue(1, Attribute.DAMAGE, 20.0f);
        wrath.changeComponentAttributeValue(1, Attribute.LESSER_MAGNITUDE, 100.0f);
        wrath.changeComponentAttributeValue(1, Attribute.RADIUS, 5.0f);
        wrath.changeComponentAttributeValue(2, Attribute.DURATION, 10.0f);
        wrath.changeComponentAttributeValue(3, Attribute.SPEED, 3.0f);
        wrath.changeComponentAttributeValue(4, Attribute.DAMAGE, 20.0f);
        SpellRecipe smite = new SpellRecipe();
        smite.setShape(Shapes.SMITE).addComponent(Components.LIGHTNING_DAMAGE).addComponent(Components.GRAVITY_WELL).addComponent(Components.PULL).addComponent(Components.ICE_SPIKE);
        smite.changeShapeAttributeValue(Attribute.HEIGHT, 15.0f);
        smite.changeShapeAttributeValue(Attribute.RANGE, 32.0f);
        smite.changeShapeAttributeValue(Attribute.RADIUS, 3.0f);
        wrath.changeComponentAttributeValue(0, Attribute.DAMAGE, 20.0f);
        wrath.changeComponentAttributeValue(0, Attribute.LESSER_MAGNITUDE, 100.0f);
        wrath.changeComponentAttributeValue(0, Attribute.RADIUS, 5.0f);
        wrath.changeComponentAttributeValue(1, Attribute.DURATION, 10.0f);
        wrath.changeComponentAttributeValue(2, Attribute.SPEED, 3.0f);
        wrath.changeComponentAttributeValue(3, Attribute.DAMAGE, 20.0f);
        this.f_21345_.m_25352_(0, (Goal)new BossMonster.DoNothingGoal());
        this.f_21345_.m_25352_(0, (Goal)new BossMonster.DoNothingGoal(32));
        this.f_21345_.m_25352_(0, (Goal)new BossMonster.DoNothingGoal(64));
        this.f_21345_.m_25352_(1, (Goal)new Enrage());
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BossMonster.CastSpellAtTargetGoal(wrath.createAsSpell(), 0.35f, 1200, 16.0f, 0.0f, false, 128, 12, 120, () -> {
            this.setState(1);
            this.setState(128);
        }, () -> {
            this.clearState(1);
            this.setCooldown(1, (Boolean)this.f_19804_.m_135370_(ENRAGED) != false ? 10 : 20);
        }, null).setUsePredicate(b -> (Boolean)this.f_19804_.m_135370_(ENRAGED)).setChannelTime(100));
        this.f_21345_.m_25352_(3, (Goal)new BossMonster.CastSpellAtTargetGoal(frost.createAsSpell(), 0.35f, 200, 32.0f, 2.0f, true, 2, 12, 20, () -> {
            this.setState(1);
            this.setState(2);
        }, () -> {
            this.clearState(1);
            this.setCooldown(1, (Boolean)this.f_19804_.m_135370_(ENRAGED) != false ? 10 : 20);
        }, null));
        this.f_21345_.m_25352_(3, (Goal)new BossMonster.CastSpellAtTargetGoal(smite.createAsSpell(), 0.35f, 300, 30.0f, 0.0f, true, 256, 12, 20, () -> {
            this.setState(1);
            this.setState(256);
        }, () -> {
            this.clearState(1);
            this.setCooldown(1, (Boolean)this.f_19804_.m_135370_(ENRAGED) != false ? 10 : 20);
        }, null));
        this.f_21345_.m_25352_(4, (Goal)new BossMonster.CastSpellAtTargetGoal(lightning.createAsSpell(), 0.35f, 200, 32.0f, 2.0f, true, 4, 12, 20, () -> {
            this.setState(1);
            this.setState(4);
        }, () -> {
            this.clearState(1);
            this.setCooldown(1, (Boolean)this.f_19804_.m_135370_(ENRAGED) != false ? 10 : 20);
        }, null).setUsePredicate(b -> (Byte)this.f_19804_.m_135370_(DATA_AXE_SLOT) != 1));
        this.f_21345_.m_25352_(4, (Goal)new ThrowAxeAtTargetGoal(0.35f, 200, 6.0f, 2.0f, true, 16, 4, this::handleDelayCallback));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_), false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.35f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new BossMonster.ThreatTableHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, le -> true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, BossMonster.class, 10, true, false, le -> le != this));
    }

    protected SoundEvent m_7515_() {
        return super.m_7515_();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SFX.Entity.Odin.HIT;
    }

    @Override
    public void handle(SoundKeyframeEvent<BossMonster<?>> event) {
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Entity.Odin.DRAW, SoundSource.HOSTILE, 1.0f, 1.0f, false);
    }

    class Enrage
    extends Goal {
        public Enrage() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return (double)Odin.this.m_21223_() < (double)Odin.this.m_21233_() * 0.5 && !Odin.this.flagSet(1) && (Boolean)Odin.this.f_19804_.m_135370_(ENRAGED) == false;
        }

        public void m_8056_() {
            DelayedEventQueue.pushEvent(Odin.this.m_9236_(), new TimedDelayedEvent<LivingEntity>("cast", 100, (LivingEntity)Odin.this, Odin.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(Odin.this.m_9236_(), new TimedDelayedEvent<String>("resetAttack", 100, "", Odin.this::handleDelayCallback));
            Odin.this.setState(1, 16);
        }

        public boolean m_8045_() {
            return Odin.this.flagSet(1);
        }
    }

    public class ThrowAxeAtTargetGoal
    extends Goal {
        private final double moveSpeedAmp;
        private final float maxAttackDistance;
        private final float minAttackDistance;
        private final int attackCooldown;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private final boolean randomThreatTarget;
        private LivingEntity target;
        private boolean isWaitingOnAnim = false;
        private final int effectDelayTicks;
        private final int resetTicks;
        private final BiConsumer<String, String> callbackFunction;

        public ThrowAxeAtTargetGoal(double moveSpeedAmpIn, int attackCooldownIn, float maxAttackDistanceIn, float minAttackDistanceIn, boolean randomTargetFromThreatTable, int delayTicks, int resetTicks, BiConsumer<String, String> resetCallback) {
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.minAttackDistance = minAttackDistanceIn * minAttackDistanceIn;
            this.attackCooldown = attackCooldownIn;
            this.effectDelayTicks = delayTicks;
            this.resetTicks = resetTicks;
            this.callbackFunction = resetCallback;
            this.randomThreatTarget = randomTargetFromThreatTable;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Odin.this.m_5448_() != null && !Odin.this.isOnCooldown(8) && !Odin.this.isOnCooldown(1) && Odin.this.m_5448_().m_20280_((Entity)Odin.this) >= (double)this.minAttackDistance && (Byte)Odin.this.f_19804_.m_135370_(DATA_AXE_SLOT) != 2;
        }

        public boolean m_8045_() {
            if (this.target == null || this.target.m_21224_() || this.target.m_20182_().m_82557_(Odin.this.m_20182_()) > Odin.this.m_21133_(Attributes.f_22277_)) {
                return false;
            }
            if (!Odin.this.isOnCooldown(8)) {
                return false;
            }
            if (this.isWaitingOnAnim) {
                return true;
            }
            return this.m_8036_() || !Odin.this.m_21573_().m_26571_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.target = this.randomThreatTarget ? Odin.this.getRandomThreatTableTarget(Odin.this.m_21133_(Attributes.f_22277_)) : Odin.this.m_5448_();
        }

        public void m_8041_() {
            super.m_8041_();
            Odin.this.setCooldown(8, this.attackCooldown);
            this.target = null;
            this.seeTime = 0;
            this.isWaitingOnAnim = false;
        }

        private void throwCallback(String identifier, LivingEntity target) {
            Vec3 origin = Odin.this.m_20182_().m_82520_(0.0, (double)Odin.this.m_20192_(), 0.0);
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
            Vec3 targetVelocity = target.m_20182_().m_82492_(target.f_19790_, target.f_19791_, target.f_19792_);
            targetVelocity = targetVelocity.m_82492_(0.0, target.m_21051_((net.minecraft.world.entity.ai.attributes.Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_(), 0.0);
            if (target.m_20096_()) {
                targetVelocity = targetVelocity.m_82520_(0.0, -targetVelocity.f_82480_, 0.0);
            }
            double distance = origin.m_82554_(targetPos);
            double speed = 1.0;
            int ticksToArrive = (int)Math.round(distance / speed);
            Vec3 adjustedTargetPos = targetPos.m_82549_(targetVelocity.m_82490_((double)ticksToArrive));
            Vec3 delta = adjustedTargetPos.m_82546_(origin).m_82541_();
            Odin.this.hideAxe();
            ThrownAllfatherAxe thrown = new ThrownAllfatherAxe((LivingEntity)Odin.this, Odin.this.m_9236_(), null);
            thrown.m_6686_(delta.f_82479_, delta.f_82480_, delta.f_82481_, 1.0f, 0.0f);
            Odin.this.m_9236_().m_7967_((Entity)thrown);
            this.m_8041_();
        }

        public void m_8037_() {
            if (this.target == null) {
                this.m_8041_();
                return;
            }
            if (this.isWaitingOnAnim) {
                return;
            }
            LivingEntity livingentity = Odin.this.m_5448_();
            if (livingentity != null) {
                boolean positiveSeeTime;
                double d0 = Odin.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean canSee = Odin.this.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = positiveSeeTime = this.seeTime > 0;
                if (canSee != positiveSeeTime) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    Odin.this.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    Odin.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)Odin.this.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)Odin.this.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    Odin.this.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    Odin.this.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    Odin.this.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                if (!canSee && this.seeTime < -60) {
                    this.m_8041_();
                } else if (canSee) {
                    DelayedEventQueue.pushEvent(Odin.this.m_9236_(), new TimedDelayedEvent<LivingEntity>("throw", this.effectDelayTicks, livingentity, this::throwCallback));
                    DelayedEventQueue.pushEvent(Odin.this.m_9236_(), new TimedDelayedEvent<String>("resetAttack", this.resetTicks, "", this.callbackFunction));
                    Odin.this.setState(1, 8);
                    this.isWaitingOnAnim = true;
                }
            }
        }
    }
}

