/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.ai;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class ThreatTable {
    private static final int THREAT_STEAL_THRESHOLD = 10;
    private Map<Integer, Float> threat = Maps.newHashMap();
    private Predicate<Entity> threatAddPredicate = null;

    public ThreatTable() {
        this(null);
    }

    public ThreatTable(Predicate<Entity> threatAdd) {
        this.threatAddPredicate = threatAdd;
    }

    public void addThreat(LivingEntity attacker, float amount, LivingEntity currentTarget) {
        if (attacker == null || this.threatAddPredicate != null && !this.threatAddPredicate.test((Entity)attacker)) {
            return;
        }
        float newThreat = this.threat.getOrDefault(attacker.m_19879_(), Float.valueOf(0.0f)).floatValue() + amount;
        this.threat.put(attacker.m_19879_(), Float.valueOf(newThreat));
    }

    public void initializeThreat(LivingEntity attacker) {
        if (attacker == null) {
            return;
        }
        if (!this.threat.containsKey(attacker.m_19879_())) {
            this.threat.put(attacker.m_19879_(), Float.valueOf(1.0f));
        }
    }

    public boolean shouldSwitchTarget(LivingEntity currentTarget, LivingEntity potentialTarget) {
        if (currentTarget == null || !currentTarget.m_6084_()) {
            return true;
        }
        if (potentialTarget == null || !potentialTarget.m_6084_()) {
            return false;
        }
        if (currentTarget.m_19879_() == potentialTarget.m_19879_()) {
            return false;
        }
        float currentThreat = this.threat.getOrDefault(currentTarget.m_19879_(), Float.valueOf(0.0f)).floatValue();
        float targetThreat = this.threat.getOrDefault(potentialTarget.m_19879_(), Float.valueOf(0.0f)).floatValue();
        return targetThreat >= currentThreat + 10.0f;
    }

    public int getRandomThreatEntry(Level world, LivingEntity owner, double maxTargetDist, @Nullable Predicate<LivingEntity> selectionPredicate) {
        ArrayList allKeys = new ArrayList();
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        double maxDistSquared = maxTargetDist * maxTargetDist;
        this.threat.keySet().forEach((? super T entityID) -> {
            Entity e = world.m_6815_(entityID.intValue());
            if (e == null || !e.m_6084_() || !(e instanceof LivingEntity) || selectionPredicate != null && !selectionPredicate.test((LivingEntity)e)) {
                toRemove.add((Integer)entityID);
                return;
            }
            if (e.m_20182_().m_82557_(owner.m_20182_()) < maxDistSquared) {
                allKeys.add(entityID);
            }
        });
        toRemove.forEach((? super E i) -> this.threat.remove(i));
        if (allKeys.size() == 0) {
            return -1;
        }
        return (Integer)allKeys.get((int)(Math.random() * (double)allKeys.size()));
    }

    @Nullable
    private Pair<Integer, Float> getHighestThreatTarget() {
        if (this.threat.size() == 0) {
            return null;
        }
        MutableInt highestID = new MutableInt(-1);
        MutableFloat highestThreat = new MutableFloat(-1.0f);
        this.threat.forEach((? super K k, ? super V v) -> {
            if (highestID.getValue() == -1 || highestThreat.getValue().floatValue() < v.floatValue()) {
                highestID.setValue((Number)k);
                highestThreat.setValue((Number)v);
            }
        });
        return new Pair((Object)highestID.getValue(), (Object)highestThreat.getValue());
    }

    public void forEach(BiConsumer<Integer, Float> callback) {
        this.threat.forEach(callback);
    }

    public boolean isOn(LivingEntity e) {
        return this.threat.containsKey(e.m_19879_());
    }

    public int size() {
        return this.threat.size();
    }

    public ArrayList<Player> players(Level world) {
        ArrayList<Player> players = new ArrayList<Player>();
        this.threat.forEach((? super K entityID, ? super V threat) -> {
            Entity e = world.m_6815_(entityID.intValue());
            if (e != null && e.m_6084_() && e instanceof Player) {
                players.add((Player)e);
            }
        });
        return players;
    }

    public void remove(LivingEntity target) {
        if (target != null) {
            this.threat.remove(target.m_19879_());
        }
    }
}

