/*
 * Decompiled with CFR 0.152.
 */
package com.mna.effects;

import com.mna.ManaAndArtifice;
import com.mna.effects.interfaces.IDoubleTapEndEarly;
import com.mna.entities.summon.Simulacrum;
import com.mna.tools.SummonUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectHelper {
    public static void removeDoubleTapEvents(Player player) {
        EffectHelper.removeDoubleTapEarlyEffects((LivingEntity)player);
        SummonUtils.iterateTrackedEntities((LivingEntity)player, "mna:simulacrum_ids", e -> {
            Entity entity = player.m_9236_().m_6815_(e.intValue());
            if (entity instanceof Simulacrum) {
                Simulacrum simulacrum = (Simulacrum)entity;
                EffectHelper.removeDoubleTapEarlyEffects((LivingEntity)simulacrum);
            }
        });
    }

    private static void removeDoubleTapEarlyEffects(LivingEntity living) {
        List toRemove = living.m_21220_().stream().filter(e -> {
            IDoubleTapEndEarly iee;
            MobEffect patt1067$temp = e.m_19544_();
            return patt1067$temp instanceof IDoubleTapEndEarly && (iee = (IDoubleTapEndEarly)patt1067$temp).canEndEarly(living, (MobEffectInstance)e);
        }).collect(Collectors.toList());
        for (MobEffectInstance inst : toRemove) {
            if (inst == null) continue;
            ((IDoubleTapEndEarly)inst.m_19544_()).onRemoved(living, inst);
            if (living.m_9236_().m_5776_()) continue;
            try {
                living.m_21195_(inst.m_19544_());
            }
            catch (Exception e2) {
                ManaAndArtifice.LOGGER.warn("Attempted to remove potion effect " + ForgeRegistries.MOB_EFFECTS.getKey((Object)inst.m_19544_()).toString() + " early, but it failed.  Recovering and moving on.  The error was: " + e2.getMessage());
            }
        }
    }
}

