/*
 * Decompiled with CFR 0.152.
 */
package com.mna.commands;

import com.google.gson.JsonObject;
import com.mna.ManaAndArtifice;
import com.mna.recipes.multiblock.MultiblockConfiguration;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;

public class CommandStructureDiff {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"structurediff").then(Commands.m_82129_((String)"baseline", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"variation", (ArgumentType)StringArgumentType.string()).executes(context -> CommandStructureDiff.computeDiff((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"baseline"), StringArgumentType.getString((CommandContext)context, (String)"variation"))))));
    }

    private static int computeDiff(CommandSourceStack source, String firstStructure, String secondStructure) {
        ServerLevel sw = source.m_81372_();
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        MultiblockConfiguration first = MultiblockConfiguration.loadStructure(sw.m_215082_(), new ResourceLocation(firstStructure), blockStates);
        MultiblockConfiguration second = MultiblockConfiguration.loadStructure(sw.m_215082_(), new ResourceLocation(secondStructure), blockStates);
        if (!first.getIsValid()) {
            source.m_81352_((Component)Component.m_237113_((String)"Unable to locate first structure"));
            return 0;
        }
        if (!second.getIsValid()) {
            source.m_81352_((Component)Component.m_237113_((String)"Unable to locate second structure"));
            return 0;
        }
        JsonObject diff = first.computeRecipeDiff(second, blockStates);
        Supplier<Component> response = () -> Component.m_237113_((String)diff.toString());
        ManaAndArtifice.LOGGER.always().log(diff.toString());
        source.m_288197_(response, true);
        return 1;
    }
}

