/*
 * Decompiled with CFR 0.152.
 */
package com.mna.commands;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.capabilities.WellspringNode;
import com.mna.api.capabilities.resource.CastingResourceIDs;
import com.mna.api.commands.AffinityArgument;
import com.mna.api.commands.FactionArgument;
import com.mna.api.commands.SpellPartArgument;
import com.mna.api.faction.IFaction;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.capabilities.particles.ParticleAuraProvider;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.gui.containers.providers.NamedAuras;
import com.mna.recipes.progression.ProgressionCondition;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CommandMna {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mna").then(CommandMna.progressionCommands())).then(CommandMna.auraCommands())).then(CommandMna.raidCommands())).then(CommandMna.wellspringCommands())).then(CommandMna.roteCommands())).then(CommandMna.masteryCommands()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> progressionCommands() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"progression").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset_codex").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.resetCodex((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.resetCodex((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset_all").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.resetProgression((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.resetProgression((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"complete").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.completeProgression((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.completeProgression((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"level").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)75)).executes(context -> CommandMna.setMagicLevel((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.setMagicLevel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"affinity").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)100.0f)).executes(context -> CommandMna.addAffinity((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), AffinityArgument.getAffinity(context, "affinity"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)100.0f)).executes(context -> CommandMna.removeAffinity((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), AffinityArgument.getAffinity(context, "affinity"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)100.0f)).executes(context -> CommandMna.setAffinity((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), AffinityArgument.getAffinity(context, "affinity"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"))))))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).executes(context -> CommandMna.resetAffinity((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), AffinityArgument.getAffinity(context, "affinity")))))).then(Commands.m_82127_((String)"reset_all").executes(context -> CommandMna.resetAllAffinity((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"faction").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"faction", (ArgumentType)new FactionArgument()).executes(context -> CommandMna.setFaction((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), FactionArgument.getFaction(context, "faction"), 0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.setFaction((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), FactionArgument.getFaction(context, "faction"), 0))).then(Commands.m_82129_((String)"resIdx", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandMna.setFaction((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), FactionArgument.getFaction(context, "faction"), IntegerArgumentType.getInteger((CommandContext)context, (String)"resIdx")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tier").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(context -> CommandMna.setTier((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.setTier((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> auraCommands() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"aura").requires(commandSource -> {
            Player player;
            if (ManaAndArtifice.instance.isDebug) {
                return true;
            }
            Entity e = commandSource.m_81373_();
            if (e instanceof Player && (player = (Player)e).m_36316_() != null) {
                return ManaAndArtifice.instance.enabled_auras.contains(player.m_36316_().getId());
            }
            return false;
        })).executes(context -> CommandMna.openMenu((CommandSourceStack)context.getSource()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> raidCommands() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"raid").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"faction", (ArgumentType)new FactionArgument()).executes(context -> CommandMna.factionRaid((CommandSourceStack)context.getSource(), FactionArgument.getFaction(context, "faction"), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.factionRaid((CommandSourceStack)context.getSource(), FactionArgument.getFaction(context, "faction"), EntityArgument.m_91477_((CommandContext)context, (String)"player"), false))).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> CommandMna.factionRaid((CommandSourceStack)context.getSource(), FactionArgument.getFaction(context, "faction"), EntityArgument.m_91477_((CommandContext)context, (String)"player"), BoolArgumentType.getBool((CommandContext)context, (String)"force"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wellspringCommands() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wellspring").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> CommandMna.makeWellspring((CommandSourceStack)context.getSource(), BlockPosArgument.m_118242_((CommandContext)context, (String)"position"))))).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).executes(context -> CommandMna.makeWellspring((CommandSourceStack)context.getSource(), BlockPosArgument.m_118242_((CommandContext)context, (String)"position"), AffinityArgument.getAffinity(context, "affinity")))))).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).then(Commands.m_82129_((String)"strength", (ArgumentType)FloatArgumentType.floatArg((float)5.0f, (float)25.0f)).executes(context -> CommandMna.makeWellspring((CommandSourceStack)context.getSource(), BlockPosArgument.m_118242_((CommandContext)context, (String)"position"), AffinityArgument.getAffinity(context, "affinity"), FloatArgumentType.getFloat((CommandContext)context, (String)"strength")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"power").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> CommandMna.setWellspringPower((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), AffinityArgument.getAffinity(context, "affinity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> CommandMna.addWellspringPower((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), AffinityArgument.getAffinity(context, "affinity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"affinity", (ArgumentType)new AffinityArgument()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> CommandMna.removeWellspringPower((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), AffinityArgument.getAffinity(context, "affinity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> CommandMna.deleteWellspring((CommandSourceStack)context.getSource(), BlockPosArgument.m_118242_((CommandContext)context, (String)"position")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> roteCommands() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rote").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"one").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"identifier", (ArgumentType)new SpellPartArgument()).executes(context -> CommandMna.addRote((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SpellPartArgument.getSpell(context, "identifier")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addRote((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), SpellPartArgument.getSpell(context, "identifier"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"shapes").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.addRote_Shapes((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addRote_Shapes((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"components").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.addRote_SpellEffects((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addRote_SpellEffects((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"modifiers").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.addRote_Modifiers((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addRote_Modifiers((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"all").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.addRote_All((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addRote_All((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.resetRote((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.resetRote((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> masteryCommands() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mastery").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"one").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"identifier", (ArgumentType)new SpellPartArgument()).executes(context -> CommandMna.addMastery((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), SpellPartArgument.getSpell(context, "identifier")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addMastery((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), SpellPartArgument.getSpell(context, "identifier"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"shapes").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.addMastery_Shapes((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addMastery_Shapes((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"components").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.addMastery_SpellEffects((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addMastery_SpellEffects((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"modifiers").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.addMastery_Modifiers((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addMastery_Modifiers((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"all").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.addMastery_All((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.addMastery_All((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CommandMna.resetMastery((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CommandMna.resetMastery((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player")))));
    }

    private static int openMenu(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        player.getCapability(ParticleAuraProvider.AURA).ifPresent(a -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new NamedAuras(), (Consumer)a));
        return 1;
    }

    private static int completeProgression(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            IPlayerProgression progression = (IPlayerProgression)spe.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (progression == null) {
                return 0;
            }
            for (ProgressionCondition condition : ProgressionCondition.get((Level)source.m_81372_(), progression.getTier(), new ArrayList<ResourceLocation>())) {
                progression.addTierProgressionComplete(condition.m_6423_());
            }
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.completeProgression.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.completeProgression.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int resetCodex(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            IPlayerProgression progression = (IPlayerProgression)spe.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (progression == null) {
                return 0;
            }
            progression.resetCodexUnlocks();
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.resetCodex.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.resetCodex.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int resetProgression(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            IPlayerProgression progression = (IPlayerProgression)spe.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            IPlayerRoteSpells rote = (IPlayerRoteSpells)spe.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
            IPlayerMagic magic = (IPlayerMagic)spe.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (progression == null || rote == null || magic == null) {
                return 0;
            }
            progression.setTier(0, (Player)spe);
            progression.setAlliedFaction(null, (Player)spe);
            progression.setAllyCooldown(0);
            progression.setTierProgression(new ArrayList<ResourceLocation>());
            progression.resetCodexUnlocks();
            rote.resetMastery();
            rote.resetRote();
            magic.setMagicLevel((Player)spe, 0);
            magic.setMagicXP(0);
            magic.setCastingResourceType(CastingResourceIDs.MANA);
            for (Affinity aff : Affinity.values()) {
                magic.setAffinityDepth(aff.getShiftAffinity(), 0.0f);
            }
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.fullReset.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.fullReset.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int makeWellspring(CommandSourceStack source, BlockPos position) {
        return CommandMna.makeWellspring(source, position, Affinity.values()[(int)(Math.random() * (double)Affinity.values().length)], (float)(5.0 + Math.random() * 20.0));
    }

    private static int makeWellspring(CommandSourceStack source, BlockPos position, Affinity aff) {
        return CommandMna.makeWellspring(source, position, aff, (float)(5.0 + Math.random() * 20.0));
    }

    private static int makeWellspring(CommandSourceStack source, BlockPos position, Affinity aff, float strength) {
        MutableBoolean success = new MutableBoolean(true);
        source.m_81372_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
            Optional<WellspringNode> existing = m.getWellspringRegistry().getNodeAt(position);
            if (existing.isPresent()) {
                source.m_81352_((Component)Component.m_237115_((String)"mna.commands.wellspring.create.nodeoverlap"));
                success.setFalse();
                return;
            }
            if (!m.getWellspringRegistry().addNode((Level)source.m_81372_(), position, () -> new WellspringNode(aff, strength), true)) {
                source.m_81352_((Component)Component.m_237110_((String)"mna.commands.wellspring.create.failed", (Object[])new Object[]{position.m_123344_()}));
                success.setFalse();
                return;
            }
        });
        if (success.booleanValue()) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspring.create.success", (Object[])new Object[]{aff.name(), position.toString()}), true);
        }
        return 0;
    }

    private static int deleteWellspring(CommandSourceStack source, BlockPos position) {
        MutableBoolean success = new MutableBoolean(true);
        source.m_81372_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> success.setValue(m.getWellspringRegistry().deleteNodeAt(position)));
        if (success.booleanValue()) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspring.delete.success", (Object[])new Object[]{position.toString()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspring.delete.failed", (Object[])new Object[]{position.toString()}), true);
        }
        return 0;
    }

    private static int addRote(CommandSourceStack source, Collection<ServerPlayer> players, ISpellComponent component) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> r.addRoteXP(null, component, component.requiredXPForRote()));
        }
        MutableComponent comp = Component.m_237115_((String)component.getRegistryName().toString());
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.success", (Object[])new Object[]{comp.getString(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.success", (Object[])new Object[]{comp.getString(), players.size()}), true);
        }
        return 1;
    }

    private static int addRote_Shapes(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> Registries.Shape.get().getValues().forEach(s -> r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote())));
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.shapes.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.shapes.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int addRote_SpellEffects(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> Registries.SpellEffect.get().getValues().forEach(s -> r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote())));
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.components.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.components.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int addRote_Modifiers(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> Registries.Modifier.get().getValues().forEach(s -> r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote())));
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.modifiers.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.modifiers.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int addRote_All(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
                Registries.Shape.get().getValues().forEach(s -> r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote()));
                Registries.SpellEffect.get().getValues().forEach(s -> r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote()));
                Registries.Modifier.get().getValues().forEach(s -> r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote()));
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.all.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.all.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int resetRote(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> r.resetRote());
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.reset.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.rote.reset.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int addMastery(CommandSourceStack source, Collection<ServerPlayer> players, ISpellComponent component) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> r.addMastery(null, component, 0.5f));
        }
        MutableComponent comp = Component.m_237115_((String)component.getRegistryName().toString());
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.success", (Object[])new Object[]{comp.getString(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.success", (Object[])new Object[]{comp.getString(), players.size()}), true);
        }
        return 1;
    }

    private static int addMastery_Shapes(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> Registries.Shape.get().getValues().forEach(s -> r.addMastery(null, (ISpellComponent)s, 0.5f)));
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.shapes.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.shapes.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int addMastery_SpellEffects(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> Registries.SpellEffect.get().getValues().forEach(s -> r.addMastery(null, (ISpellComponent)s, 0.5f)));
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.components.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.components.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int addMastery_Modifiers(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> Registries.Modifier.get().getValues().forEach(s -> r.addMastery(null, (ISpellComponent)s, 0.5f)));
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.modifiers.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.modifiers.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int addMastery_All(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
                Registries.Shape.get().getValues().forEach(s -> r.addMastery(null, (ISpellComponent)s, 0.5f));
                Registries.SpellEffect.get().getValues().forEach(s -> r.addMastery(null, (ISpellComponent)s, 0.5f));
                Registries.Modifier.get().getValues().forEach(s -> r.addMastery(null, (ISpellComponent)s, 0.5f));
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.all.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.all.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int resetMastery(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> r.resetMastery());
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.reset.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.mastery.reset.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int factionRaid(CommandSourceStack source, ResourceLocation factionID, Collection<ServerPlayer> players, boolean force) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            IPlayerProgression progression = (IPlayerProgression)spe.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (progression == null) {
                return 0;
            }
            if (!force && progression.getTier() < 3) {
                return 0;
            }
            IFaction faction = (IFaction)Registries.Factions.get().getValue(factionID);
            if (faction == null) {
                return 0;
            }
            if (force) {
                progression.raidImmediate(faction);
                continue;
            }
            progression.setRaidChance(faction, 1.0);
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.factionRaid.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.factionRaid.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }

    private static int setWellspringPower(CommandSourceStack source, Collection<ServerPlayer> players, Affinity aff, int level) {
        source.m_81372_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> players.forEach(player -> m.getWellspringRegistry().setWellspringPower((ServerPlayer)player, aff, level)));
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspringpower.set.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_(), aff.name(), level}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspringpower.set.success", (Object[])new Object[]{players.size(), aff.name(), level}), true);
        }
        return 1;
    }

    private static int addWellspringPower(CommandSourceStack source, Collection<ServerPlayer> players, Affinity aff, int amount) {
        source.m_81372_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> players.forEach(player -> {
            if (player.m_36316_() != null && player.m_36316_().getId() != null) {
                m.getWellspringRegistry().insertPower(player.m_36316_().getId(), player.m_9236_(), aff, amount);
            }
        }));
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspringpower.add.success", (Object[])new Object[]{amount, aff.name(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspringpower.add.success", (Object[])new Object[]{amount, aff.name(), players.size()}), true);
        }
        return 1;
    }

    private static int removeWellspringPower(CommandSourceStack source, Collection<ServerPlayer> players, Affinity aff, int amount) {
        source.m_81372_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> players.forEach(player -> {
            if (player.m_36316_() != null && player.m_36316_().getId() != null) {
                m.getWellspringRegistry().consumePower(player.m_36316_().getId(), player.m_9236_(), aff, amount);
            }
        }));
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspringpower.remove.success", (Object[])new Object[]{amount, aff.name(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.wellspringpower.remove.success", (Object[])new Object[]{amount, aff.name(), players.size()}), true);
        }
        return 1;
    }

    private static int setTier(CommandSourceStack source, Collection<ServerPlayer> players, int tier) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> progression.setTier(tier, (Player)spe));
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.tier.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_(), tier}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.tier.success", (Object[])new Object[]{players.size(), tier}), true);
        }
        return 1;
    }

    private static int setFaction(CommandSourceStack source, Collection<ServerPlayer> players, ResourceLocation factionID, int castingResourceIndex) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        IFaction faction = (IFaction)Registries.Factions.get().getValue(factionID);
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> progression.setAlliedFaction(faction, (Player)spe));
            if (faction == null) continue;
            spe.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                int loopedIndex = castingResourceIndex % faction.getCastingResources().length;
                magic.setCastingResourceType(faction.getCastingResources()[loopedIndex]);
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.faction.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_(), factionID}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.faction.success", (Object[])new Object[]{players.size(), factionID}), true);
        }
        return 1;
    }

    private static int setMagicLevel(CommandSourceStack source, Collection<ServerPlayer> players, int magicLevel) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                magic.setMagicLevel((Player)spe, magicLevel);
                magic.setMagicXP(magic.getXPForLevel(magicLevel));
                magic.getCastingResource().setAmount(magic.getCastingResource().getMaxAmount());
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.magicLevel.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_(), magicLevel}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.magicLevel.success", (Object[])new Object[]{players.size(), magicLevel}), true);
        }
        return 1;
    }

    private static int setAffinity(CommandSourceStack source, Collection<ServerPlayer> players, Affinity aff, float amount) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                magic.setAffinityDepth(aff.getShiftAffinity(), amount);
                magic.forceSync();
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.set.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_(), aff, Float.valueOf(amount)}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.set.success", (Object[])new Object[]{players.size(), aff, Float.valueOf(amount)}), true);
        }
        return 1;
    }

    private static int addAffinity(CommandSourceStack source, Collection<ServerPlayer> players, Affinity aff, float amount) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                magic.setAffinityDepth(aff.getShiftAffinity(), magic.getAffinityDepth(aff.getShiftAffinity()) + amount);
                magic.forceSync();
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.add.success", (Object[])new Object[]{Float.valueOf(amount), aff, ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.add.success", (Object[])new Object[]{Float.valueOf(amount), aff, players.size()}), true);
        }
        return 1;
    }

    private static int removeAffinity(CommandSourceStack source, Collection<ServerPlayer> players, Affinity aff, float amount) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                magic.setAffinityDepth(aff.getShiftAffinity(), magic.getAffinityDepth(aff.getShiftAffinity()) - amount);
                magic.forceSync();
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.remove.success", (Object[])new Object[]{Float.valueOf(amount), aff, ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.remove.success", (Object[])new Object[]{Float.valueOf(amount), aff, players.size()}), true);
        }
        return 1;
    }

    private static int resetAffinity(CommandSourceStack source, Collection<ServerPlayer> players, Affinity aff) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                magic.setAffinityDepth(aff.getShiftAffinity(), 0.0f);
                magic.forceSync();
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.reset.success", (Object[])new Object[]{aff, ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.reset.success", (Object[])new Object[]{aff, players.size()}), true);
        }
        return 1;
    }

    private static int resetAllAffinity(CommandSourceStack source, Collection<ServerPlayer> players) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayer spe : players) {
            spe.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                for (Affinity aff : Affinity.values()) {
                    magic.setAffinityDepth(aff.getShiftAffinity(), 0.0f);
                }
                magic.forceSync();
            });
        }
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.reset_all.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"mna.commands.affinity.reset_all.success", (Object[])new Object[]{players.size()}), true);
        }
        return 1;
    }
}

