/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.playerdata.rote;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpells;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerRoteSpellsProvider
implements ICapabilitySerializable<Tag> {
    final String KEY_ROTE_SPELL_DATA = "rote_spell_data";
    final String KEY_MASTERY_SPELL_DATA = "mastery_spell_data";
    final String KEY_ID = "id";
    final String KEY_XP = "xp";
    final String KEY_MASTERY = "mastery";
    public static final Capability<IPlayerRoteSpells> ROTE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerRoteSpells>(){});
    private final LazyOptional<IPlayerRoteSpells> holder = LazyOptional.of(PlayerRoteSpells::new);

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return ROTE.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        CompoundTag entryData;
        IPlayerRoteSpells instance = (IPlayerRoteSpells)this.holder.orElse(null);
        CompoundTag nbt = new CompoundTag();
        ListTag roteData = new ListTag();
        ListTag masteryData = new ListTag();
        for (Map.Entry<ISpellComponent, Float> entry : instance.getRoteData().entrySet()) {
            entryData = new CompoundTag();
            entryData.m_128359_("id", entry.getKey().getRegistryName().toString());
            entryData.m_128350_("xp", entry.getValue().floatValue());
            roteData.add((Object)entryData);
        }
        for (Map.Entry<ISpellComponent, Float> entry : instance.getMasteryData().entrySet()) {
            entryData = new CompoundTag();
            entryData.m_128359_("id", entry.getKey().getRegistryName().toString());
            entryData.m_128350_("mastery", entry.getValue().floatValue());
            masteryData.add((Object)entryData);
        }
        nbt.m_128365_("rote_spell_data", (Tag)roteData);
        nbt.m_128365_("mastery_spell_data", (Tag)masteryData);
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        IPlayerRoteSpells instance = (IPlayerRoteSpells)this.holder.orElse(null);
        if (nbt instanceof CompoundTag) {
            CompoundTag entryData;
            CompoundTag cnbt = (CompoundTag)nbt;
            if (cnbt.m_128441_("rote_spell_data")) {
                ListTag roteData = cnbt.m_128437_("rote_spell_data", 10);
                for (Tag entryINBT : roteData) {
                    if (!(entryINBT instanceof CompoundTag) || !(entryData = (CompoundTag)entryINBT).m_128441_("id") || !entryData.m_128441_("xp")) continue;
                    instance.setRoteXP(new ResourceLocation(entryData.m_128461_("id")), entryData.m_128457_("xp"));
                }
            }
            if (cnbt.m_128441_("mastery_spell_data")) {
                ListTag masteryData = cnbt.m_128437_("mastery_spell_data", 10);
                for (Tag entryINBT : masteryData) {
                    if (!(entryINBT instanceof CompoundTag) || !(entryData = (CompoundTag)entryINBT).m_128441_("id") || !entryData.m_128441_("mastery")) continue;
                    instance.setMastery(new ResourceLocation(entryData.m_128461_("id")), entryData.m_128457_("mastery"));
                }
            }
        } else {
            ManaAndArtifice.LOGGER.error("Rote Spell NBT passed back not an instance of CompoundNBT - save data was NOT loaded!");
        }
    }
}

