/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.playerdata.magic.resources;

import com.mna.api.capabilities.resource.CastingResourceIDs;
import com.mna.api.capabilities.resource.ICastingResourceGuiProvider;
import com.mna.api.capabilities.resource.ICastingResourceGuiRegistry;
import com.mna.capabilities.playerdata.magic.resources.CastingResourceRegistry;
import com.mna.gui.GuiTextures;
import com.mna.items.ItemInit;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CastingResourceGuiRegistry
implements ICastingResourceGuiRegistry {
    private HashMap<ResourceLocation, ICastingResourceGuiProvider> _guiProviders = new HashMap();
    public static final CastingResourceGuiRegistry Instance;
    private static final Supplier<ItemStack> HUD_BRIMSTONE_COLD;
    private static final Supplier<ItemStack> HUD_BRIMSTONE_WARM;
    private static final Supplier<ItemStack> HUD_BRIMSTONE_HOT;
    private static final Supplier<ItemStack> HUD_COUNCIL;
    private static final Supplier<ItemStack> HUD_FEY_SUMMER;
    private static final Supplier<ItemStack> HUD_FEY_WINTER;
    private static final Supplier<ItemStack> HUD_UNDEAD;

    public void registerDefaults() {
        Instance.registerResourceGui(CastingResourceIDs.MANA, new ICastingResourceGuiProvider(){

            @Override
            public ResourceLocation getTexture() {
                return GuiTextures.Hud.BARS;
            }

            @Override
            public int getXPBarColor() {
                return -12039016;
            }

            @Override
            public int getBarColor() {
                return -7504641;
            }

            @Override
            public int getBarManaCostEstimateColor() {
                return -13357731;
            }

            @Override
            public int getResourceNumericTextColor() {
                return -5394;
            }

            @Override
            public int getBadgeSize() {
                return 64;
            }

            @Override
            public int getFrameU() {
                return 0;
            }

            @Override
            public int getFrameV() {
                return 0;
            }

            @Override
            public int getFrameWidth() {
                return 153;
            }

            @Override
            public int getFrameHeight() {
                return 24;
            }

            @Override
            public int getLevelDisplayY() {
                return this.getFrameHeight() - 6;
            }
        });
        Instance.registerResourceGui(CastingResourceIDs.COUNCIL_MANA, new ICastingResourceGuiProvider(){

            @Override
            public ResourceLocation getTexture() {
                return GuiTextures.Hud.BARS;
            }

            @Override
            public int getXPBarColor() {
                return -12039016;
            }

            @Override
            public int getBarColor() {
                return -7504641;
            }

            @Override
            public int getBarManaCostEstimateColor() {
                return -13357731;
            }

            @Override
            public int getResourceNumericTextColor() {
                return -5394;
            }

            @Override
            public int getBadgeSize() {
                return 64;
            }

            @Override
            public int getFrameU() {
                return 0;
            }

            @Override
            public int getFrameV() {
                return 24;
            }

            @Override
            public int getFrameWidth() {
                return 153;
            }

            @Override
            public int getFrameHeight() {
                return 24;
            }

            @Override
            public ItemStack getBadgeItem() {
                return HUD_COUNCIL.get();
            }

            @Override
            public int getBadgeItemOffsetY() {
                return 10;
            }

            @Override
            public int getLevelDisplayY() {
                return this.getFrameHeight() - 2;
            }
        });
        Instance.registerResourceGui(CastingResourceIDs.SOULS, new ICastingResourceGuiProvider(){

            @Override
            public ResourceLocation getTexture() {
                return GuiTextures.Hud.BARS;
            }

            @Override
            public int getXPBarColor() {
                return -9666636;
            }

            @Override
            public int getBarColor() {
                return -12497052;
            }

            @Override
            public int getBarManaCostEstimateColor() {
                return -12929864;
            }

            @Override
            public int getResourceNumericTextColor() {
                return -1909793;
            }

            @Override
            public int getBadgeSize() {
                return 64;
            }

            @Override
            public int getFrameU() {
                return 0;
            }

            @Override
            public int getFrameV() {
                return 169;
            }

            @Override
            public int getFrameWidth() {
                return 153;
            }

            @Override
            public int getFrameHeight() {
                return 26;
            }

            @Override
            public ItemStack getBadgeItem() {
                return HUD_UNDEAD.get();
            }

            @Override
            public int getBadgeItemOffsetY() {
                return 13;
            }

            @Override
            public int getXPBarOffsetY() {
                return 18;
            }

            @Override
            public int getFillStartY() {
                return 8;
            }

            @Override
            public int getResourceNumericOffsetY() {
                return 11;
            }

            @Override
            public int getLevelDisplayY() {
                return this.getFrameHeight() - 2;
            }

            @Override
            public int getLowChargeOffsetY() {
                return 0;
            }
        });
        Instance.registerResourceGui(CastingResourceIDs.BRIMSTONE, new ICastingResourceGuiProvider(){

            @Override
            public ResourceLocation getTexture() {
                return GuiTextures.Hud.BARS;
            }

            @Override
            public int getXPBarColor() {
                return FastColor.ARGB32.m_13660_((int)255, (int)128, (int)32, (int)32);
            }

            @Override
            public int getBarColor() {
                return -3917309;
            }

            @Override
            public int getBarManaCostEstimateColor() {
                return FastColor.ARGB32.m_13660_((int)255, (int)245, (int)126, (int)32);
            }

            @Override
            public int getResourceNumericTextColor() {
                return -2927;
            }

            @Override
            public int getBadgeSize() {
                return 64;
            }

            @Override
            public int getFrameU() {
                return 0;
            }

            @Override
            public int getFrameV() {
                Minecraft mc = Minecraft.m_91087_();
                Holder biome = mc.f_91073_.m_204166_(mc.f_91074_.m_20183_());
                if (((Biome)biome.get()).m_198904_(mc.f_91074_.m_20183_())) {
                    return 96;
                }
                if (biome.m_203656_(BiomeTags.f_263828_)) {
                    return 144;
                }
                return 120;
            }

            @Override
            public int getFrameWidth() {
                return 153;
            }

            @Override
            public int getFrameHeight() {
                return 24;
            }

            @Override
            public ItemStack getBadgeItem() {
                Minecraft mc = Minecraft.m_91087_();
                Holder biome = mc.f_91073_.m_204166_(mc.f_91074_.m_20183_());
                if (((Biome)biome.get()).m_198904_(mc.f_91074_.m_20183_())) {
                    return HUD_BRIMSTONE_COLD.get();
                }
                if (biome.m_203656_(BiomeTags.f_263828_)) {
                    return HUD_BRIMSTONE_HOT.get();
                }
                return HUD_BRIMSTONE_WARM.get();
            }

            @Override
            public int getBadgeItemOffsetY() {
                Minecraft mc = Minecraft.m_91087_();
                Biome biome = (Biome)mc.f_91073_.m_204166_(mc.f_91074_.m_20183_()).m_203334_();
                if (biome.m_198904_(mc.f_91074_.m_20183_())) {
                    return 11;
                }
                return ICastingResourceGuiProvider.super.getBadgeItemOffsetY();
            }
        });
        Instance.registerResourceGui(CastingResourceIDs.SUMMER_FIRE, new ICastingResourceGuiProvider(){

            @Override
            public ResourceLocation getTexture() {
                return GuiTextures.Hud.BARS;
            }

            @Override
            public int getXPBarColor() {
                return -10833371;
            }

            @Override
            public int getBarColor() {
                return -1405640;
            }

            @Override
            public int getBarManaCostEstimateColor() {
                return -8896481;
            }

            @Override
            public int getResourceNumericTextColor() {
                return 16711634;
            }

            @Override
            public int getBadgeSize() {
                return 64;
            }

            @Override
            public int getFrameU() {
                return 0;
            }

            @Override
            public int getFrameWidth() {
                return 153;
            }

            @Override
            public int getFrameHeight() {
                return 24;
            }

            @Override
            public int getFrameV() {
                return 48;
            }

            @Override
            public ItemStack getBadgeItem() {
                return HUD_FEY_SUMMER.get();
            }

            @Override
            public int getBadgeItemOffsetY() {
                return 9;
            }

            @Override
            public int getFillWidth() {
                return 127;
            }

            @Override
            public int getLevelDisplayY() {
                return this.getFrameHeight() - 3;
            }
        });
        Instance.registerResourceGui(CastingResourceIDs.WINTER_ICE, new ICastingResourceGuiProvider(){

            @Override
            public ResourceLocation getTexture() {
                return GuiTextures.Hud.BARS;
            }

            @Override
            public int getXPBarColor() {
                return -10390889;
            }

            @Override
            public int getBarColor() {
                return -4924696;
            }

            @Override
            public int getBarManaCostEstimateColor() {
                return -8482116;
            }

            @Override
            public int getResourceNumericTextColor() {
                return -14667956;
            }

            @Override
            public int getBadgeSize() {
                return 64;
            }

            @Override
            public int getFrameU() {
                return 0;
            }

            @Override
            public int getFrameWidth() {
                return 153;
            }

            @Override
            public int getFrameHeight() {
                return 24;
            }

            @Override
            public int getFrameV() {
                return 72;
            }

            @Override
            public ItemStack getBadgeItem() {
                return HUD_FEY_WINTER.get();
            }

            @Override
            public int getBadgeItemOffsetY() {
                return 9;
            }

            @Override
            public int getFillWidth() {
                return 127;
            }

            @Override
            public int getLevelDisplayY() {
                return this.getFrameHeight() - 1;
            }
        });
    }

    @Override
    public void registerResourceGui(ResourceLocation identifier, ICastingResourceGuiProvider guiProvider) {
        if (identifier == null) {
            return;
        }
        if (this._guiProviders.containsKey(identifier)) {
            throw new InvalidParameterException("The Casting Resource Identifier " + identifier.toString() + " is already in use.");
        }
        if (CastingResourceRegistry.Instance.getRegisteredClass(identifier) == null) {
            throw new InvalidParameterException("The Casting Resource Identifier " + identifier.toString() + " was not registered in the CastingResourceRegistrationEvent event.  Subscribe to this and map the resource to a class.");
        }
        this._guiProviders.put(identifier, guiProvider);
    }

    public ICastingResourceGuiProvider getGuiProvider(ResourceLocation key) {
        return this._guiProviders.getOrDefault(key, this._guiProviders.get(CastingResourceIDs.MANA));
    }

    static {
        HUD_BRIMSTONE_COLD = () -> new ItemStack((ItemLike)ItemInit.MOTE_FIRE.get());
        HUD_BRIMSTONE_WARM = () -> new ItemStack((ItemLike)ItemInit.GREATER_MOTE_FIRE.get());
        HUD_BRIMSTONE_HOT = () -> new ItemStack((ItemLike)ItemInit.GREATER_MOTE_HELLFIRE.get());
        HUD_COUNCIL = () -> new ItemStack((ItemLike)ItemInit.COUNCIL_HUD_BADGE.get());
        HUD_FEY_SUMMER = () -> new ItemStack((ItemLike)ItemInit.FEY_SUMMER_HUD_BADGE.get());
        HUD_FEY_WINTER = () -> new ItemStack((ItemLike)ItemInit.FEY_WINTER_HUD_BADGE.get());
        HUD_UNDEAD = () -> new ItemStack((ItemLike)ItemInit.UNDEAD_HUD_BADGE.get());
        Instance = new CastingResourceGuiRegistry();
    }
}

