/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.playerdata.magic;

import com.mna.api.cantrips.ICantrip;
import com.mna.api.capabilities.IPlayerCantrip;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PlayerCantrip
implements IPlayerCantrip {
    private ResourceLocation cantripID;
    private ItemStack stack;
    private boolean itemLocked = false;
    private ArrayList<ResourceLocation> combination;

    public PlayerCantrip(ICantrip cantrip) {
        this.cantripID = cantrip.getId();
        this.combination = new ArrayList();
        this.stack = cantrip.getDefaultStack();
        this.itemLocked = cantrip.isStackLocked();
        cantrip.getDefaultCombination().forEach(r -> this.combination.add((ResourceLocation)r));
    }

    @Override
    public ResourceLocation getCantripID() {
        return this.cantripID;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        if (!this.stack.m_41619_()) {
            CompoundTag item = new CompoundTag();
            this.stack.m_41739_(item);
            nbt.m_128365_("item", (Tag)item);
        }
        nbt.m_128405_("count", this.combination.size());
        for (int i = 0; i < this.combination.size(); ++i) {
            nbt.m_128359_("" + i, this.combination.get(i).toString());
        }
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("item") && !this.itemLocked) {
            this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item"));
        }
        this.combination.clear();
        if (nbt.m_128441_("count")) {
            int count = nbt.m_128451_("count");
            for (int i = 0; i < count; ++i) {
                ResourceLocation rLoc = new ResourceLocation(nbt.m_128461_("" + i));
                this.combination.add(rLoc);
            }
        }
    }

    @Override
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ResourceLocation getPattern(int index) {
        if (index < 0 || index >= this.combination.size()) {
            return null;
        }
        return this.combination.get(index);
    }

    @Override
    public void setPatterns(List<ResourceLocation> manaweavingPatterns) {
        this.combination.clear();
        this.combination.addAll(manaweavingPatterns);
    }

    @Override
    public boolean matches(List<ManaweavingPattern> patterns) {
        if (patterns.size() != this.combination.size()) {
            return false;
        }
        for (int i = 0; i < this.combination.size(); ++i) {
            if (patterns.get(i).m_6423_().equals((Object)this.combination.get(i))) continue;
            return false;
        }
        return true;
    }
}

