/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.chunkdata;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IChunkMagic;
import com.mna.capabilities.chunkdata.ChunkMagic;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChunkMagicProvider
implements ICapabilitySerializable<Tag> {
    private static final String KEY_RESIDUAL_MAGIC = "residualMagic";
    private static final String KEY_ELDRIN_POSITIONS = "knownEldrinPositions";
    private static final String KEY_WARD_DATA = "wardData";
    public static final Capability<IChunkMagic> MAGIC = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkMagic>(){});
    private final LazyOptional<IChunkMagic> holder = LazyOptional.of(ChunkMagic::new);

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return MAGIC.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        IChunkMagic resolved = (IChunkMagic)this.holder.resolve().get();
        nbt.m_128350_(KEY_RESIDUAL_MAGIC, resolved.getResidualMagic());
        ListTag positions = new ListTag();
        resolved.getKnownEldrinSuppliers().forEach(pos -> positions.add((Object)LongTag.m_128882_((long)pos)));
        nbt.m_128365_(KEY_ELDRIN_POSITIONS, (Tag)positions);
        ListTag wards = new ListTag();
        resolved.getWards().forEach((l, p) -> {
            CompoundTag wardTag = new CompoundTag();
            wardTag.m_128356_("l", l.longValue());
            wardTag.m_128362_("u", (UUID)p.getFirst());
            if (p.getSecond() != null) {
                wardTag.m_128359_("k", ((ResourceLocation)p.getSecond()).toString());
            }
            wards.add((Object)wardTag);
        });
        nbt.m_128365_(KEY_WARD_DATA, (Tag)wards);
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            IChunkMagic resolved = (IChunkMagic)this.holder.resolve().get();
            CompoundTag cnbt = (CompoundTag)nbt;
            if (cnbt.m_128441_(KEY_RESIDUAL_MAGIC)) {
                resolved.setResidualMagic(((CompoundTag)nbt).m_128457_(KEY_RESIDUAL_MAGIC));
            }
            if (cnbt.m_128425_(KEY_ELDRIN_POSITIONS, 9)) {
                ListTag positions = cnbt.m_128437_(KEY_ELDRIN_POSITIONS, 4);
                positions.forEach(pos -> resolved.pushKnownEldrinSupplier(BlockPos.m_122022_((long)((LongTag)pos).m_7046_())));
            }
            if (cnbt.m_128425_(KEY_WARD_DATA, 9)) {
                ListTag wards = cnbt.m_128437_(KEY_WARD_DATA, 10);
                HashMap<Long, Pair<UUID, ResourceLocation>> wardData = new HashMap<Long, Pair<UUID, ResourceLocation>>();
                wards.forEach(tag -> {
                    CompoundTag cTag = (CompoundTag)tag;
                    if (cTag.m_128425_("l", 4) && cTag.m_128425_("u", 11)) {
                        if (cTag.m_128425_("k", 8)) {
                            wardData.put(cTag.m_128454_("l"), new Pair((Object)cTag.m_128342_("u"), (Object)new ResourceLocation(cTag.m_128461_("k"))));
                        } else {
                            wardData.put(cTag.m_128454_("l"), new Pair((Object)cTag.m_128342_("u"), null));
                        }
                    }
                });
                resolved.setWards(wardData);
            }
        } else {
            ManaAndArtifice.LOGGER.error("Chunk capability data NBT passed back not an instance of CompoundNBT - save data was NOT loaded!");
        }
    }
}

