/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.chunkdata;

import com.mna.api.capabilities.IChunkMagic;
import com.mna.tools.BlockUtils;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.registries.ForgeRegistries;

public class ChunkMagic
implements IChunkMagic {
    private float residualMagic = 0.0f;
    private HashSet<Long> knownSuppliers = new HashSet();
    private HashMap<Long, Pair<UUID, ResourceLocation>> wards = new HashMap();

    @Override
    public void addResidualMagic(float amount) {
        this.residualMagic += amount;
    }

    @Override
    public void removeResidualMagic(float amount) {
        this.residualMagic -= amount;
        if (this.residualMagic < 0.0f) {
            this.residualMagic = 0.0f;
        }
    }

    @Override
    public float getResidualMagic() {
        return this.residualMagic;
    }

    @Override
    public void setResidualMagic(float amount) {
        this.residualMagic = amount;
    }

    @Override
    public void pushKnownEldrinSupplier(BlockPos pos) {
        this.knownSuppliers.add(pos.m_121878_());
    }

    @Override
    public void popKnownEldrinSupplier(BlockPos pos) {
        this.knownSuppliers.remove(pos.m_121878_());
    }

    @Override
    public List<Long> getKnownEldrinSuppliers() {
        return this.knownSuppliers.stream().collect(Collectors.toList());
    }

    @Override
    public boolean blockInteractionFor(BlockPos pos, @Nullable Player player) {
        Pair ownershipData = this.wards.getOrDefault(pos.m_121878_(), null);
        if (ownershipData == null) {
            return false;
        }
        if (player == null) {
            return true;
        }
        if (((UUID)ownershipData.getFirst()).equals(player.m_36316_().getId())) {
            return false;
        }
        if (ownershipData.getSecond() == null) {
            return true;
        }
        ResourceLocation mhStackType = ForgeRegistries.ITEMS.getKey((Object)player.m_21205_().m_41720_());
        ResourceLocation ohStackType = ForgeRegistries.ITEMS.getKey((Object)player.m_21206_().m_41720_());
        return !((ResourceLocation)ownershipData.getSecond()).equals((Object)mhStackType) && !((ResourceLocation)ownershipData.getSecond()).equals((Object)ohStackType);
    }

    @Override
    public boolean wardBlock(BlockPos pos, Player warder, ItemStack wardStack) {
        if (!BlockUtils.canDestroyBlock((LivingEntity)warder, warder.m_9236_(), pos, (Tier)Tiers.NETHERITE)) {
            return false;
        }
        if (this.blockInteractionFor(pos, warder)) {
            return false;
        }
        long posKey = pos.m_121878_();
        if (this.wards.containsKey(posKey)) {
            return false;
        }
        ResourceLocation wardStackType = wardStack.m_41619_() ? null : ForgeRegistries.ITEMS.getKey((Object)wardStack.m_41720_());
        this.wards.put(posKey, (Pair<UUID, ResourceLocation>)new Pair((Object)warder.m_36316_().getId(), (Object)wardStackType));
        warder.m_9236_().m_46865_(pos).m_8092_(true);
        return true;
    }

    @Override
    public boolean removeBlockWard(BlockPos pos, Player warder) {
        if (this.blockInteractionFor(pos, warder)) {
            return false;
        }
        long posKey = pos.m_121878_();
        if (this.wards.containsKey(posKey)) {
            this.wards.remove(posKey);
            warder.m_9236_().m_46865_(pos).m_8092_(true);
            return true;
        }
        return false;
    }

    @Override
    public void removeBlockWard(BlockPos pos) {
        this.wards.remove(pos.m_121878_());
    }

    @Override
    public HashMap<Long, Pair<UUID, ResourceLocation>> getWards() {
        return this.wards;
    }

    @Override
    public void setWards(HashMap<Long, Pair<UUID, ResourceLocation>> wardData) {
        this.wards = wardData;
    }

    @Override
    public boolean isWarded(long blockPos) {
        return this.wards.containsKey(blockPos);
    }
}

