/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.utility;

import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.api.tools.MATags;
import com.mna.api.tools.RLoc;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;

public class CloudBlock
extends Block
implements IDontCreateBlockItem {
    public static final float WATER_CAULDRON_FILL_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;

    public CloudBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_278166_(PushReaction.DESTROY).m_60910_().m_60955_().m_60977_());
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        Vec3 drop = Vec3.m_82539_((Vec3i)pPos).m_82520_(-0.5 + Math.random(), 0.0, -0.5 + Math.random());
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123803_, drop.f_82479_, drop.f_82480_, drop.f_82481_, 0.0, 0.0, 0.0);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        Pair<BlockState, BlockPos> below = this.getNonAirBlockBelow(pPos, pLevel);
        if (below != null) {
            boolean valid;
            BlockState belowState = (BlockState)below.getFirst();
            BlockPos belowPos = (BlockPos)below.getSecond();
            if (belowState.m_60734_() == Blocks.f_50256_) {
                if (pRandom.m_188501_() <= 0.17578125f) {
                    pLevel.m_7731_(belowPos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1)), 3);
                }
                return;
            }
            if (belowState.m_60734_() == Blocks.f_152476_) {
                int existingFillLevel = (Integer)belowState.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                if (existingFillLevel < 3 && pRandom.m_188501_() <= 1.0f) {
                    pLevel.m_7731_(belowPos, (BlockState)belowState.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(existingFillLevel + 1)), 3);
                }
                return;
            }
            boolean no_age = MATags.isBlockIn(belowState.m_60734_(), RLoc.create("construct_harvestables_no_age"));
            boolean bl = valid = no_age || MATags.isBlockIn(belowState.m_60734_(), RLoc.create("construct_harvestables"));
            if (valid) {
                if (belowState.m_60734_().m_6724_(belowState)) {
                    belowState.m_60734_().m_213898_(belowState, pLevel, belowPos, pRandom);
                }
                pLevel.m_186460_(belowPos, belowState.m_60734_(), 1);
            }
        }
    }

    @Nullable
    private Pair<BlockState, BlockPos> getNonAirBlockBelow(BlockPos pPos, ServerLevel pLevel) {
        int count = 0;
        BlockPos pos = pPos.m_7495_();
        BlockState belowState = pLevel.m_8055_(pos);
        while (count++ < 5 && belowState.m_60795_()) {
            pos = pos.m_7495_();
            belowState = pLevel.m_8055_(pos);
        }
        return belowState.m_60795_() ? null : new Pair((Object)belowState, (Object)pos);
    }
}

