/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.IPowerRequestStatus;
import com.mna.api.blocks.tile.PowerStatus;
import com.mna.api.blocks.tile.TileEntityWithInventory;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class WizardLabTile
extends TileEntityWithInventory
implements GeoBlockEntity,
IPowerRequestStatus {
    private boolean active;
    private int stateFlags;
    private UUID crafterID;
    private Player crafterReference;
    private boolean tickContinuing;
    private int activeTicks;
    private boolean syncToggle;
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WizardLabTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public static <T extends WizardLabTile> void Tick(Level level, BlockPos pos, BlockState state, T tile) {
        tile.tick();
    }

    protected void tick() {
        if (this.active) {
            if (!this.m_58904_().m_5776_()) {
                if (!this.canContinue()) {
                    this.setInactive();
                    return;
                }
                if (this.canActiveTick()) {
                    if (!this.tickContinuing) {
                        this.tickContinuing = true;
                        this.syncAndSave();
                    }
                    this.tickActiveLogic();
                    ++this.activeTicks;
                    if (this.getPctComplete() >= 1.0f) {
                        this.onComplete();
                        if (this.getPctComplete() >= 1.0f) {
                            this.setInactive();
                        }
                    }
                } else if (this.tickContinuing) {
                    this.tickContinuing = false;
                    this.syncAndSave();
                }
                if (this.m_58904_().m_46467_() % 20L == 0L) {
                    this.syncAndSave();
                }
            } else if (this.tickContinuing) {
                ++this.activeTicks;
                if (this.getPctComplete() >= 1.0f) {
                    this.onComplete();
                    if (this.getPctComplete() >= 1.0f) {
                        this.setInactive();
                    }
                }
            }
        }
    }

    protected boolean canActiveTick() {
        return true;
    }

    protected abstract boolean canContinue();

    public abstract float getPctComplete();

    protected void onComplete() {
    }

    public HashMap<Affinity, PowerStatus> powerRequirementStatus() {
        return new HashMap<Affinity, PowerStatus>();
    }

    protected void onCraftStart(Player crafter) {
    }

    public int getXPCost(Player crafter) {
        return 0;
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return null;
    }

    protected final int getActiveTicks() {
        return this.activeTicks;
    }

    @Nullable
    public final Player getCrafter() {
        if (this.crafterReference == null && this.crafterID != null) {
            this.crafterReference = this.f_58857_.m_46003_(this.crafterID);
        }
        return this.crafterReference;
    }

    @Nullable
    public final UUID getCrafterID() {
        return this.crafterID;
    }

    protected void tickActiveLogic() {
    }

    protected boolean needsPower() {
        return true;
    }

    protected abstract boolean canActivate(Player var1);

    public boolean canStart(Player player) {
        if (this.isActive()) {
            return false;
        }
        if (player.f_36079_ < this.getXPCost(player) && !player.m_7500_()) {
            return false;
        }
        return this.canActivate(player);
    }

    public final boolean isActive() {
        return this.active;
    }

    public final boolean setActive(Player crafter) {
        if (crafter.m_36316_() == null || crafter.m_36316_().getId() == null) {
            return false;
        }
        if (!this.canActivate(crafter)) {
            return false;
        }
        if (!this.m_58904_().m_5776_()) {
            this.active = true;
            this.tickContinuing = true;
            this.activeTicks = 0;
            this.crafterReference = crafter;
            this.crafterID = crafter.m_36316_().getId();
            crafter.m_6756_(-this.getXPCost(crafter));
            this.onCraftStart(crafter);
            this.syncAndSave();
        }
        return true;
    }

    protected boolean shouldLoopingSoundPlay(String ID) {
        return this.isActive() && this.f_58857_.m_7702_(this.f_58858_) == this;
    }

    protected final boolean reactivate() {
        return this.reactivate(true);
    }

    protected final boolean reactivate(boolean resetActiveTicks) {
        if (this.crafterID == null) {
            return false;
        }
        this.active = true;
        if (resetActiveTicks) {
            this.activeTicks = 0;
        }
        this.onCraftStart(null);
        this.syncAndSave();
        return true;
    }

    public final void setInactive() {
        this.onDeactivated();
        this.active = false;
        this.activeTicks = 0;
        this.tickContinuing = false;
        this.crafterID = null;
        this.syncAndSave();
    }

    protected void onDeactivated() {
    }

    public final int getStateFlags() {
        return this.stateFlags;
    }

    public final void setStateFlag(int mask) {
        this.stateFlags |= mask;
    }

    public final void clearStateFlag(int mask) {
        this.stateFlags &= ~mask;
    }

    public final boolean isFlagSet(int mask) {
        return (this.stateFlags & mask) != 0;
    }

    public final void syncAndSave() {
        if (!this.m_58904_().m_5776_()) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected abstract List<Integer> getSyncedInventorySlots();

    protected final ListTag saveSyncedInvData() {
        ListTag inventorySync = new ListTag();
        for (Integer i : this.getSyncedInventorySlots()) {
            CompoundTag sub = new CompoundTag();
            this.m_8020_(i).m_41739_(sub);
            inventorySync.add((Object)sub);
        }
        return inventorySync;
    }

    protected final void loadSyncedInvData(ListTag inventorySync) {
        List<Integer> slots = this.getSyncedInventorySlots();
        if (inventorySync.size() != slots.size()) {
            ManaAndArtifice.LOGGER.error("Failed to parse synced inventory data for tile " + this.m_58903_().toString() + " at " + this.m_58899_().m_123344_());
            return;
        }
        for (int i = 0; i < slots.size(); ++i) {
            int slot = slots.get(i);
            CompoundTag item = inventorySync.m_128728_(i);
            this.m_6836_(slot, ItemStack.m_41712_((CompoundTag)item));
        }
    }

    protected CompoundTag getMeta() {
        return new CompoundTag();
    }

    protected void loadMeta(CompoundTag tag) {
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        base.m_128365_("invSync", (Tag)this.saveSyncedInvData());
        base.m_128379_("toggle", this.syncToggle);
        base.m_128379_("active", this.active);
        base.m_128379_("ticking", this.tickContinuing);
        base.m_128405_("activeTicks", this.activeTicks);
        base.m_128405_("flags", this.stateFlags);
        if (this.crafterID != null) {
            base.m_128362_("crafter", this.crafterID);
        }
        base.m_128365_("meta", (Tag)this.getMeta());
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        boolean wasActive = this.active;
        this.loadSyncedInvData(tag.m_128437_("invSync", 10));
        this.active = tag.m_128471_("active");
        this.tickContinuing = tag.m_128471_("ticking");
        this.stateFlags = tag.m_128451_("flags");
        this.activeTicks = tag.m_128451_("activeTicks");
        if (tag.m_128441_("crafter")) {
            this.crafterID = tag.m_128342_("crafter");
        }
        this.loadMeta(tag.m_128469_("meta"));
        if (this.active && !wasActive && this.getAmbientSound() != null && this.shouldLoopingSoundPlay("active_loop")) {
            ManaAndArtifice.instance.proxy.playLoopingSound(this.getAmbientSound(), "active loop", this::shouldLoopingSoundPlay, 1.0f);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        boolean wasActive = this.active;
        this.loadSyncedInvData(tag.m_128437_("invSync", 10));
        this.active = tag.m_128471_("active");
        this.tickContinuing = tag.m_128471_("ticking");
        this.stateFlags = tag.m_128451_("flags");
        this.activeTicks = tag.m_128451_("activeTicks");
        this.loadMeta(tag.m_128469_("meta"));
        if (this.active && !wasActive && this.getAmbientSound() != null && this.shouldLoopingSoundPlay("active_loop")) {
            ManaAndArtifice.instance.proxy.playLoopingSound(this.getAmbientSound(), "active loop", this::shouldLoopingSoundPlay, 1.0f, this.f_58858_);
        }
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        if (this.getSyncedInventorySlots().contains(index)) {
            this.syncAndSave();
        }
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        ItemStack output = super.m_7407_(index, count);
        if (this.getSyncedInventorySlots().contains(index)) {
            this.syncAndSave();
        }
        return output;
    }

    @Override
    public void m_6211_() {
        super.m_6211_();
        this.syncAndSave();
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("flags", this.stateFlags);
        compound.m_128379_("active", this.active);
        compound.m_128379_("ticking", this.tickContinuing);
        compound.m_128405_("activeTicks", this.activeTicks);
        compound.m_128365_("meta", (Tag)this.getMeta());
        if (this.crafterID != null) {
            compound.m_128359_("crafter", this.crafterID.toString());
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.stateFlags = compound.m_128451_("flags");
        this.active = compound.m_128471_("active");
        if (compound.m_128441_("ticking")) {
            this.tickContinuing = compound.m_128471_("ticking");
        }
        if (compound.m_128441_("activeTicks")) {
            this.activeTicks = compound.m_128451_("activeTicks");
        }
        if (compound.m_128441_("meta")) {
            this.loadMeta(compound.m_128469_("meta"));
        }
        if (compound.m_128441_("crafter")) {
            try {
                this.crafterID = UUID.fromString(compound.m_128461_("crafter"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> this.handleAnimState((AnimationState<? extends WizardLabTile>)state))});
    }

    protected PlayState handleAnimState(AnimationState<? extends WizardLabTile> state) {
        return PlayState.STOP;
    }

    public boolean clickMenuButton(Player player, int button) {
        if (button == 0 && this.canActivate(player)) {
            this.setActive(player);
            return true;
        }
        return false;
    }
}

