/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.gui.containers.block.ContainerMagiciansWorkbench;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.RecipeUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class MagiciansWorkbenchTile
extends TileEntityWithInventory
implements MenuProvider,
Consumer<FriendlyByteBuf> {
    public static final int MAX_RECIPES = 8;
    public ResultContainer firstResultInv = new ResultContainer();
    public ResultContainer secondResultInv = new ResultContainer();
    private final LinkedList<RememberedRecipe> rememberedRecipes = new LinkedList();

    public MagiciansWorkbenchTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 38);
    }

    public MagiciansWorkbenchTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.MAGICIANS_WORKBENCH.get(), pos, state);
    }

    public MagiciansWorkbenchTile readFrom(FriendlyByteBuf data) {
        return this;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new ContainerMagiciansWorkbench(id, playerInventory, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"mna:container.magicians_workbench");
    }

    @Override
    public void accept(FriendlyByteBuf data) {
        data.m_130064_(this.m_58899_());
    }

    public void rememberRecipe(ItemStack output, ItemStack[] recipeItems) {
        if (output.m_41619_()) {
            return;
        }
        RecipeUtil.lookupCraftingRecipe(this.m_58904_(), recipeItems).ifPresent(resolvedRecipe -> {
            for (RememberedRecipe recipe : this.rememberedRecipes) {
                if (!recipe.recipeId.equals((Object)resolvedRecipe.m_6423_())) continue;
                return;
            }
            if (!this.popRecipe()) {
                return;
            }
            this.rememberedRecipes.add(new RememberedRecipe(resolvedRecipe.m_6423_(), output));
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        });
    }

    private boolean popRecipe() {
        if (this.rememberedRecipes.size() < 8) {
            return true;
        }
        for (int index = 0; index < this.rememberedRecipes.size(); ++index) {
            if (this.rememberedRecipes.get((int)index).isLocked) continue;
            this.rememberedRecipes.remove(index);
            return true;
        }
        return false;
    }

    public boolean toggleRecipeLock(int recipeIndex) {
        if (recipeIndex >= this.getRememberedRecipeItems().size()) {
            return false;
        }
        RememberedRecipe recipe = this.getRememberedRecipeItems().get(recipeIndex);
        if (recipe == null) {
            return false;
        }
        recipe.isLocked = !recipe.isLocked;
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return true;
    }

    public LinkedList<RememberedRecipe> getRememberedRecipeItems() {
        return this.rememberedRecipes;
    }

    private StackedContents fillStackedContents() {
        StackedContents contents = new StackedContents();
        for (int i = ContainerMagiciansWorkbench.INVENTORY_STORAGE_START; i <= ContainerMagiciansWorkbench.INVENTORY_STORAGE_END; ++i) {
            contents.m_36466_(this.m_8020_(i));
        }
        return contents;
    }

    public Pair<AutoCraftResult, ItemStack> craftFromRemembered(ItemStack desiredItem) {
        Optional<RememberedRecipe> remembered = this.rememberedRecipes.stream().filter(rr -> ItemStack.m_150942_((ItemStack)rr.output, (ItemStack)desiredItem)).findFirst();
        if (!remembered.isPresent()) {
            return new Pair((Object)AutoCraftResult.NO_RECIPE, (Object)ItemStack.f_41583_);
        }
        StackedContents contents = this.fillStackedContents();
        if (!contents.m_36475_((Recipe)remembered.get().getRecipe(this.f_58857_), (IntList)null)) {
            return new Pair((Object)AutoCraftResult.MISSING_ITEMS, (Object)ItemStack.f_41583_);
        }
        InvWrapper myInvWrapper = new InvWrapper((Container)this);
        block0: for (Ingredient ingred : remembered.get().getRecipe(this.f_58857_).m_7527_()) {
            if (ingred.m_43947_()) continue;
            for (int i = ContainerMagiciansWorkbench.INVENTORY_STORAGE_START; i <= ContainerMagiciansWorkbench.INVENTORY_STORAGE_END; ++i) {
                ItemStack existing = this.m_8020_(i);
                if (existing.m_41619_() || !ingred.test(existing)) continue;
                ItemStack resultStack = existing.getCraftingRemainingItem();
                existing.m_41774_(1);
                if (InventoryUtilities.mergeIntoInventory((IItemHandler)myInvWrapper, resultStack)) continue block0;
                Vec3 dropPos = Vec3.m_82512_((Vec3i)this.m_58899_());
                ItemEntity drop = new ItemEntity(this.m_58904_(), dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, resultStack);
                drop.m_20334_(0.0, 0.25, 0.0);
                drop.m_32060_();
                this.m_58904_().m_7967_((Entity)drop);
                continue block0;
            }
        }
        return new Pair((Object)AutoCraftResult.SUCCESS, (Object)remembered.get().output.m_41777_());
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ListTag recall = new ListTag();
        for (RememberedRecipe recipe : this.rememberedRecipes) {
            try {
                CompoundTag output = new CompoundTag();
                recipe.getOutput(this.f_58857_).m_41739_(output);
                output.m_128379_("isLocked", recipe.isLocked);
                output.m_128359_("recipeId", recipe.recipeId.toString());
                recall.add((Object)output);
            }
            catch (Throwable throwable) {}
        }
        compound.m_128365_("rememberedRecipes", (Tag)recall);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        ListTag recall = compound.m_128437_("rememberedRecipes", 10);
        this.rememberedRecipes.clear();
        if (recall != null) {
            for (int i = 0; i < recall.size(); ++i) {
                CompoundTag rememberedRecipe = (CompoundTag)recall.get(i);
                if (!rememberedRecipe.m_128441_("recipeId")) continue;
                ResourceLocation recipeId = new ResourceLocation(rememberedRecipe.m_128461_("recipeId"));
                ItemStack output = ItemStack.m_41712_((CompoundTag)rememberedRecipe);
                if (output.m_41619_()) continue;
                RememberedRecipe rec = new RememberedRecipe(recipeId, output);
                rec.isLocked = rememberedRecipe.m_128471_("isLocked");
                this.rememberedRecipes.add(rec);
            }
        }
        super.m_142466_(compound);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index < 18 || index > 37;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index < 18 || index > 37;
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return index < 18 || index > 37;
    }

    @Override
    public int[] m_7071_(Direction side) {
        int[] slots = new int[18];
        for (int i = 0; i < 18; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public class RememberedRecipe {
        public final ResourceLocation recipeId;
        private ItemStack output;
        private Ingredient[] ingredients;
        private CraftingRecipe recipe;
        private boolean isLocked;
        private boolean hasResolved = false;

        public RememberedRecipe(ResourceLocation recipeId, ItemStack output) {
            this.recipeId = recipeId;
            this.isLocked = false;
        }

        public void lock() {
            this.isLocked = true;
        }

        public void unlock() {
            this.isLocked = false;
        }

        public boolean isLocked() {
            return this.isLocked;
        }

        public ItemStack getOutput(Level world) {
            if (!this.hasResolved) {
                this.resolveRecipe(world);
            }
            return this.output;
        }

        public Ingredient[] getComponents(Level world) {
            if (!this.hasResolved) {
                this.resolveRecipe(world);
            }
            return this.ingredients;
        }

        @Nullable
        public CraftingRecipe getRecipe(Level world) {
            if (!this.hasResolved) {
                this.resolveRecipe(world);
            }
            return this.recipe;
        }

        private void resolveRecipe(Level world) {
            world.m_7465_().m_44043_(this.recipeId).ifPresent(recipe -> {
                if (recipe instanceof CraftingRecipe) {
                    this.output = recipe.m_8043_(world.m_9598_());
                    this.ingredients = (Ingredient[])recipe.m_7527_().toArray((Object[])new Ingredient[0]);
                    this.recipe = (CraftingRecipe)recipe;
                }
            });
            this.hasResolved = true;
        }
    }

    public static enum AutoCraftResult {
        MISSING_ITEMS,
        NO_RECIPE,
        SUCCESS;

    }
}

