/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.api.tools.RLoc;
import com.mna.blocks.tileentities.RunicLightTile;
import com.mna.gui.GuiTextures;
import com.mna.tools.render.ModelUtils;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class RunicLightRenderer
implements BlockEntityRenderer<RunicLightTile> {
    public static final ResourceLocation cube = RLoc.create("block/runic_light_cube");
    private final int[] lightRuneColor = new int[]{49, 235, 234};
    private final int[] torchColor = new int[]{252, 111, 3};

    public RunicLightRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(RunicLightTile pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        boolean powered = (Boolean)pBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61443_);
        Direction facing = (Direction)pBlockEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        long time = pBlockEntity.m_58904_().m_46467_();
        pPoseStack.m_85836_();
        switch (facing) {
            case EAST: {
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                pPoseStack.m_85837_(-0.5, 1.0, 0.6);
                break;
            }
            case WEST: {
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                pPoseStack.m_85837_(0.5, 1.0, -0.4);
                break;
            }
            case NORTH: {
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                pPoseStack.m_85837_(-0.5, 1.0, -0.4);
                break;
            }
            default: {
                pPoseStack.m_85837_(0.5, 1.0, 0.6);
            }
        }
        WorldRenderUtils.RenderRuneWord(pPoseStack, pBuffer, GuiTextures.Blocks.RUNES, pPackedLight, pBlockEntity.isTorch() ? this.torchColor : this.lightRuneColor, pBlockEntity.getRuneword(), powered ? 0.0f : 1.0f, 1);
        pPoseStack.m_85849_();
        if (!pBlockEntity.isTorch()) {
            pPoseStack.m_85836_();
            if (!powered) {
                double sinA = Math.sin(((float)time + pPartialTick) / 10.0f);
                double cosZ = Math.cos(((float)time + pPartialTick) / 10.0f);
                double sinB = Math.sin(((float)time + pPartialTick) / 20.0f);
                double offsetY = 0.075 * sinA;
                double offsetX = 0.035 * sinB;
                double offsetZ = 0.035 * cosZ;
                pPoseStack.m_85837_(0.5 + offsetX, 1.575 + offsetY, 0.5 + offsetZ);
                int rotation = (int)(time % 360L);
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_((float)rotation));
                pPoseStack.m_252781_(Axis.f_252403_.m_252977_((float)rotation));
            } else {
                pPoseStack.m_85837_(0.5, 1.4625, 0.5);
            }
            ModelUtils.renderModel(pBuffer, pBlockEntity.m_58904_(), pBlockEntity.m_58899_(), pBlockEntity.m_58900_(), cube, pPoseStack, pPackedLight, pPackedOverlay);
            pPoseStack.m_85849_();
        }
    }
}

