/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.api.tools.RLoc;
import com.mna.blocks.tileentities.RunicAnvilTile;
import com.mna.blocks.tileentities.models.RunicAnvilModel;
import com.mna.tools.render.ModelUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class RunicAnvilRenderer
extends GeoBlockRenderer<RunicAnvilTile> {
    public static final ResourceLocation ring_small = RLoc.create("block/runic_anvil/ring_small");
    public static final ResourceLocation ring_large = RLoc.create("block/runic_anvil/ring_large");
    private final ItemRenderer itemRenderer;
    protected Minecraft mc = Minecraft.m_91087_();

    public RunicAnvilRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new RunicAnvilModel());
        this.itemRenderer = this.mc.m_91291_();
    }

    public void actuallyRender(PoseStack poseStack, RunicAnvilTile animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderItems(animatable, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        super.actuallyRender(poseStack, (BlockEntity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRecursively(PoseStack stack, RunicAnvilTile animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.mc == null) {
            return;
        }
        stack.m_85836_();
        RenderUtils.translateMatrixToBone((PoseStack)stack, (CoreGeoBone)bone);
        RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
        RenderUtils.rotateMatrixAroundBone((PoseStack)stack, (CoreGeoBone)bone);
        RenderUtils.scaleMatrixForBone((PoseStack)stack, (CoreGeoBone)bone);
        BlockState state = animatable.m_58900_();
        BlockPos pos = animatable.m_58899_();
        if (!bone.isHidden()) {
            stack.m_85836_();
            switch (bone.getName()) {
                case "CIRCLE_BASE": {
                    ModelUtils.renderModel(bufferSource, (Level)this.mc.f_91073_, pos, state, ring_large, stack, packedLight, packedOverlay);
                    break;
                }
                case "CIRCLE_FRONT": 
                case "CIRCLE_REAR": {
                    ModelUtils.renderModel(bufferSource, (Level)this.mc.f_91073_, pos, state, ring_small, stack, packedLight, packedOverlay);
                }
            }
            stack.m_85849_();
            for (GeoBone childBone : bone.getChildBones()) {
                this.renderRecursively(stack, animatable, childBone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        stack.m_85849_();
    }

    private void renderItems(RunicAnvilTile anvil, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack[] stacks = anvil.getDisplayedItems();
        float offset = 0.03f;
        float craftPct = (float)anvil.craftProgress / (float)anvil.getMaxCraftProgress();
        matrixStackIn.m_85836_();
        if (!stacks[0].m_41619_()) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 1.025, 0.5);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.m_269128_(stacks[0], ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)this.mc.f_91073_, 0);
            matrixStackIn.m_85849_();
        }
        if (!stacks[1].m_41619_()) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 1.025 + (double)(offset - offset * craftPct), 0.5);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.m_269128_(stacks[1], ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)this.mc.f_91073_, 0);
            matrixStackIn.m_85849_();
        }
        matrixStackIn.m_85849_();
    }
}

