/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.ManaAndArtifice;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.events.GenericProgressionEvent;
import com.mna.api.events.ProgressionEventIDs;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.tools.RLoc;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.interop.lootr.ILootrBridge;
import com.mna.network.messages.to_client.ShowDidYouKnow;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.manaweaving.ManaweaveCacheEffect;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternHelper;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ManaweaveCacheTile
extends RandomizableContainerBlockEntity
implements ILootrBridge {
    public static final int NUM_PATTERNS = 3;
    public static final int INVENTORY_SIZE = 27;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    public Set<UUID> openers = new HashSet<UUID>();
    private long resetTime = -1L;
    private boolean isOpen = false;
    private float openPct = 0.0f;
    private boolean isBuff = false;
    private boolean generated = false;
    private int tier = 1;
    private UUID tileId;
    private ResourceLocation lootTableId;
    private long lootTableSeed;
    private ResourceLocation buff;
    private int amplifier = 0;
    private int duration = 1;
    private ResourceLocation[] requiredPatterns = new ResourceLocation[3];
    private ManaweavingPattern[] requiredPatternsCache = new ManaweavingPattern[3];
    private ArrayList<ResourceLocation> addedPatterns = new ArrayList();

    public ManaweaveCacheTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.MANAWEAVE_CACHE.get(), pos, state);
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, ManaweaveCacheTile tile) {
        if (!level.m_5776_() && !tile.generated) {
            tile.generate();
        }
        if (!level.m_5776_() && tile.isBuff && tile.shouldReset(state, System.currentTimeMillis())) {
            tile.reset(state);
            return;
        }
        if (tile.isOpen && tile.openPct < 1.0f) {
            tile.openPct += 0.1f;
        } else if (!tile.isOpen && tile.openPct > 0.0f) {
            tile.openPct -= 0.1f;
        }
        tile.openPct = MathUtils.clamp01(tile.openPct);
        if (tile.isOpen && level.m_5776_() && tile.isBuff) {
            Vec3 cp = Vec3.m_82512_((Vec3i)pos);
            level.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), cp.f_82479_, cp.f_82480_ + 0.675, cp.f_82481_, cp.f_82479_, cp.f_82480_ + 1.325, cp.f_82481_);
        }
    }

    public boolean notifyPattern(Player player, ResourceLocation pattern) {
        if (this.addedPatterns.size() >= 3) {
            return false;
        }
        if (this.requiredPatterns[this.addedPatterns.size()] == null) {
            return false;
        }
        if (!this.requiredPatterns[this.addedPatterns.size()].equals((Object)pattern)) {
            return false;
        }
        this.addedPatterns.add(pattern);
        this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (this.addedPatterns.size() >= 3) {
            this.open();
            MinecraftForge.EVENT_BUS.post((Event)new GenericProgressionEvent(player, ProgressionEventIDs.OPEN_CACHE));
            if (player instanceof ServerPlayer) {
                CustomAdvancementTriggers.OPEN_CACHE.trigger((ServerPlayer)player, this.tier);
            }
            if (this.isBuff) {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.buff);
                if (effect != null) {
                    player.m_7292_(new MobEffectInstance(effect, this.duration, this.amplifier, false, false, true));
                } else {
                    ManaAndArtifice.LOGGER.warn("Effect " + this.buff.toString() + " was not able to be resolved; skipping.");
                }
                ManaAndArtifice.instance.proxy.showDidYouKnow(player, ShowDidYouKnow.Messages.BUFF_CACHE);
            }
        }
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return true;
    }

    public float openPct() {
        return this.openPct;
    }

    private void open() {
        this.isOpen = true;
        long resetBase = 3600000L;
        this.resetTime = System.currentTimeMillis() + resetBase + (long)((int)(Math.random() * (double)resetBase));
        this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SFX.Event.Block.MANAWEAVE_CACHE_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void reset(BlockState state) {
        this.addedPatterns.clear();
        this.isOpen = false;
        this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SFX.Event.Block.MANAWEAVE_CACHE_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    private boolean shouldReset(BlockState state, long time) {
        return this.isBuff && this.isOpen && System.currentTimeMillis() >= this.resetTime;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isBuff() {
        return this.isBuff;
    }

    public ManaweavingPattern[] getRequiredPatterns() {
        if (this.generated && this.requiredPatternsCache[0] == null) {
            for (int i = 0; i < 3; ++i) {
                this.requiredPatternsCache[i] = ManaweavingPatternHelper.GetManaweavingRecipe(this.m_58904_(), this.requiredPatterns[i]);
            }
        }
        return this.requiredPatternsCache;
    }

    public boolean isPatternAdded(int index) {
        return this.addedPatterns.size() > index;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(5.0);
    }

    private void generate() {
        this.tier = (int)(Math.random() * 5.0) + 1;
        List<ResourceLocation> patterns = this.getPatternsForTier();
        if (patterns.size() == 0) {
            this.tier = 0;
            patterns = this.getPatternsForTier();
        }
        for (int i = 0; i < 3; ++i) {
            this.requiredPatterns[i] = patterns.get((int)(Math.random() * (double)patterns.size()));
        }
        boolean bl = this.isBuff = Math.random() < 0.25;
        if (this.isBuff) {
            this.pickEffectForTier();
        }
        if (!this.isBuff) {
            this.m_59626_(RLoc.create("structure/tier_" + this.tier + "_cache"), this.f_58857_.f_46441_.m_188505_());
        }
        this.tileId = UUID.randomUUID();
        this.generated = true;
        this.m_6596_();
        this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    private List<ResourceLocation> getPatternsForTier() {
        return this.m_58904_().m_7465_().m_44013_((RecipeType)RecipeInit.MANAWEAVING_PATTERN_TYPE.get()).stream().filter(r -> r.getTier() <= this.tier).map(r -> r.m_6423_()).collect(Collectors.toList());
    }

    private void pickEffectForTier() {
        List effects = this.m_58904_().m_7465_().m_44013_((RecipeType)RecipeInit.MANAWEAVE_CACHE_EFFECT_TYPE.get()).stream().filter(r -> r.getTier() <= this.tier).collect(Collectors.toList());
        if (effects.size() == 0) {
            this.isBuff = false;
            return;
        }
        ManaweaveCacheEffect myEffect = (ManaweaveCacheEffect)effects.get((int)(Math.random() * (double)effects.size()));
        this.buff = myEffect.getEffect();
        this.amplifier = myEffect.getMagnitude();
        this.duration = myEffect.getDurationMin() + (int)((double)(myEffect.getDurationMax() - myEffect.getDurationMin()) * Math.random());
    }

    private CompoundTag getCacheData() {
        int i;
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("generated", this.generated);
        if (!this.generated) {
            return tag;
        }
        tag.m_128350_("openPct", this.openPct);
        tag.m_128379_("isOpen", this.isOpen);
        tag.m_128379_("isBuff", this.isBuff);
        tag.m_128405_("tier", this.tier);
        tag.m_128359_("tileId", this.tileId.toString());
        if (this.lootTableId != null) {
            tag.m_128359_("lootTableId", this.lootTableId.toString());
            tag.m_128356_("lootTableSeed", this.lootTableSeed);
        }
        if (this.isBuff) {
            tag.m_128359_("buff", this.buff.toString());
            tag.m_128405_("amplifier", this.amplifier);
            tag.m_128405_("duration", this.duration);
        }
        for (i = 0; i < 3; ++i) {
            tag.m_128359_("pattern" + i, this.requiredPatterns[i] == null ? "" : this.requiredPatterns[i].toString());
        }
        tag.m_128405_("numAdded", this.addedPatterns.size());
        for (i = 0; i < this.addedPatterns.size(); ++i) {
            tag.m_128359_("added" + i, this.addedPatterns.get(i).toString());
        }
        ListTag list = new ListTag();
        for (UUID opener : this.openers) {
            list.add((Object)NbtUtils.m_129226_((UUID)opener));
        }
        tag.m_128365_("LootrOpeners", (Tag)list);
        return tag;
    }

    private void parseCachedData(CompoundTag tag) {
        int i;
        this.generated = tag.m_128471_("generated");
        if (!this.generated) {
            return;
        }
        this.openPct = tag.m_128457_("openPct");
        this.isOpen = tag.m_128471_("isOpen");
        this.isBuff = tag.m_128471_("isBuff");
        this.tier = tag.m_128451_("tier");
        this.tileId = UUID.fromString(tag.m_128461_("tileId"));
        if (tag.m_128441_("lootTableId")) {
            this.lootTableId = new ResourceLocation(tag.m_128461_("lootTableId"));
            this.lootTableSeed = tag.m_128454_("lootTableSeed");
        }
        if (this.isBuff) {
            this.buff = new ResourceLocation(tag.m_128461_("buff"));
            this.amplifier = tag.m_128451_("amplifier");
            this.duration = tag.m_128451_("duration");
        }
        for (i = 0; i < 3; ++i) {
            this.requiredPatterns[i] = new ResourceLocation(tag.m_128461_("pattern" + i));
        }
        this.addedPatterns.clear();
        for (i = 0; i < tag.m_128451_("numAdded"); ++i) {
            this.addedPatterns.add(new ResourceLocation(tag.m_128461_("added" + i)));
        }
        if (tag.m_128441_("LootrOpeners")) {
            ListTag openers = tag.m_128437_("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.m_129233_((Tag)item));
            }
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("cache_data", (Tag)this.getCacheData());
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.parseCachedData(compound.m_128469_("cache_data"));
        if (!this.m_59631_(compound)) {
            ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        }
    }

    public CompoundTag m_5995_() {
        return this.getCacheData();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.parseCachedData(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.parseCachedData(pkt.m_131708_());
        }
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"mna:container.manaweave_cache");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this);
    }

    @Override
    public UUID getTileId() {
        return this.tileId;
    }

    public void m_59626_(ResourceLocation lootTableIn, long seedIn) {
        this.lootTableId = lootTableIn;
        this.lootTableSeed = seedIn;
        super.m_59626_(lootTableIn, seedIn);
    }

    @Override
    public long getLootSeed() {
        return this.m_58904_().m_213780_().m_188505_();
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTableId;
    }

    @Override
    public void setLootrOpened(boolean opened) {
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    @Override
    public void updatePacketViaState() {
    }
}

