/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.ManaAndArtifice;
import com.mna.blocks.tileentities.init.TileEntityInit;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CoffinTile
extends BlockEntity {
    private Optional<UUID> player = Optional.empty();
    private Player cachedPlayer;

    public CoffinTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.COFFIN.get(), pos, state);
    }

    public void setRitualPlayer(Player player) {
        this.player = player == null ? Optional.empty() : Optional.of(player.m_36316_().getId());
        this.cachedPlayer = player;
    }

    public Player getRitualPlayer() {
        if (this.cachedPlayer == null && this.player.isPresent()) {
            this.cachedPlayer = this.m_58904_().m_46003_(this.player.get());
        }
        return this.cachedPlayer;
    }

    public void m_183515_(CompoundTag compound) {
        if (this.player.isPresent()) {
            compound.m_128359_("player", this.player.get().toString());
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("player")) {
            try {
                UUID playerId = UUID.fromString(nbt.m_128461_("player"));
                this.player = Optional.of(playerId);
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.warn("Unable to load player UUID for ritual coffin; it will simply act as a normal coffin.  This shouldn't happen, the save file was likely edited incorrectly.");
            }
        }
    }
}

