/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.tools.MATags;
import com.mna.blocks.ritual.ChalkRuneBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.extensions.IForgeBlockEntity;

public class ChalkRuneTile
extends TileEntityWithInventory
implements IForgeBlockEntity {
    private static final int MAX_ITEMS = 1;
    public static final int INVENTORY_SLOT_INDEX = 0;
    private boolean readOnly = false;
    private boolean ghostItem = false;

    public ChalkRuneTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, 1);
    }

    public ChalkRuneTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.CHALK_RUNE.get(), pos, state);
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        if (this.readOnly || this.ghostItem) {
            return;
        }
        super.m_6836_(index, stack);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    @Override
    public ItemStack m_8016_(int index) {
        if (this.readOnly || this.ghostItem) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = super.m_8016_(index);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return stack;
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        ItemStack out = super.m_7407_(index, count);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return out;
    }

    public void clearStack() {
        super.m_8016_(0);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setGhostItem(boolean ghost) {
        this.ghostItem = ghost;
    }

    public boolean isGhostItem() {
        return this.ghostItem;
    }

    @Override
    public int m_6643_() {
        return 1;
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        CompoundTag sub = new CompoundTag();
        this.m_8020_(0).m_41739_(sub);
        base.m_128365_("invSync", (Tag)sub);
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        CompoundTag sub = tag.m_128469_("invSync");
        this.m_6836_(0, ItemStack.m_41712_((CompoundTag)sub));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag sub = pkt.m_131708_().m_128469_("invSync");
        this.m_6836_(0, ItemStack.m_41712_((CompoundTag)sub));
    }

    public int m_6893_() {
        return 1;
    }

    public ItemStack getDisplayedItem() {
        return this.m_8020_(0);
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.m_8020_(0).m_41619_()) {
            return false;
        }
        return MATags.isItemEqual(this.m_8020_(0), rLoc);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("readOnly")) {
            this.readOnly = compound.m_128471_("readOnly");
        }
        if (compound.m_128441_("ghostItem")) {
            this.ghostItem = compound.m_128471_("ghostItem");
        }
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("readOnly", this.readOnly);
        compound.m_128379_("ghostItem", this.ghostItem);
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{0};
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        if (this.isGhostItem() || ((Boolean)this.m_58900_().m_61143_((Property)ChalkRuneBlock.ACTIVATED)).booleanValue()) {
            return false;
        }
        return this.m_8020_(0).m_41619_();
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (this.isGhostItem() || ((Boolean)this.m_58900_().m_61143_((Property)ChalkRuneBlock.ACTIVATED)).booleanValue()) {
            return false;
        }
        return !this.m_8020_(0).m_41619_();
    }
}

