/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.decoration;

import com.mna.api.blocks.ISpellInteractibleBlock;
import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.collections.Components;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.BrazierTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrazierBlock
extends WaterloggableBlock
implements EntityBlock,
ISpellInteractibleBlock<BrazierBlock> {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty AUTO_ACTIVATE = BooleanProperty.m_61465_((String)"auto_activate");
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])Direction.values());
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public BrazierBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 10.0f).m_60955_().m_60977_().m_60918_(SoundType.f_56762_).m_60960_(BlockInit.NEVER), false);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AUTO_ACTIVATE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE, AUTO_ACTIVATE, FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)AUTO_ACTIVATE)).booleanValue()) {
            BlockState newstate = state;
            if (worldIn.m_46462_() && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                newstate = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
            } else if (worldIn.m_46461_() && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                newstate = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
            }
            worldIn.m_7731_(pos, newstate, 1);
            worldIn.m_7260_(pos, state, newstate, 2);
            worldIn.m_186460_(pos, (Block)this, 20);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (!worldIn.f_46443_) {
            BlockState newstate = state;
            if (player.m_6047_()) {
                newstate = (BlockState)state.m_61124_((Property)AUTO_ACTIVATE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)AUTO_ACTIVATE) == false));
                if (((Boolean)newstate.m_61143_((Property)AUTO_ACTIVATE)).booleanValue()) {
                    player.m_213846_((Component)Component.m_237115_((String)"block.mna.brazier.auto_on"));
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"block.mna.brazier.auto_off"));
                }
                worldIn.m_186460_(pos, (Block)this, 20);
            } else {
                newstate = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)ACTIVE) == false));
            }
            worldIn.m_7731_(pos, newstate, 1);
            worldIn.m_7260_(pos, state, newstate, 2);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)ACTIVE)).booleanValue()) {
            int color = -1;
            BlockEntity be = worldIn.m_7702_(pos);
            if (be != null && be instanceof BrazierTile) {
                color = ((BrazierTile)be).getColor();
            }
            for (int i = 0; i < 20; ++i) {
                MAParticleType pfx = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setMaxAge((int)(20.0 + 20.0 * Math.random())).setScale(0.03f);
                if (color == -1) {
                    pfx.setColor(30, 172, 255);
                } else {
                    pfx.setColor(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), FastColor.ARGB32.m_13655_((int)color));
                }
                worldIn.m_7106_((ParticleOptions)pfx, (double)((float)pos.m_123341_() + 0.5f + (-0.175f + worldIn.m_213780_().m_188501_() * 0.35f)), (double)pos.m_123342_() + 0.2, (double)((float)pos.m_123343_() + 0.5f + (-0.175f + worldIn.m_213780_().m_188501_() * 0.35f)), 0.0, (double)0.02f, 0.0);
            }
        }
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState superState = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        Direction myFacing = (Direction)stateIn.m_61143_((Property)FACING);
        if (!this.isDirectionValidAnchor((LevelReader)worldIn, currentPos, myFacing)) {
            Direction newFacing = null;
            for (Direction dir : Direction.values()) {
                if (!this.isDirectionValidAnchor((LevelReader)worldIn, currentPos, dir)) continue;
                newFacing = dir;
                break;
            }
            if (newFacing == null) {
                newFacing = Direction.DOWN;
            }
            superState = (BlockState)superState.m_61124_((Property)FACING, (Comparable)newFacing);
        }
        return superState;
    }

    private boolean isDirectionValidAnchor(LevelReader world, BlockPos pos, Direction facing) {
        BlockPos facingPos = pos.m_121945_(facing);
        BlockState facingBlockState = world.m_8055_(facingPos);
        return facingBlockState.m_60783_((BlockGetter)world, facingPos, facing.m_122424_());
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            return 14;
        }
        return 0;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BrazierTile(pPos, pState);
    }

    @Override
    public boolean onHitBySpell(Level world, BlockPos pos, ISpellDefinition spell) {
        BlockEntity be = world.m_7702_(pos);
        if (be != null && be instanceof BrazierTile && spell.containsPart(Components.LIGHT.getRegistryName())) {
            ((BrazierTile)be).setColor(spell.getParticleColorOverride());
            return true;
        }
        return false;
    }
}

