/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.items;

import com.mna.api.ManaAndArtificeMod;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public class DynamicItemFilter {
    private NonNullList<ItemStack> _whiteList = NonNullList.m_122779_();
    private NonNullList<ItemStack> _blackList = NonNullList.m_122779_();
    private boolean _whitelistDamageMatching;
    private boolean _whitelistTagMatching;
    private boolean _blacklistDamageMatching;
    private boolean _blacklistTagMatching;

    public CompoundTag getTag() {
        CompoundTag tag = new CompoundTag();
        CompoundTag whitelist = new CompoundTag();
        CompoundTag blacklist = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)whitelist, this._whiteList);
        ContainerHelper.m_18973_((CompoundTag)blacklist, this._blackList);
        tag.m_128365_("whitelist", (Tag)whitelist);
        tag.m_128365_("blacklist", (Tag)blacklist);
        tag.m_128379_("whitelist_damage", this._whitelistDamageMatching);
        tag.m_128379_("whitelist_tag", this._whitelistTagMatching);
        tag.m_128379_("blacklist_damage", this._blacklistDamageMatching);
        tag.m_128379_("blacklist_tag", this._blacklistTagMatching);
        return tag;
    }

    public void loadFromTag(CompoundTag tag) {
        this.clear();
        if (tag.m_128441_("whitelist")) {
            this.loadItemsFromTag(tag.m_128469_("whitelist"), this._whiteList);
        }
        if (tag.m_128441_("blacklist")) {
            this.loadItemsFromTag(tag.m_128469_("blacklist"), this._blackList);
        }
        if (tag.m_128441_("whitelist_damage")) {
            this._whitelistDamageMatching = tag.m_128471_("whitelist_damage");
        }
        if (tag.m_128441_("whitelist_tag")) {
            this._whitelistTagMatching = tag.m_128471_("whitelist_tag");
        }
        if (tag.m_128441_("blacklist_damage")) {
            this._blacklistDamageMatching = tag.m_128471_("blacklist_damage");
        }
        if (tag.m_128441_("blacklist_tag")) {
            this._blacklistTagMatching = tag.m_128471_("blacklist_tag");
        }
    }

    private void loadItemsFromTag(CompoundTag tag, NonNullList<ItemStack> list) {
        list.clear();
        ListTag listtag = tag.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            list.add((Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)tag, list);
    }

    public void setWhitelist(NonNullList<ItemStack> items, boolean matchDamage, boolean matchTag) {
        this._whiteList = NonNullList.m_182647_((int)24);
        this._whiteList.addAll(items);
        this._whitelistDamageMatching = matchDamage;
        this._whitelistTagMatching = matchTag;
    }

    public void setBlacklist(NonNullList<ItemStack> items, boolean matchDamage, boolean matchTag) {
        this._blackList = NonNullList.m_182647_((int)24);
        this._blackList.addAll(items);
        this._blacklistDamageMatching = matchDamage;
        this._blacklistTagMatching = matchTag;
    }

    public NonNullList<ItemStack> getWhiteList() {
        return this._whiteList;
    }

    public NonNullList<ItemStack> getBlackList() {
        return this._blackList;
    }

    public boolean isWhitelistEmpty() {
        for (int i = 0; i < this._whiteList.size(); ++i) {
            if (((ItemStack)this._whiteList.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isBlacklistEmpty() {
        for (int i = 0; i < this._blackList.size(); ++i) {
            if (((ItemStack)this._blackList.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.isWhitelistEmpty() && this.isBlacklistEmpty();
    }

    private boolean matchStack(ItemStack check, NonNullList<ItemStack> filterList, boolean matchDamage, boolean matchTags) {
        return filterList.stream().anyMatch(is -> {
            if (is.m_41720_() != check.m_41720_()) {
                return false;
            }
            if (matchDamage && check.m_41773_() < is.m_41773_()) {
                return false;
            }
            return !matchTags || ManaAndArtificeMod.getItemHelper().AreTagsEqual((ItemStack)is, check);
        });
    }

    public void copyFrom(DynamicItemFilter other) {
        if (other == null) {
            return;
        }
        this.setWhitelist(other.getWhiteList(), other._whitelistDamageMatching, other._whitelistTagMatching);
        this.setBlacklist(other.getBlackList(), other._blacklistDamageMatching, other._blacklistTagMatching);
    }

    public void clear() {
        this._whiteList = NonNullList.m_122779_();
        this._blackList = NonNullList.m_122779_();
    }

    public boolean matches(ItemStack stack) {
        return (this.isWhitelistEmpty() || this.matchStack(stack, this._whiteList, this._whitelistDamageMatching, this._whitelistTagMatching)) && !this.matchStack(stack, this._blackList, this._blacklistDamageMatching, this._blacklistTagMatching);
    }

    public boolean getWhitelistMatchDurability() {
        return this._whitelistDamageMatching;
    }

    public boolean getWhitelistMatchTag() {
        return this._whitelistTagMatching;
    }

    public boolean getBlacklistMatchTag() {
        return this._blacklistTagMatching;
    }

    public boolean getBlacklistMatchDurability() {
        return this._blacklistDamageMatching;
    }

    public int hashStack(ItemStack stack) {
        int itemHash = stack.m_41720_().hashCode();
        if (this.isWhitelistEmpty()) {
            return itemHash;
        }
        if (this._whitelistDamageMatching) {
            itemHash += stack.m_41773_();
        }
        if (this._whitelistTagMatching && stack.m_41782_()) {
            itemHash += stack.m_41783_().hashCode();
        }
        return itemHash;
    }
}

