/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.gui;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.PowerStatus;
import com.mna.api.blocks.tile.pylon.PylonTileBase;
import com.mna.api.gui.SingleItemSlot;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class ContainerPylon
extends AbstractContainerMenu {
    protected final PylonTileBase tile;
    protected final IItemHandler tileItemHandler;
    protected final Player user;

    public ContainerPylon(int i, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(i, playerInventory, (PylonTileBase)playerInventory.f_35978_.m_9236_().m_7702_(packetBuffer.m_130135_()));
    }

    public ContainerPylon(int i, Inventory playerInv, PylonTileBase tile) {
        super(ManaAndArtificeMod.getContainerHelper().GetPylonContainerType(), i);
        this.user = playerInv.f_35978_;
        this.tile = tile;
        this.tileItemHandler = new InvWrapper((Container)tile);
        this.initializeSlots(playerInv);
    }

    private void initializeSlots(Inventory playerInventory) {
        int xpos;
        Item markingRune = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mna", "rune_marking"));
        this.m_38897_((Slot)new SingleItemSlot(this.tileItemHandler, 0, 100, 19, markingRune).setMaxStackSize(1));
        this.m_38897_((Slot)new SingleItemSlot(this.tileItemHandler, 1, 118, 19, markingRune).setMaxStackSize(1));
        for (xpos = 0; xpos < 3; ++xpos) {
            for (int ypos = 0; ypos < 9; ++ypos) {
                this.m_38897_(new Slot((Container)playerInventory, ypos + xpos * 9 + 9, this.playerInventoryXStart() + ypos * 18, this.playerInventoryYStart() + xpos * 18));
            }
        }
        for (xpos = 0; xpos < 9; ++xpos) {
            this.m_38897_(new Slot((Container)playerInventory, xpos, this.playerInventoryXStart() + xpos * 18, this.playerInventoryYStart() + 58));
        }
    }

    protected int playerInventoryXStart() {
        return 37;
    }

    protected int playerInventoryYStart() {
        return 73;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.tile.m_6643_() ? !this.m_38903_(itemstack1, this.tile.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.tile.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return pPlayer != null && pPlayer.m_20238_(Vec3.m_82512_((Vec3i)this.tile.m_58899_())) < 64.0;
    }

    public HashMap<Affinity, PowerStatus> powerRequirementStatus() {
        return this.tile.powerRequirementStatus();
    }

    public boolean isRedstonePowered() {
        return this.tile.isRedstonePowered();
    }

    public boolean affectFactionOnly() {
        return this.tile.isFactionOnly();
    }

    public int getRadius() {
        return this.tile.getRadius();
    }

    public float getMultiplier() {
        return this.tile.getPowerMultiplier();
    }

    @Nullable
    public String getErrorMessage() {
        return this.tile.getErrorMessage();
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        switch (pId) {
            case 0: {
                this.tile.setFactionOnly(!this.tile.isFactionOnly());
                break;
            }
            case 1: {
                int r = this.tile.getRadius();
                if (r < 16) {
                    r = 0;
                }
                this.tile.setRadius(r + 16);
                break;
            }
            case 2: {
                this.tile.setRadius(this.tile.getRadius() - 16);
            }
        }
        return true;
    }

    public float getPowerRequestRate(Affinity affinity) {
        return this.tile.getPowerRequestRate(affinity);
    }

    public String getFactionCheckboxTooltip() {
        return this.tile.getFactionCheckboxTooltip();
    }
}

