/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.entities.construct.ai;

import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.phys.Vec3;

public class ConstructFleeTarget
extends AvoidEntityGoal<LivingEntity> {
    final IConstruct<?> construct;

    public ConstructFleeTarget(IConstruct<?> construct, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
        super((PathfinderMob)construct.asEntity(), LivingEntity.class, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier);
        this.construct = construct;
    }

    public boolean m_8036_() {
        if (this.construct.getIntelligence() < 16 || this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.BLOCK) || !this.construct.getConstructData().isAnyCapabilityEnabled(ConstructCapability.CAST_SPELL, ConstructCapability.RANGED_ATTACK, ConstructCapability.FLUID_DISPENSE)) {
            return false;
        }
        AbstractGolem constructEntity = this.construct.asEntity();
        this.f_25016_ = constructEntity.m_5448_();
        if (this.f_25016_ == null) {
            return false;
        }
        if (constructEntity.m_20270_((Entity)this.f_25016_) > 4.0f || this.construct.isRangedAttacking()) {
            return false;
        }
        Vec3 vec3 = ConstructFleeTarget.getPosAway(this.construct, 10, 7, this.f_25016_.m_20182_());
        if (vec3 == null) {
            return false;
        }
        if (this.f_25016_.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.f_25016_.m_20280_((Entity)this.f_25015_)) {
            return false;
        }
        if (this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.FLY)) {
            int count = 0;
            while (count < 5 && constructEntity.m_9236_().m_46859_(BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_))) {
                ++count;
                vec3 = vec3.m_82520_(0.0, 1.0, 0.0);
            }
            vec3 = vec3.m_82492_(0.0, 1.0, 0.0);
        }
        this.f_25018_ = this.f_25019_.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        return this.f_25018_ != null;
    }

    @Nullable
    private static Vec3 getPosAway(IConstruct<?> pMob, int pRadius, int pYRange, Vec3 pVectorPosition) {
        AbstractGolem constructEntity = pMob.asEntity();
        Vec3 vec3 = constructEntity.m_20182_().m_82546_(pVectorPosition);
        return RandomPos.m_148542_((PathfinderMob)constructEntity, () -> {
            BlockPos blockpos = RandomPos.m_217855_((RandomSource)constructEntity.m_217043_(), (int)pRadius, (int)pYRange, (int)0, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
            return blockpos == null ? null : ConstructFleeTarget.generateRandomPosTowardDirection(pMob, pRadius, false, blockpos);
        });
    }

    @Nullable
    private static BlockPos generateRandomPosTowardDirection(IConstruct<?> pMob, int pRadius, boolean pShortCircuit, BlockPos pPos) {
        AbstractGolem constructEntity = pMob.asEntity();
        BlockPos blockpos = RandomPos.m_217863_((PathfinderMob)constructEntity, (int)pRadius, (RandomSource)constructEntity.m_217043_(), (BlockPos)pPos);
        if (!pMob.getConstructData().isCapabilityEnabled(ConstructCapability.FLY) && GoalUtils.m_148448_((PathNavigation)constructEntity.m_21573_(), (BlockPos)blockpos)) {
            return null;
        }
        return !GoalUtils.m_148451_((BlockPos)blockpos, (PathfinderMob)constructEntity) && !GoalUtils.m_148458_((PathfinderMob)constructEntity, (BlockPos)blockpos) ? blockpos : null;
    }
}

