/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.entities.construct;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.effects.MAEffects;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.events.construct.FluidParameterRegistrationEvent;
import com.mna.api.faction.FactionIDs;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import org.apache.commons.lang3.function.TriFunction;

@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FluidParameterRegistry {
    Function<Vec3, Vec3> ADJUST_DEFAULT = vel -> vel.m_82524_((float)(-0.25 * Math.random() + 0.5)).m_82541_().m_82490_((double)0.35f);
    HashMap<Fluid, FluidParameter> __registry = new HashMap();
    public static final FluidParameterRegistry INSTANCE = new FluidParameterRegistry();

    public void registerDefaults() {
        this.__registry.put(Fluids.f_76191_, new FluidParameter(Fluids.f_76191_, false, false, SFX.Entity.Construct.SPRAY_GENERIC, new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get())), 0.35f, 10, null, this.ADJUST_DEFAULT));
        this.__registry.put((Fluid)Fluids.f_76193_, new FluidParameter((Fluid)Fluids.f_76193_, true, true, SFX.Entity.Construct.SPRAY_GENERIC, (ParticleOptions)ParticleTypes.f_123769_, 0.5f, 20, (living, isFriendly, construct) -> {
            if (living == null) {
                return false;
            }
            if (isFriendly.booleanValue()) {
                if (living instanceof Player && !((Player)living).m_7500_() && construct.getIntelligence() >= 16) {
                    IPlayerProgression progression = (IPlayerProgression)living.getCapability(ManaAndArtificeMod.getProgressionCapability()).orElse(null);
                    MobEffectInstance soaked = ((Player)living).m_21124_(MAEffects.SOAKED);
                    if (progression != null && progression.getAlliedFaction() != null && progression.getAlliedFaction().is(FactionIDs.UNDEAD) && living.m_9236_().m_45527_(living.m_20183_()) && (soaked == null || soaked.m_19557_() < 20)) {
                        return true;
                    }
                }
                return living.m_6060_();
            }
            if (living instanceof Creeper && ((Creeper)living).m_21023_(MAEffects.SOAKED)) {
                return false;
            }
            return true;
        }, vel -> {
            Vec3 adjusted = vel.m_82524_((float)(-0.25 + Math.random() * 0.5)).m_82541_().m_82490_(0.75 + Math.random() * 0.25);
            adjusted = adjusted.m_82492_(0.0, adjusted.f_82480_, 0.0);
            return adjusted;
        }));
        this.__registry.put((Fluid)Fluids.f_76195_, new FluidParameter((Fluid)Fluids.f_76195_, false, true, SFX.Entity.Construct.SPRAY_FIRE, new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setScale(0.13f).setPhysics(true), 0.35f, 10, null, null));
        this.__registry.put((Fluid)ForgeMod.MILK.get(), new FluidParameter((Fluid)ForgeMod.MILK.get(), true, true, SFX.Entity.Construct.SPRAY_GENERIC, new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setScale(0.15f).setColor(250, 250, 250), 0.35f, 10, (entity, isFriendly, construct) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (isFriendly.booleanValue()) {
                    return living.m_21220_().stream().anyMatch(effect -> !effect.m_19544_().m_19486_() && effect.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_)));
                }
                return living.m_21220_().stream().anyMatch(effect -> effect.m_19544_().m_19486_() && effect.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_)));
            }
            return false;
        }, null));
    }

    public void register(FluidParameter parameter) {
        this.__registry.put(parameter.fluid, parameter);
    }

    public FluidParameter forFluid(Fluid fluid) {
        return this.__registry.getOrDefault(fluid, this.__registry.get(Fluids.f_76191_));
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        INSTANCE.registerDefaults();
        FluidParameterRegistrationEvent evt = new FluidParameterRegistrationEvent(INSTANCE);
        MinecraftForge.EVENT_BUS.post((Event)evt);
    }

    public static class FluidParameter {
        final boolean targetsFriendly;
        final boolean targetsHostile;
        final Fluid fluid;
        final SoundEvent spraySound;
        @Nullable
        final TriFunction<Entity, Boolean, IConstruct<?>, Boolean> targetPredicate;
        final Function<Vec3, Vec3> adjustParticleVelocity;
        final ParticleOptions fluidParticle;
        final float particleVelocityScale;
        final int particleQuantity;

        public FluidParameter(Fluid forFluid, boolean targetAllies, boolean targetEnemies, SoundEvent spraySound, ParticleOptions type, float particleVelocityScale, int particleQuantity, @Nullable TriFunction<Entity, Boolean, IConstruct<?>, Boolean> targetPredicate, Function<Vec3, Vec3> adjustParticleVelocity) {
            this.fluid = forFluid;
            this.targetsFriendly = targetAllies;
            this.targetsHostile = targetEnemies;
            this.spraySound = spraySound;
            this.targetPredicate = targetPredicate;
            this.fluidParticle = type;
            this.particleVelocityScale = particleVelocityScale;
            this.adjustParticleVelocity = adjustParticleVelocity;
            this.particleQuantity = particleQuantity;
        }

        public boolean targetsFriendly() {
            return this.targetsFriendly;
        }

        public boolean targetsHostile() {
            return this.targetsHostile;
        }

        public Fluid fluid() {
            return this.fluid;
        }

        public boolean checkPredicate(Entity e, boolean isFriendly, IConstruct<?> construct) {
            if (this.targetPredicate == null) {
                return isFriendly ? this.targetsFriendly : this.targetsHostile;
            }
            return (Boolean)this.targetPredicate.apply((Object)e, (Object)isFriendly, construct);
        }

        public ParticleOptions particle() {
            return this.fluidParticle;
        }

        public SoundEvent spraySound() {
            return this.spraySound;
        }

        public float getParticleVelocityScale() {
            return this.particleVelocityScale;
        }

        public Vec3 adjustVelocity(Vec3 vel) {
            if (this.adjustParticleVelocity != null) {
                return this.adjustParticleVelocity.apply(vel);
            }
            return vel;
        }

        public int getParticleQuantity() {
            return this.particleQuantity;
        }
    }
}

