/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks.tile;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.PlayerOwnershipRecord;
import com.mna.api.blocks.tile.IEldrinCapacitorTile;
import com.mna.api.capabilities.IChunkMagic;
import com.mna.api.capabilities.IWellspringNodeRegistry;
import com.mna.capabilities.chunkdata.ChunkMagicProvider;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;

public interface IEldrinConsumerTile {
    @Deprecated
    default public float consume(Player player, BlockPos blockPos, Vec3 destPos, Affinity type, float amount, float minimumSupply) {
        if (player == null || player.m_36316_() == null || player.m_36316_().getId() == null) {
            return 0.0f;
        }
        return this.consume(PlayerOwnershipRecord.of(player), player.m_9236_(), blockPos, destPos, type, amount, minimumSupply);
    }

    @Deprecated
    default public float consume(Player player, BlockPos blockPos, Vec3 destPos, Affinity type, float amount) {
        if (player == null || player.m_36316_() == null || player.m_36316_().getId() == null) {
            return 0.0f;
        }
        return this.consume(PlayerOwnershipRecord.of(player), player.m_9236_(), blockPos, destPos, type, amount, -1.0f);
    }

    default public float consume(PlayerOwnershipRecord owner, Level world, BlockPos blockPos, Vec3 destPos, Affinity type, float amount) {
        return this.consume(owner, world, blockPos, destPos, type, amount, -1.0f);
    }

    default public float consume(PlayerOwnershipRecord owner, Level world, BlockPos blockPos, Vec3 destPos, Affinity type, float amount, float minimumSupply) {
        if (owner == null) {
            return 0.0f;
        }
        float supplied = 0.0f;
        LevelChunk chunkAccess = world.m_46745_(blockPos);
        ChunkPos chunkPos = chunkAccess.m_7697_();
        ArrayList suppliers = new ArrayList();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                chunkAccess = world.m_6325_(chunkPos.f_45578_ + i, chunkPos.f_45579_ + j);
                chunkAccess.getCapability(ChunkMagicProvider.MAGIC).ifPresent(c -> suppliers.addAll(c.getKnownEldrinSuppliers().stream().map(l -> BlockPos.m_122022_((long)l)).collect(Collectors.toList())));
            }
        }
        boolean foundOneSupplier = false;
        for (BlockPos pos : suppliers) {
            IEldrinCapacitorTile supplier;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity == null || !(blockEntity instanceof IEldrinCapacitorTile) || !(supplier = (IEldrinCapacitorTile)blockEntity).canSupply(type, owner) || !(pos.m_123331_((Vec3i)blockPos) <= (double)(supplier.getDispersalRadius() * supplier.getDispersalRadius()))) continue;
            foundOneSupplier = true;
            if (minimumSupply > 0.0f && supplier.getChargeRate() < minimumSupply || !((supplied += supplier.supply(owner, destPos, type, amount - supplied, false)) >= amount)) continue;
            break;
        }
        if (!foundOneSupplier) {
            return -1.0f;
        }
        IChunkMagic chunkMagic = (IChunkMagic)world.m_46745_(blockPos).getCapability(ChunkMagicProvider.MAGIC).orElse(null);
        if (chunkMagic != null) {
            chunkMagic.addResidualMagic(supplied * 0.1f);
        }
        return supplied;
    }

    default public float consumeDirect(UUID owner, Level world, Affinity type, float amount) {
        MutableFloat consumed = new MutableFloat(0.0f);
        world.getCapability(ManaAndArtificeMod.getWorldMagicCapability()).ifPresent(magic -> {
            IWellspringNodeRegistry wellsprings = magic.getWellspringRegistry();
            if (wellsprings != null) {
                consumed.setValue(wellsprings.consumePower(owner, world, type, amount));
            }
        });
        return consumed.getValue().floatValue();
    }
}

