/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks.tile;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class BlockPosCache {
    public static final int MAX_BLOCKS_CHECKED_PER_TICK = 50;
    private AABB powerSearchArea = null;
    private NonNullList<BlockPos> cachedBlocks;
    private boolean searchingSurroundings = false;
    private BlockPos lastSearchPos;
    int searchRadius;
    boolean finishedSearchingThisTick = false;
    private final BlockEntity parent;
    private final BiPredicate<BlockPos, Level> blockValidCheck;

    public BlockPosCache(BlockEntity parent, int radius, BiPredicate<BlockPos, Level> blockValid) {
        this.searchRadius = radius;
        this.cachedBlocks = NonNullList.m_122779_();
        this.parent = parent;
        this.blockValidCheck = blockValid;
    }

    public void tick() {
        this.finishedSearchingThisTick = false;
        if (this.searchingSurroundings) {
            this.search();
        }
    }

    public void search() {
        int x = this.lastSearchPos.m_123341_();
        int y = this.lastSearchPos.m_123342_();
        int z = this.lastSearchPos.m_123343_();
        int count = 0;
        while ((double)x <= this.powerSearchArea.f_82291_) {
            while ((double)y <= this.powerSearchArea.f_82292_) {
                while ((double)z <= this.powerSearchArea.f_82293_) {
                    BlockPos curSearch = new BlockPos(x, y, z);
                    if (!curSearch.equals((Object)this.parent.m_58899_())) {
                        if (this.parent.m_58904_().m_46749_(curSearch) && this.blockValidCheck.test(curSearch, this.parent.m_58904_())) {
                            this.cachedBlocks.add((Object)curSearch);
                        }
                        if (++count >= 50) {
                            this.lastSearchPos = new BlockPos(x, y, z);
                            return;
                        }
                    }
                    ++z;
                }
                z = (int)this.powerSearchArea.f_82290_;
                ++y;
            }
            y = (int)this.powerSearchArea.f_82289_;
            ++x;
        }
        this.searchingSurroundings = false;
        this.finishedSearchingThisTick = true;
    }

    public NonNullList<BlockPos> getCachedPositions() {
        return this.cachedBlocks;
    }

    public void queueRecheck() {
        this.searchingSurroundings = true;
        this.cachedBlocks.clear();
        BlockPos myPos = this.parent.m_58899_();
        this.powerSearchArea = new AABB(myPos).m_82400_((double)this.searchRadius);
        this.lastSearchPos = new BlockPos((int)this.powerSearchArea.f_82288_, (int)this.powerSearchArea.f_82289_, (int)this.powerSearchArea.f_82290_);
    }

    public boolean isSearching() {
        return this.searchingSurroundings;
    }

    public boolean finishedSearchingThisTick() {
        return this.finishedSearchingThisTick;
    }

    public void insert(BlockPos blockPos) {
        if (!this.cachedBlocks.contains((Object)blockPos) && !blockPos.equals((Object)this.parent.m_58899_()) && this.blockValidCheck.test(blockPos, this.parent.m_58904_())) {
            this.cachedBlocks.add((Object)blockPos);
        }
    }

    public void remove(BlockPos blockpos) {
        this.cachedBlocks.remove((Object)blockpos);
    }
}

