/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks;

import com.mna.api.blocks.WaterloggableBlockWithOffset;
import com.mna.api.blocks.interfaces.ICutoutBlock;
import com.mna.api.blocks.interfaces.IWizardLabConnect;
import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.tools.BlockUtilities;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public abstract class WizardLabBlock
extends WaterloggableBlockWithOffset
implements SimpleWaterloggedBlock,
ICutoutBlock,
IWizardLabConnect {
    public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final VoxelShape BASE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)2.0, (double)5.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)1.0, (double)13.0, (double)5.0, (double)15.0, (double)15.0, (double)15.0)});
    public static final VoxelShape LEFT_FRONT_PILLAR = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)2.0, (double)2.0, (double)2.0, (double)12.0, (double)3.0), Block.m_49796_((double)0.0, (double)12.0, (double)1.0, (double)3.0, (double)13.0, (double)4.0), Block.m_49796_((double)1.0, (double)13.0, (double)2.0, (double)2.0, (double)15.0, (double)3.0)});
    public static final VoxelShape RIGHT_FRONT_PILLAR = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)14.0, (double)2.0, (double)2.0, (double)15.0, (double)12.0, (double)3.0), Block.m_49796_((double)13.0, (double)12.0, (double)1.0, (double)16.0, (double)13.0, (double)4.0), Block.m_49796_((double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)15.0, (double)3.0)});
    public static final VoxelShape TABLETOP = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape NORTH_BASE_STANDALONE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEFT_FRONT_PILLAR, RIGHT_FRONT_PILLAR, TABLETOP});
    public static final VoxelShape NORTH_BASE_CONNECT_RIGHT = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEFT_FRONT_PILLAR, TABLETOP});
    public static final VoxelShape NORTH_BASE_CONNECT_LEFT = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{RIGHT_FRONT_PILLAR, TABLETOP});
    public static final VoxelShape NORTH_BASE_CONNECT_BOTH = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)TABLETOP);
    public static final HashMap<Direction, VoxelShape[]> VOXEL_LOOKUP = new HashMap();

    public WizardLabBlock(BlockBehaviour.Properties blockProperties, BlockPos ... offsets) {
        super(blockProperties, false, offsets);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    protected abstract MenuProvider getProvider(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6);

    protected Consumer<FriendlyByteBuf> getContainerBufferWriter(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return null;
    }

    public boolean canConnectToDirection(BlockState thisState, BlockState otherState, Direction dir) {
        if (dir == Direction.UP || dir == Direction.DOWN) {
            return false;
        }
        return otherState.m_60734_() instanceof IWizardLabConnect && this.directionToLeftRightProperty(thisState, dir) != null;
    }

    protected boolean shouldPlayAmbient(BlockState state, Level world, BlockPos pos, RandomSource rnd) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rnd) {
        if (this.shouldPlayAmbient(state, world, pos, rnd) && this.getAmbientSound() != null) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            if (rnd.m_188500_() < 0.1) {
                world.m_7785_(d0, d1, d2, this.getAmbientSound(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider provider = this.getProvider(state, level, pos, player, hand, hitResult);
        if (provider == null) {
            return InteractionResult.SUCCESS;
        }
        Consumer<FriendlyByteBuf> dataWriter = this.getContainerBufferWriter(state, level, pos, player, hand, hitResult);
        if (dataWriter == null) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)pos);
        } else {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, dataWriter);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LEFT, RIGHT, HorizontalDirectionalBlock.f_54117_});
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false;
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction blockFacingDirection = context.m_8125_().m_122424_();
        Level blockgetter = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction leftDir = blockFacingDirection.m_122428_();
        Direction rightDir = blockFacingDirection.m_122427_();
        BlockState leftNeighborState = blockgetter.m_8055_(blockpos.m_7918_(leftDir.m_122429_(), leftDir.m_122430_(), leftDir.m_122431_()));
        BlockState rightNeighborState = blockgetter.m_8055_(blockpos.m_7918_(rightDir.m_122429_(), rightDir.m_122430_(), rightDir.m_122431_()));
        BlockState baseState = super.m_5573_(context);
        BlockState disconnectedState = (BlockState)baseState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)blockFacingDirection);
        return (BlockState)((BlockState)((BlockState)baseState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)blockFacingDirection)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(this.canConnectToDirection(disconnectedState, leftNeighborState, leftDir)))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(this.canConnectToDirection(disconnectedState, rightNeighborState, rightDir)));
    }

    @Override
    public BlockState m_7417_(BlockState myState, Direction direction, BlockState otherState, LevelAccessor accessor, BlockPos myPos, BlockPos otherPos) {
        BooleanProperty prop;
        if (((Boolean)myState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            accessor.m_186469_(myPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return (prop = this.directionToLeftRightProperty(myState, direction)) != null ? (BlockState)myState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(this.canConnectToDirection(myState, otherState, direction))) : myState;
    }

    @Nullable
    private BooleanProperty directionToLeftRightProperty(BlockState myState, Direction direction) {
        Direction myDir = (Direction)myState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Direction myLeft = myDir.m_122428_();
        Direction myRight = myDir.m_122427_();
        if (direction == myLeft) {
            return LEFT;
        }
        if (direction == myRight) {
            return RIGHT;
        }
        return null;
    }

    public static Vec3i getOffsetLeft(BlockState myState) {
        Direction myDir = (Direction)myState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Direction myLeft = myDir.m_122428_();
        return myLeft.m_122436_();
    }

    public static Vec3i getOffsetRight(BlockState myState) {
        Direction myDir = (Direction)myState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Direction myRight = myDir.m_122427_();
        return myRight.m_122436_();
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropInventory(worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof TileEntityWithInventory) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileEntity));
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int connectedLeft = (Boolean)pState.m_61143_((Property)LEFT) != false ? 2 : 0;
        int connectedRight = (Boolean)pState.m_61143_((Property)RIGHT) != false ? 1 : 0;
        Direction facing = (Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        VoxelShape[] voxels = VOXEL_LOOKUP.getOrDefault(facing, new VoxelShape[]{Shapes.m_83144_()});
        int connectionIndex = connectedRight | connectedLeft;
        return voxels[connectionIndex % voxels.length];
    }

    static {
        VOXEL_LOOKUP.put(Direction.NORTH, new VoxelShape[]{NORTH_BASE_STANDALONE, NORTH_BASE_CONNECT_RIGHT, NORTH_BASE_CONNECT_LEFT, NORTH_BASE_CONNECT_BOTH});
        VOXEL_LOOKUP.put(Direction.SOUTH, new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, NORTH_BASE_STANDALONE), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, NORTH_BASE_CONNECT_RIGHT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, NORTH_BASE_CONNECT_LEFT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, NORTH_BASE_CONNECT_BOTH)});
        VOXEL_LOOKUP.put(Direction.EAST, new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, NORTH_BASE_STANDALONE), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, NORTH_BASE_CONNECT_RIGHT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, NORTH_BASE_CONNECT_LEFT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, NORTH_BASE_CONNECT_BOTH)});
        VOXEL_LOOKUP.put(Direction.WEST, new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, NORTH_BASE_STANDALONE), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, NORTH_BASE_CONNECT_RIGHT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, NORTH_BASE_CONNECT_LEFT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, NORTH_BASE_CONNECT_BOTH)});
    }
}

