/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.AbstractStorageTerminalBlock;
import com.tom.storagemod.gui.StorageTerminalMenu;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.tile.InventoryCableConnectorBlockEntity;
import com.tom.storagemod.util.PlayerInvUtil;
import com.tom.storagemod.util.StoredItemStack;
import com.tom.storagemod.util.TickerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageTerminalBlockEntity
extends BlockEntity
implements MenuProvider,
TickerUtil.TickableServer {
    private IItemHandler itemHandler;
    private Map<StoredItemStack, Long> items = new HashMap<StoredItemStack, Long>();
    private int sort;
    private String lastSearch = "";
    private boolean updateItems;
    private int beaconLevel;

    public StorageTerminalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.terminalTile.get(), pos, state);
    }

    public StorageTerminalBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory plInv, Player arg2) {
        return new StorageTerminalMenu(id, plInv, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"ts.storage_terminal");
    }

    public Map<StoredItemStack, Long> getStacks() {
        this.updateItems = true;
        return this.items;
    }

    public StoredItemStack pullStack(StoredItemStack stack, long max) {
        if (stack != null && this.itemHandler != null && max > 0L) {
            ItemStack st = stack.getStack();
            StoredItemStack ret = null;
            for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
                ItemStack pulled;
                ItemStack s = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.m_150942_((ItemStack)s, (ItemStack)st) || (pulled = this.itemHandler.extractItem(i, (int)max, false)).m_41619_()) continue;
                if (ret == null) {
                    ret = new StoredItemStack(pulled);
                } else {
                    ret.grow(pulled.m_41613_());
                }
                if ((max -= (long)pulled.m_41613_()) < 1L) break;
            }
            return ret;
        }
        return null;
    }

    public StoredItemStack pullStackFuzzy(StoredItemStack stack, long max) {
        if (stack != null && this.itemHandler != null && max > 0L) {
            ItemStack st = stack.getStack();
            StoredItemStack ret = null;
            for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
                ItemStack pulled;
                ItemStack s = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.m_41656_((ItemStack)s, (ItemStack)st) || !ItemStack.m_150942_((ItemStack)s, (ItemStack)st) && s.m_41793_() || (pulled = this.itemHandler.extractItem(i, (int)max, false)).m_41619_()) continue;
                if (ret == null) {
                    ret = new StoredItemStack(pulled);
                } else {
                    ret.grow(pulled.m_41613_());
                }
                if ((max -= (long)pulled.m_41613_()) < 1L) break;
            }
            return ret;
        }
        return null;
    }

    public StoredItemStack pushStack(StoredItemStack stack) {
        if (stack != null && this.itemHandler != null) {
            ItemStack is = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)stack.getActualStack(), (boolean)false);
            if (is.m_41619_()) {
                return null;
            }
            return new StoredItemStack(is);
        }
        return stack;
    }

    public ItemStack pushStack(ItemStack itemstack) {
        StoredItemStack is = this.pushStack(new StoredItemStack(itemstack));
        return is == null ? ItemStack.f_41583_ : is.getActualStack();
    }

    public void pushOrDrop(ItemStack st) {
        if (st.m_41619_()) {
            return;
        }
        StoredItemStack st0 = this.pushStack(new StoredItemStack(st));
        if (st0 != null) {
            this.dropItem(st0.getActualStack());
        }
    }

    public void dropItem(ItemStack stack) {
        Containers.m_18992_((Level)this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), (ItemStack)stack);
    }

    @Override
    public void updateServer() {
        if (this.updateItems) {
            BlockState st = this.f_58857_.m_8055_(this.f_58858_);
            Direction d = (Direction)st.m_61143_((Property)AbstractStorageTerminalBlock.FACING);
            AbstractStorageTerminalBlock.TerminalPos p2 = (AbstractStorageTerminalBlock.TerminalPos)((Object)st.m_61143_(AbstractStorageTerminalBlock.TERMINAL_POS));
            if (p2 == AbstractStorageTerminalBlock.TerminalPos.UP) {
                d = Direction.UP;
            }
            if (p2 == AbstractStorageTerminalBlock.TerminalPos.DOWN) {
                d = Direction.DOWN;
            }
            BlockEntity invTile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(d));
            this.items.clear();
            if (invTile != null) {
                LazyOptional lih = invTile.getCapability(ForgeCapabilities.ITEM_HANDLER, d.m_122424_());
                this.itemHandler = (IItemHandler)lih.orElse(null);
                if (this.itemHandler != null) {
                    IntStream.range(0, this.itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)this.itemHandler).getStackInSlot(arg_0)).filter(s -> !s.m_41619_()).map(StoredItemStack::new).forEach(s -> this.items.merge((StoredItemStack)s, s.getQuantity(), (a, b) -> a + b));
                }
            } else {
                this.itemHandler = null;
            }
            this.updateItems = false;
        }
        if (this.f_58857_.m_46467_() % 40L == 5L) {
            this.beaconLevel = BlockPos.m_121921_((AABB)new AABB(this.f_58858_).m_82400_(8.0)).mapToInt(p -> {
                BlockState st;
                if (this.f_58857_.m_46749_(p) && (st = this.f_58857_.m_8055_(p)).m_60713_(Blocks.f_50273_)) {
                    return InventoryCableConnectorBlockEntity.calcBeaconLevel(this.f_58857_, p.m_123341_(), p.m_123342_(), p.m_123343_());
                }
                return -1;
            }).max().orElse(-1);
        }
    }

    public boolean canInteractWith(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        int d = 4;
        int termReach = PlayerInvUtil.findItem(player, i -> i.m_41720_() instanceof WirelessTerminal, 0, i -> ((WirelessTerminal)i.m_41720_()).getRange(player, (ItemStack)i));
        if (Config.get().wirelessTermBeaconLvl != -1 && this.beaconLevel >= Config.get().wirelessTermBeaconLvl && termReach > 0) {
            if (Config.get().wirelessTermBeaconLvlDim != -1 && this.beaconLevel >= Config.get().wirelessTermBeaconLvlDim) {
                return true;
            }
            return player.m_9236_() == this.f_58857_;
        }
        d = Math.max(d, termReach);
        return player.m_9236_() == this.f_58857_ && !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > (double)(d * 2 * d * 2));
    }

    public int getSorting() {
        return this.sort;
    }

    public void setSorting(int newC) {
        this.sort = newC;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("sort", this.sort);
    }

    public void m_142466_(CompoundTag compound) {
        this.sort = compound.m_128451_("sort");
        super.m_142466_(compound);
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public void setLastSearch(String string) {
        this.lastSearch = string;
    }

    public int getBeaconLevel() {
        return this.beaconLevel;
    }
}

