/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.item;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageModClient;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.item.WirelessTerminal;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class AdvWirelessTerminalItem
extends Item
implements WirelessTerminal {
    public AdvWirelessTerminalItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        StorageModClient.tooltip("adv_wireless_terminal", tooltip, Config.get().advWirelessRange);
        if (Config.get().wirelessTermBeaconLvl != -1) {
            StorageModClient.tooltip("adv_wireless_terminal.beacon1", false, tooltip, Config.get().wirelessTermBeaconLvl);
            if (Config.get().wirelessTermBeaconLvlDim != -1) {
                StorageModClient.tooltip("adv_wireless_terminal.beacon2", false, tooltip, Config.get().wirelessTermBeaconLvlDim);
            }
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BindX")) {
            int x = stack.m_41783_().m_128451_("BindX");
            int y = stack.m_41783_().m_128451_("BindY");
            int z = stack.m_41783_().m_128451_("BindZ");
            String dim = stack.m_41783_().m_128461_("BindDim");
            tooltip.add((Component)Component.m_237110_((String)"tooltip.toms_storage.adv_wireless_terminal.bound", (Object[])new Object[]{x, y, z, dim}));
        }
        tooltip.add((Component)Component.m_237110_((String)"tooltip.toms_storage.adv_wireless_terminal.keybind", (Object[])new Object[]{Component.m_237110_((String)"tooltip.toms_storage.adv_wireless_terminal.keybind.outline", (Object[])new Object[]{Component.m_237117_((String)"key.toms_storage.open_terminal")}).m_130940_(ChatFormatting.GREEN)}));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        return new InteractionResultHolder(AdvWirelessTerminalItem.activateTerminal(worldIn, playerIn.m_21120_(handIn), playerIn, handIn), (Object)playerIn.m_21120_(handIn));
    }

    public static InteractionResult activateTerminal(Level worldIn, ItemStack stack, Player playerIn, InteractionHand handIn) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BindX")) {
            if (!worldIn.f_46443_) {
                int x = stack.m_41783_().m_128451_("BindX");
                int y = stack.m_41783_().m_128451_("BindY");
                int z = stack.m_41783_().m_128451_("BindZ");
                String dim = stack.m_41783_().m_128461_("BindDim");
                ServerLevel termWorld = worldIn.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dim)));
                if (termWorld.m_46749_(new BlockPos(x, y, z))) {
                    BlockHitResult lookingAt = new BlockHitResult(new Vec3((double)x, (double)y, (double)z), Direction.UP, new BlockPos(x, y, z), true);
                    BlockState state = termWorld.m_8055_(lookingAt.m_82425_());
                    if (state.m_204336_(StorageTags.REMOTE_ACTIVATE)) {
                        InteractionResult r = state.m_60664_((Level)termWorld, playerIn, handIn, lookingAt);
                        return r;
                    }
                    playerIn.m_5661_((Component)Component.m_237115_((String)"chat.toms_storage.terminal_invalid_block"), true);
                } else {
                    playerIn.m_5661_((Component)Component.m_237115_((String)"chat.toms_storage.terminal_out_of_range"), true);
                }
            } else {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext c) {
        if (c.m_7078_()) {
            if (!c.m_43725_().f_46443_) {
                BlockPos pos = c.m_8083_();
                BlockState state = c.m_43725_().m_8055_(pos);
                if (state.m_204336_(StorageTags.REMOTE_ACTIVATE)) {
                    ItemStack stack = c.m_43722_();
                    if (!stack.m_41782_()) {
                        stack.m_41751_(new CompoundTag());
                    }
                    stack.m_41783_().m_128405_("BindX", pos.m_123341_());
                    stack.m_41783_().m_128405_("BindY", pos.m_123342_());
                    stack.m_41783_().m_128405_("BindZ", pos.m_123343_());
                    stack.m_41783_().m_128359_("BindDim", c.m_43725_().m_46472_().m_135782_().toString());
                    if (c.m_43723_() != null) {
                        c.m_43723_().m_5661_((Component)Component.m_237115_((String)"chat.toms_storage.terminal_bound"), true);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getRange(Player pl, ItemStack stack) {
        return Config.get().advWirelessRange;
    }

    @Override
    public void open(Player sender, ItemStack t) {
        AdvWirelessTerminalItem.activateTerminal(sender.m_9236_(), t, sender, InteractionHand.MAIN_HAND);
    }

    @Override
    public boolean canOpen(ItemStack t) {
        return true;
    }
}

