/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.LargeIceDripstoneConfiguration;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util.DripstoneIceUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;

public class LargeIceDripstoneFeature
extends Feature<LargeIceDripstoneConfiguration> {
    public LargeIceDripstoneFeature(Codec<LargeIceDripstoneConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<LargeIceDripstoneConfiguration> featurePlaceContext) {
        Object t;
        WorldGenLevel worldGenLevel = featurePlaceContext.m_159774_();
        BlockPos origin = featurePlaceContext.m_159777_();
        SectionPos originSectionPos = SectionPos.m_123199_((BlockPos)origin);
        LargeIceDripstoneConfiguration config = (LargeIceDripstoneConfiguration)featurePlaceContext.m_159778_();
        RandomSource random = featurePlaceContext.m_225041_();
        if (!DripstoneIceUtils.isEmptyOrWater((LevelAccessor)worldGenLevel, origin)) {
            return false;
        }
        Optional optionalColumn = Column.m_158175_((LevelSimulatedReader)worldGenLevel, (BlockPos)origin, (int)config.floorToCeilingSearchRange, DripstoneUtils::m_159664_, DripstoneUtils::m_159649_);
        if (optionalColumn.isEmpty() || !((t = optionalColumn.get()) instanceof Column.Range)) {
            return false;
        }
        Column.Range range = (Column.Range)t;
        if (range.m_158214_() < 4) {
            return false;
        }
        int maxColumnRadius = (int)((float)range.m_158214_() * config.maxColumnRadiusToCaveHeightRatio);
        maxColumnRadius = Mth.m_14045_((int)maxColumnRadius, (int)config.columnRadius.m_142739_(), (int)config.columnRadius.m_142737_());
        int columnRadius = Mth.m_216287_((RandomSource)random, (int)config.columnRadius.m_142739_(), (int)maxColumnRadius);
        LargeIceDripstone stalactite = LargeIceDripstoneFeature.makeIceDripstone(origin.m_175288_(range.m_158212_() - 1), false, random, columnRadius, config.stalactiteBluntness, config.heightScale);
        LargeIceDripstone stalagmite = LargeIceDripstoneFeature.makeIceDripstone(origin.m_175288_(range.m_158213_() + 1), true, random, columnRadius, config.stalagmiteBluntness, config.heightScale);
        WindOffsetter windOffsetter = stalactite.isSuitableForWind(config) && stalagmite.isSuitableForWind(config) ? new WindOffsetter(origin.m_123342_(), random, config.windSpeed, config.angle) : WindOffsetter.noWind();
        boolean canSpawnStalactite = stalactite.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldGenLevel, windOffsetter);
        boolean canspawnStalagmite = stalagmite.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldGenLevel, windOffsetter);
        if (canSpawnStalactite) {
            stalactite.placeBlocks(worldGenLevel, random, windOffsetter, config.rareIceChance, originSectionPos);
        }
        if (canspawnStalagmite) {
            stalagmite.placeBlocks(worldGenLevel, random, windOffsetter, config.rareIceChance, originSectionPos);
        }
        return true;
    }

    private static LargeIceDripstone makeIceDripstone(BlockPos blockPos, boolean isPointingUp, RandomSource random, int radius, FloatProvider bluntnessProvider, FloatProvider scaleProvider) {
        return new LargeIceDripstone(blockPos, isPointingUp, radius, bluntnessProvider.m_214084_(random), scaleProvider.m_214084_(random));
    }

    private void placeDebugMarkers(WorldGenLevel worldGenLevel, BlockPos blockPos, Column.Range range, WindOffsetter windOffsetter) {
        worldGenLevel.m_7731_(windOffsetter.offset(blockPos.m_175288_(range.m_158212_() - 1)), Blocks.f_50090_.m_49966_(), 2);
        worldGenLevel.m_7731_(windOffsetter.offset(blockPos.m_175288_(range.m_158213_() + 1)), Blocks.f_50074_.m_49966_(), 2);
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_175288_(range.m_158213_() + 2).m_122032_();
        while (mutableBlockPos.m_123342_() < range.m_158212_() - 1) {
            BlockPos blockPos2 = windOffsetter.offset((BlockPos)mutableBlockPos);
            if (DripstoneIceUtils.isEmptyOrWater((LevelAccessor)worldGenLevel, blockPos2) || worldGenLevel.m_8055_(blockPos2).m_60713_(Blocks.f_152537_)) {
                worldGenLevel.m_7731_(blockPos2, Blocks.f_50318_.m_49966_(), 2);
            }
            mutableBlockPos.m_122173_(Direction.UP);
        }
    }

    static final class LargeIceDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeIceDripstone(BlockPos root, boolean pointingUp, int radius, double bluntness, double scale) {
            this.root = root;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel worldGenLevel, WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos mutable = this.root.m_122032_();
                for (int i = 0; i < Math.min(10, this.getHeight()); ++i) {
                    if (worldGenLevel.m_8055_((BlockPos)mutable).m_60713_(Blocks.f_49991_)) {
                        return false;
                    }
                    if (DripstoneIceUtils.isCircleMostlyEmbeddedInStone(worldGenLevel, windOffsetter.offset((BlockPos)mutable), this.radius)) {
                        this.root = mutable;
                        return true;
                    }
                    mutable.m_122173_(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radialDistance) {
            return (int)DripstoneIceUtils.getDripstoneHeight(radialDistance, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel worldGenLevel, RandomSource random, WindOffsetter windOffsetter, float rareIceChance, SectionPos originSectionPos) {
            boolean hasRareIce;
            boolean bl = hasRareIce = random.m_188501_() < rareIceChance;
            if (this.getHeightAtRadius(0.0f) < 6) {
                hasRareIce = false;
            }
            for (int dx = -this.radius; dx <= this.radius; ++dx) {
                block1: for (int dz = -this.radius; dz <= this.radius; ++dz) {
                    int heightAtCurrPos;
                    float distToCenter = Mth.m_14116_((float)(dx * dx + dz * dz));
                    if (!(distToCenter <= (float)this.radius) || (heightAtCurrPos = this.getHeightAtRadius(distToCenter)) <= 0) continue;
                    if (random.m_188500_() < 0.2) {
                        heightAtCurrPos = (int)((float)heightAtCurrPos * Mth.m_216283_((RandomSource)random, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos mutable = this.root.m_7918_(dx, 0, dz).m_122032_();
                    boolean placed = false;
                    int surfaceHeight = this.pointingUp ? worldGenLevel.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, mutable.m_123341_(), mutable.m_123343_()) : Integer.MAX_VALUE;
                    for (int dy = 0; dy < heightAtCurrPos && mutable.m_123342_() < surfaceHeight; ++dy) {
                        BlockPos blockPos = windOffsetter.offset((BlockPos)mutable);
                        if (DripstoneIceUtils.isEmptyOrWaterOrLava((LevelAccessor)worldGenLevel, blockPos)) {
                            placed = true;
                            Block block = Blocks.f_50354_;
                            if (hasRareIce) {
                                double progress = (double)dy / (double)heightAtCurrPos;
                                if (dx == 0 && dz == 0 && dy == (int)((double)heightAtCurrPos / 2.2)) {
                                    block = (Block)BlockModule.RARE_ICE.get();
                                } else if (progress > 0.3 + random.m_188500_() * 0.04) {
                                    block = Blocks.f_50126_;
                                }
                            }
                            if (this.isBlockInPlacementRange(originSectionPos, blockPos)) {
                                worldGenLevel.m_7731_(blockPos, block.m_49966_(), 2);
                            }
                        } else if (placed && worldGenLevel.m_8055_(blockPos).m_204336_(BlockTags.f_13061_)) continue block1;
                        mutable.m_122173_(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        private boolean isSuitableForWind(LargeIceDripstoneConfiguration largeDripstoneConfiguration) {
            return this.radius >= largeDripstoneConfiguration.minRadiusForWind && this.bluntness >= (double)largeDripstoneConfiguration.minBluntnessForWind;
        }

        private boolean isBlockInPlacementRange(SectionPos originSectionPos, BlockPos blockPos) {
            SectionPos blockSectionPos = SectionPos.m_123199_((BlockPos)blockPos);
            return Mth.m_14040_((int)(originSectionPos.m_123170_() - blockSectionPos.m_123170_())) <= 1 && Mth.m_14040_((int)(originSectionPos.m_123222_() - blockSectionPos.m_123222_())) <= 1;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int originY, RandomSource random, FloatProvider windSpeedProvider, FloatProvider angleProvider) {
            this.originY = originY;
            float speedAmp = windSpeedProvider.m_214084_(random);
            float radAngle = angleProvider.m_214084_(random);
            this.windSpeed = new Vec3((double)(Mth.m_14089_((float)radAngle) * speedAmp), 0.0, (double)(Mth.m_14031_((float)radAngle) * speedAmp));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos blockPos) {
            if (this.windSpeed == null) {
                return blockPos;
            }
            int dy = this.originY - blockPos.m_123342_();
            Vec3 vec3 = this.windSpeed.m_82490_((double)dy);
            return blockPos.m_7918_((int)vec3.f_82479_, 0, (int)vec3.f_82481_);
        }
    }
}

